/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;

public class ReflectiveClasses
extends BytecodeScanningDetector
implements Detector,
NonReportingDetector {
    String constantString;

    public ReflectiveClasses(BugReporter bugReporter) {
    }

    public void sawString(String s) {
        this.constantString = s;
    }

    public void sawClass() {
        if (this.getOpcode() == 18) {
            this.process(this.getClassConstantOperand());
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 184 && this.constantString != null && this.getClassConstantOperand().equals("java/lang/Class") && this.getNameConstantOperand().equals("forName")) {
            this.process(ClassName.toSlashedClassName((String)this.constantString));
        }
        this.constantString = null;
    }

    private void process(@SlashedClassName String className) {
        ClassDescriptor d = DescriptorFactory.createClassDescriptor((String)className);
        AnalysisContext.currentXFactory().addReflectiveClasses(d);
    }
}

