/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.PruneUnconditionalExceptionThrowerEdges;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class CloneIdiom
extends DismantleBytecode
implements Detector,
StatelessDetector {
    private ClassDescriptor cloneDescriptor = DescriptorFactory.createClassDescriptor((String)"java/lang/Cloneable");
    boolean hasCloneMethod;
    MethodAnnotation cloneMethodAnnotation;
    boolean referencesCloneMethod;
    boolean invokesSuperClone;
    boolean isFinal;
    boolean cloneOnlyThrowsException;
    boolean check;
    boolean implementsCloneableDirectly;
    private BugReporter bugReporter;

    public CloneIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals("clone") && this.getMethodSig().startsWith("()")) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && this.getNameConstantOperand().equals("clone") && this.getSigConstantOperand().startsWith("()")) {
            this.invokesSuperClone = true;
        }
    }

    public void visit(JavaClass obj) {
        String[] interface_names;
        this.implementsCloneableDirectly = false;
        this.invokesSuperClone = false;
        this.cloneOnlyThrowsException = false;
        this.check = false;
        this.isFinal = obj.isFinal();
        if (obj.isInterface()) {
            return;
        }
        if (obj.isAbstract()) {
            return;
        }
        for (String interface_name : interface_names = obj.getInterfaceNames()) {
            if (!interface_name.equals("java.lang.Cloneable")) continue;
            this.implementsCloneableDirectly = true;
            break;
        }
        if (this.implementsCloneableDirectly) {
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            try {
                if (subtypes2.isSubtype(DescriptorFactory.createClassDescriptorFromDottedClassName((String)obj.getSuperclassName()), this.cloneDescriptor)) {
                    this.implementsCloneableDirectly = false;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        this.hasCloneMethod = false;
        this.referencesCloneMethod = false;
        this.check = true;
        super.visit(obj);
    }

    public void visitAfter(JavaClass obj) {
        if (!this.check) {
            return;
        }
        if (this.cloneOnlyThrowsException) {
            return;
        }
        if (this.implementsCloneableDirectly && !this.hasCloneMethod && !this.referencesCloneMethod) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "CN_IDIOM", 2).addClass((PreorderVisitor)this));
        }
        if (this.hasCloneMethod && !this.invokesSuperClone && !this.isFinal && obj.isPublic()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "CN_IDIOM_NO_SUPER_CALL", obj.isPublic() || obj.isProtected() ? 2 : 3).addClass((PreorderVisitor)this).addMethod(this.cloneMethodAnnotation));
        }
    }

    public void visit(ConstantNameAndType obj) {
        String methodName = obj.getName(this.getConstantPool());
        String methodSig = obj.getSignature(this.getConstantPool());
        if (!methodName.equals("clone")) {
            return;
        }
        if (!methodSig.startsWith("()")) {
            return;
        }
        this.referencesCloneMethod = true;
    }

    public void visit(Method obj) {
        if (obj.isAbstract()) {
            return;
        }
        if (!obj.isPublic()) {
            return;
        }
        if (!this.getMethodName().equals("clone")) {
            return;
        }
        if (!this.getMethodSig().startsWith("()")) {
            return;
        }
        this.hasCloneMethod = true;
        this.cloneMethodAnnotation = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
        this.cloneOnlyThrowsException = PruneUnconditionalExceptionThrowerEdges.doesMethodUnconditionallyThrowException((XMethod)XFactory.createXMethod((PreorderVisitor)this));
    }

    public void report() {
    }
}

