/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.util.Util;
import de.tobject.findbugs.view.AbstractFindbugsView;
import de.tobject.findbugs.view.DetailsView;
import de.tobject.findbugs.view.UserAnnotationsView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class BugTreeView
extends AbstractFindbugsView {
    public HashMap<String, Tree> projectToTreeMap;
    private static final String KEY_MARKER = "marker";
    private static final String KEY_GROUP = "group";
    private MarkerJob markerJob = new MarkerJob("Bug tree update job");
    private volatile boolean disposed;
    private ResourceChangeListener resourceListener;

    public BugTreeView() {
        this.markerJob.setSystem(true);
        this.markerJob.setPriority(50);
    }

    static IMarker getMarkerForTreeItem(TreeItem theItem) {
        if (theItem != null) {
            return (IMarker)theItem.getData(KEY_MARKER);
        }
        return null;
    }

    public Composite createRootControl(Composite parent) {
        IProject[] projectList;
        TabFolder theFolder = new TabFolder(parent, 16384);
        this.projectToTreeMap = new HashMap();
        this.resourceListener = new ResourceChangeListener();
        for (IProject proj : projectList = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!proj.isOpen() || !Util.isJavaProject(proj)) continue;
            this.resourceListener.resourceChanged(true, new ResourceDelta[]{new ResourceDelta((IResource)proj, 1)});
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        return theFolder;
    }

    public void dispose() {
        this.disposed = true;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.markerJob.cancel();
        this.projectToTreeMap.clear();
        super.dispose();
    }

    private void addMarker(IProject theProject, final IProgressMonitor monitor, final IMarker ... markerArr) {
        if (theProject == null) {
            return;
        }
        final String projectName = theProject.getName();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                for (int i = 0; i < markerArr.length && !monitor.isCanceled() && !BugTreeView.this.disposed; ++i) {
                    IMarker theMarker = markerArr[i];
                    BugTreeView.this.addMarker(theMarker, projectName);
                }
            }
        });
    }

    private void removeMarker(IProject theProject, final boolean removeProject, final IProgressMonitor monitor, final IResource ... resources) {
        if (theProject == null) {
            return;
        }
        final String projectName = theProject.getName();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (removeProject) {
                    BugTreeView.this.removeMarker(null, projectName, true);
                } else {
                    for (int i = 0; i < resources.length && !monitor.isCanceled() && !BugTreeView.this.disposed; ++i) {
                        BugTreeView.this.removeMarker(resources[i], projectName, removeProject);
                    }
                }
            }
        });
    }

    private synchronized void removeMarker(IResource resource, String projectName, boolean removeProject) {
        Tree theTree = this.projectToTreeMap.get(projectName);
        if (this.disposed || theTree == null || theTree.isDisposed()) {
            return;
        }
        if (removeProject) {
            this.projectToTreeMap.remove(projectName);
            TabFolder rootControl = (TabFolder)this.getRootControl();
            TabItem[] items = rootControl.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].getText().equals(projectName)) continue;
                items[i].getControl().dispose();
                items[i].setControl(null);
                items[i].dispose();
                break;
            }
            theTree.dispose();
            return;
        }
        HashMap groupMap = (HashMap)theTree.getData(KEY_GROUP);
        TreeItem[] groupItems = theTree.getItems();
        for (int i = 0; i < groupItems.length; ++i) {
            TreeItem[] items = groupItems[i].getItems();
            for (int j = 0; j < items.length; ++j) {
                IMarker marker = (IMarker)items[j].getData(KEY_MARKER);
                if (!resource.equals(marker.getResource())) continue;
                items[j].dispose();
                if (groupItems[i].getItemCount() != 0) continue;
                String groupName = marker.getAttribute("PATTERN_DESCR_SHORT", "Unknown pattern");
                groupMap.remove(groupName);
                groupItems[i].dispose();
            }
        }
    }

    private synchronized void addMarker(IMarker theMarker, String projectName) {
        String groupName;
        HashMap groupMap;
        TreeItem groupItem;
        if (this.disposed) {
            return;
        }
        Tree theTree = this.projectToTreeMap.get(projectName);
        if (theTree == null || theTree.isDisposed()) {
            theTree = this.createNewProjectTree(projectName);
            this.projectToTreeMap.put(projectName, theTree);
        }
        if (((groupItem = (TreeItem)(groupMap = (HashMap)theTree.getData(KEY_GROUP)).get(groupName = theMarker.getAttribute("PATTERN_DESCR_SHORT", "Unknown pattern"))) == null || groupItem.isDisposed()) && (groupItem = this.createNewGroup(theTree, groupName)) != null) {
            groupMap.put(groupName, groupItem);
        }
        this.createNewInstanceItem(theMarker, groupItem);
    }

    private Tree createNewProjectTree(String projectName) {
        TabItem newProjectTab = new TabItem((TabFolder)this.getRootControl(), 16384);
        newProjectTab.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
        final Tree newProjectTree = new Tree(this.getRootControl(), 18432);
        newProjectTree.setData(KEY_GROUP, new HashMap());
        newProjectTree.addSelectionListener((SelectionListener)new BugTreeSelectionListener(newProjectTree));
        newProjectTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem theItem = BugTreeView.this.getFirstSelectedElement(newProjectTree);
                IMarker myMarker = BugTreeView.getMarkerForTreeItem(theItem);
                if (myMarker == null) {
                    return;
                }
                FindbugsPlugin.showMarker(myMarker);
                try {
                    IDE.openEditor((IWorkbenchPage)BugTreeView.this.getSite().getPage(), (IMarker)myMarker, (boolean)false);
                }
                catch (PartInitException ex) {
                    FindbugsPlugin.getDefault().logException(ex, "Exception on opening editor");
                }
            }
        });
        newProjectTab.setControl((Control)newProjectTree);
        newProjectTab.setText(projectName);
        return newProjectTree;
    }

    private TreeItem createNewGroup(Tree projectTree, String pattern) {
        int nextIdx;
        for (nextIdx = 0; nextIdx < projectTree.getItemCount() && projectTree.getItem(nextIdx).getText().compareTo(pattern) <= 0; ++nextIdx) {
        }
        TreeItem groupItem = new TreeItem(projectTree, 16384, nextIdx);
        groupItem.setText(pattern);
        return groupItem;
    }

    private TreeItem createNewInstanceItem(IMarker marker, TreeItem groupItem) {
        String id = marker.getAttribute("FINDBUGS_UNIQUE_ID", "");
        if (this.disposed) {
            return null;
        }
        TreeItem[] treeItems = groupItem.getItems();
        for (int i = 0; i < treeItems.length; ++i) {
            IMarker existingMarker = (IMarker)treeItems[i].getData(KEY_MARKER);
            if (!existingMarker.getAttribute("FINDBUGS_UNIQUE_ID", "").equals(id)) continue;
            return null;
        }
        TreeItem instanceItem = new TreeItem(groupItem, 16384);
        instanceItem.setData(KEY_MARKER, (Object)marker);
        instanceItem.setText(marker.getAttribute("message", "Error retrieving message"));
        return instanceItem;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }

    private TreeItem getFirstSelectedElement(Tree tree) {
        TreeItem[] selection = tree.getSelection();
        if (selection.length > 0) {
            return selection[0];
        }
        return null;
    }

    private class BugTreeSelectionListener
    extends SelectionAdapter {
        private Tree theTree;

        public BugTreeSelectionListener(Tree theTree) {
            this.theTree = theTree;
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem theItem = BugTreeView.this.getFirstSelectedElement(this.theTree);
            IMarker myMarker = BugTreeView.getMarkerForTreeItem(theItem);
            IStatusLineManager manager = BugTreeView.this.getViewSite().getActionBars().getStatusLineManager();
            if (myMarker == null || !myMarker.getResource().getProject().isOpen()) {
                manager.setMessage("");
                return;
            }
            manager.setMessage(myMarker.getAttribute("message", ""));
            IViewPart viewPart = BugTreeView.this.getSite().getPage().findView("de.tobject.findbugs.view.detailsview");
            if (viewPart instanceof DetailsView && ((DetailsView)viewPart).isVisible()) {
                FindbugsPlugin.showMarker(myMarker);
            }
            if ((viewPart = BugTreeView.this.getSite().getPage().findView("de.tobject.findbugs.view.userannotationsview")) instanceof UserAnnotationsView && ((UserAnnotationsView)viewPart).isVisible()) {
                UserAnnotationsView.showMarker(myMarker);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class ResourceChangeListener
    implements IResourceChangeListener {
        private static final int SHORT_DELAY = 100;
        private static final int LONG_DELAY = 1000;

        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            boolean shortDelay;
            IResourceDelta delta = event.getDelta();
            boolean bl = shortDelay = event.getType() == 16;
            if (delta == null) {
                this.resourceChanged(shortDelay, new ResourceDelta(event.getResource(), 2));
            } else {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                try {
                    delta.accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Error visiting resource delta: " + delta);
                }
                this.resourceChanged(shortDelay, visitor.getDeltas());
            }
        }

        private void resourceChanged(boolean shortDelay, ResourceDelta ... resource) {
            boolean accepted = false;
            for (int i = 0; i < resource.length; ++i) {
                if (Reporter.DEBUG) {
                    System.out.println("event res: " + resource[i]);
                }
                accepted |= BugTreeView.this.markerJob.addToQueue(resource[i]);
            }
            if (!accepted) {
                return;
            }
            if (shortDelay) {
                this.scheduleMarkerJob(100);
            } else {
                this.scheduleMarkerJob(1000);
            }
        }

        void scheduleMarkerJob(int delay) {
            BugTreeView.this.markerJob.cancel();
            IWorkbenchSiteProgressService progressService = BugTreeView.this.getProgressService();
            if (progressService != null) {
                progressService.schedule((Job)BugTreeView.this.markerJob, (long)delay);
            } else {
                BugTreeView.this.markerJob.schedule(delay);
            }
        }
    }

    private class MarkerJob
    extends Job {
        volatile Vector<ResourceDelta> resourcesToRefresh;
        private final IMarker[] EMPTY_MARKER;

        public MarkerJob(String name) {
            super(name);
            this.EMPTY_MARKER = new IMarker[0];
            this.resourcesToRefresh = new Vector(13);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Updating bug markers", this.resourcesToRefresh.size());
            while (!(this.resourcesToRefresh.isEmpty() || monitor.isCanceled() || BugTreeView.this.disposed)) {
                ResourceDelta delta = this.resourcesToRefresh.remove(0);
                IResource resource = delta.resource;
                monitor.subTask("Update bug markers for " + delta.resource);
                boolean exists = resource.exists();
                if (resource.getType() == 4) {
                    exists &= ((IProject)resource).isOpen();
                }
                IMarker[] markerArr = this.EMPTY_MARKER;
                if (exists) {
                    try {
                        markerArr = resource.findMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
                    }
                    catch (CoreException e) {
                        FindbugsPlugin.getDefault().logException(e, "Core exception on update marker job");
                    }
                }
                IProject project = resource.getProject();
                boolean removeProject = resource instanceof IProject && delta.kind == 2;
                BugTreeView.this.removeMarker(project, removeProject, monitor, new IResource[]{resource});
                if (exists &= markerArr.length > 0 && delta.kind != 2) {
                    BugTreeView.this.addMarker(project, monitor, markerArr);
                }
                monitor.worked(1);
            }
            if (BugTreeView.this.disposed) {
                this.resourcesToRefresh.clear();
            }
            monitor.done();
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addToQueue(ResourceDelta res) {
            Vector<ResourceDelta> vector = this.resourcesToRefresh;
            synchronized (vector) {
                if (!this.resourcesToRefresh.contains(res)) {
                    this.resourcesToRefresh.add(res);
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ResourceDelta {
        IResource resource;
        int kind;

        public ResourceDelta(IResource resource, int kind) {
            this.resource = resource;
            this.kind = kind;
        }

        public int hashCode() {
            return this.kind * 31 + (this.resource == null ? 0 : this.resource.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ResourceDelta)) {
                return false;
            }
            ResourceDelta other = (ResourceDelta)obj;
            if (this.kind != other.kind) {
                return false;
            }
            return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("kind: ");
            switch (this.kind) {
                case 1: {
                    sb.append("added: ");
                    break;
                }
                case 2: {
                    sb.append("removed: ");
                    break;
                }
                case 4: {
                    sb.append("changed: ");
                }
            }
            return sb.append(this.resource).toString();
        }
    }

    private static final class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        List<ResourceDelta> resources = new ArrayList<ResourceDelta>();

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            int kind = delta.getKind();
            int flags = delta.getFlags();
            if (kind == 8 || kind == 16) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    this.resources.add(new ResourceDelta(resource, kind));
                    return false;
                }
                case 4: {
                    boolean open;
                    boolean bl = open = (flags & 0x4000) != 0;
                    if (kind == 1 || kind == 2 || open) {
                        this.resources.add(new ResourceDelta(resource, kind));
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public ResourceDelta[] getDeltas() {
            return this.resources.toArray(new ResourceDelta[0]);
        }
    }
}

