/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerReporter;
import de.tobject.findbugs.reporter.Reporter;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

public final class MarkerUtil {
    static final Pattern fullName = Pattern.compile("^(.+?)(([$+][0-9].*)?)");

    private MarkerUtil() {
    }

    public static void createMarker(BugInstance bug, IJavaProject project, BugCollection theCollection) {
        if (bug == null) {
            FindbugsPlugin.getDefault().logException(new NullPointerException(), "bug is null");
            return;
        }
        if (project == null) {
            FindbugsPlugin.getDefault().logException(new NullPointerException(), "project is null");
            return;
        }
        String className = null;
        String packageName = null;
        ClassAnnotation primaryClass = bug.getPrimaryClass();
        if (primaryClass != null) {
            className = primaryClass.getClassName();
            packageName = primaryClass.getPackageName();
        }
        if (Reporter.DEBUG) {
            System.out.println("BUG in class: " + packageName + "." + className + ": \n\t" + bug.getMessage() + " / Annotation: " + bug.getAnnotationText() + " / Source Line: " + bug.getPrimarySourceLineAnnotation());
        }
        IResource resource = null;
        try {
            resource = MarkerUtil.getUnderlyingResource(bug, project, null);
        }
        catch (JavaModelException e1) {
            FindbugsPlugin.getDefault().logException(e1, "Could not find class resource for FindBugs warning");
        }
        if (resource != null) {
            int startLine = 1;
            if (bug.getPrimarySourceLineAnnotation() != null) {
                startLine = bug.getPrimarySourceLineAnnotation().getStartLine();
            }
            int fieldLine = -1;
            if (startLine <= 0 && bug.getPrimaryField() != null && bug.getPrimaryField().getSourceLines() != null) {
                fieldLine = bug.getPrimaryField().getSourceLines().getStartLine();
            }
            if (startLine <= 0 && fieldLine > 0) {
                startLine = fieldLine;
            }
            MarkerUtil.addMarker(bug, project.getProject(), resource, startLine, theCollection);
            if (startLine != fieldLine && fieldLine > 0) {
                MarkerUtil.addMarker(bug, project.getProject(), resource, startLine, theCollection);
            }
        } else if (Reporter.DEBUG) {
            System.out.println("NOT found resource for a BUG in class: " + packageName + "." + className + ": \n\t" + bug.getMessage() + " / Annotation: " + bug.getAnnotationText() + " / Source Line: " + bug.getPrimarySourceLineAnnotation());
        }
    }

    private static void addMarker(BugInstance bug, IProject project, IResource resource, int startLine, BugCollection theCollection) {
        if (Reporter.DEBUG) {
            System.out.println("Creating marker for " + resource.getLocation() + ": line " + startLine + bug.getMessage());
        }
        try {
            project.getWorkspace().run((IWorkspaceRunnable)new MarkerReporter(bug, resource, startLine, theCollection, project), null, 0, null);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Core exception on add marker");
        }
    }

    @CheckForNull
    private static IResource getUnderlyingResource(BugInstance bug, IJavaProject project, SourceLineAnnotation sla) throws JavaModelException {
        IType type;
        SourceLineAnnotation primarySourceLineAnnotation = sla == null ? bug.getPrimarySourceLineAnnotation() : sla;
        ClassAnnotation packageAnnotation = null;
        String packageName = null;
        String qualifiedClassName = null;
        if (primarySourceLineAnnotation == null) {
            packageAnnotation = bug.getPrimaryClass();
            if (packageAnnotation != null) {
                packageName = packageAnnotation.getPackageName();
                qualifiedClassName = packageAnnotation.getClassName();
            }
        } else {
            packageName = primarySourceLineAnnotation.getPackageName();
            qualifiedClassName = primarySourceLineAnnotation.getClassName();
        }
        if (qualifiedClassName == null) {
            return null;
        }
        if (Reporter.DEBUG) {
            System.out.println("Looking up class: " + packageName + ", " + qualifiedClassName);
        }
        Matcher m = fullName.matcher(qualifiedClassName);
        String innerName = null;
        if (m.matches() && m.group(2).length() > 0) {
            String outerQualifiedClassName = m.group(1).replace('$', '.');
            innerName = m.group(2).substring(1);
            type = project.findType(outerQualifiedClassName, (IProgressMonitor)null);
            MarkerUtil.completeInnerClassInfo(qualifiedClassName, innerName, type, bug);
        } else {
            type = project.findType(qualifiedClassName.replace('$', '.'), (IProgressMonitor)null);
        }
        primarySourceLineAnnotation = bug.getPrimarySourceLineAnnotation();
        if (primarySourceLineAnnotation != null) {
            int startLine = primarySourceLineAnnotation.getStartLine();
            if (startLine <= 0 && bug.getPrimaryField() != null) {
                MarkerUtil.completeFieldInfo(qualifiedClassName, innerName, type, bug);
            }
        } else if (bug.getPrimaryField() != null) {
            MarkerUtil.completeFieldInfo(qualifiedClassName, innerName, type, bug);
        }
        if (type != null) {
            return type.getUnderlyingResource();
        }
        return null;
    }

    private static void completeFieldInfo(String qualifiedClassName, String innerName, IType type, BugInstance bug) throws JavaModelException {
        FieldAnnotation field = bug.getPrimaryField();
        if (field == null || type == null) {
            return;
        }
        IField ifield = type.getField(field.getFieldName());
        if (type instanceof SourceType) {
            ISourceRange sourceRange;
            int offset;
            IScanner scanner = MarkerUtil.initScanner((IJavaElement)type);
            int lineNbr = scanner.getLineNumber(offset = (sourceRange = ifield.getSourceRange()).getOffset());
            lineNbr = lineNbr <= 0 ? 1 : lineNbr;
            String sourceFileStr = "";
            IResource res = type.getUnderlyingResource();
            if (res != null) {
                sourceFileStr = res.getRawLocation().toOSString();
            }
            field.setSourceLines(new SourceLineAnnotation(qualifiedClassName, sourceFileStr, lineNbr, lineNbr, 0, 0));
        }
    }

    private static void completeInnerClassInfo(String qualifiedClassName, String innerName, IType type, BugInstance bug) throws JavaModelException {
        IResource res;
        int lineNbr = MarkerUtil.findChildSourceLine((IJavaElement)type, innerName);
        lineNbr = lineNbr <= 0 ? 1 : lineNbr;
        String sourceFileStr = "";
        IResource iResource = res = type == null ? null : type.getUnderlyingResource();
        if (res != null) {
            sourceFileStr = res.getRawLocation().toOSString();
        }
        bug.addSourceLine(new SourceLineAnnotation(qualifiedClassName, sourceFileStr, lineNbr, lineNbr, 0, 0));
    }

    private static int getLineStart(SourceType source) throws JavaModelException {
        IOpenable op = source.getOpenable();
        if (op instanceof CompilationUnit) {
            IScanner scanner = MarkerUtil.initScanner((IJavaElement)source);
            ISourceRange range = source.getSourceRange();
            return scanner.getLineNumber(range.getOffset());
        }
        return 1;
    }

    private static IScanner initScanner(IJavaElement source) throws JavaModelException {
        IOpenable op = source.getOpenable();
        if (op instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)op;
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            scanner.setSource(cu.getContents());
            try {
                while (scanner.getNextToken() != 158) {
                }
            }
            catch (InvalidInputException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not init scanner for type: " + source);
            }
            return scanner;
        }
        return null;
    }

    private static int findChildSourceLine(IJavaElement javaElement, String name) throws JavaModelException {
        boolean innerFromMember;
        if (javaElement == null) {
            return -1;
        }
        char firstChar = name.charAt(0);
        boolean firstIsDigit = Character.isDigit(firstChar);
        if (!firstIsDigit) {
            return MarkerUtil.findInnerClassSourceLine(javaElement, name);
        }
        boolean bl = innerFromMember = firstIsDigit && name.length() > 1 && !Character.isDigit(name.charAt(1));
        if (innerFromMember) {
            return MarkerUtil.findInnerClassSourceLine(javaElement, name.substring(1));
        }
        try {
            int innerNumber = Integer.parseInt(name);
            return MarkerUtil.findInnerAnonymousClassSourceLine(javaElement, innerNumber);
        }
        catch (NumberFormatException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not find source line information for class member");
            return -1;
        }
    }

    private static int findInnerAnonymousClassSourceLine(IJavaElement javaElement, int innerNumber) {
        IOpenable op = javaElement.getOpenable();
        if (!(op instanceof CompilationUnit)) {
            return -1;
        }
        CompilationUnit cu = (CompilationUnit)op;
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        scanner.setSource(cu.getContents());
        try {
            int innerCount = 0;
            int tokenID = scanner.getNextToken();
            while (tokenID != 158) {
                if (tokenID != 32) {
                    tokenID = scanner.getNextToken();
                    continue;
                }
                int startClassPos = scanner.getCurrentTokenStartPosition();
                tokenID = scanner.getNextToken();
                if (tokenID != 5 || (tokenID = scanner.getNextToken()) != 7 || (tokenID = scanner.getNextToken()) != 86 || (tokenID = scanner.getNextToken()) != 110) continue;
                tokenID = scanner.getNextToken();
                if (++innerCount != innerNumber) continue;
                return scanner.getLineNumber(startClassPos);
            }
        }
        catch (InvalidInputException e) {
            FindbugsPlugin.getDefault().logException(e, "Error scanning for inner class start line");
        }
        return -1;
    }

    private static int findInnerClassSourceLine(IJavaElement javaElement, String name) throws JavaModelException {
        String elemName = javaElement.getElementName();
        if (name.equals(elemName) && javaElement instanceof SourceType) {
            SourceType source = (SourceType)javaElement;
            return MarkerUtil.getLineStart(source);
        }
        if (javaElement instanceof IParent) {
            IJavaElement[] children = ((IParent)javaElement).getChildren();
            for (int i = 0; i < children.length; ++i) {
                int line = MarkerUtil.findInnerClassSourceLine(children[i], name);
                if (line <= 0) continue;
                return line;
            }
        }
        return -1;
    }

    public static void removeMarkers(IResource res) throws CoreException {
        res.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
    }

    public static boolean displayWarning(BugInstance bugInstance, ProjectFilterSettings filterSettings) {
        return filterSettings.displayWarning(bugInstance);
    }

    public static void redisplayMarkers(final IJavaProject javaProject, Shell shell) {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        final IProject project = javaProject.getProject();
        try {
            progressDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        UserPreferences userPrefs = FindbugsPlugin.getUserPreferences(project);
                        SortedBugCollection bugCollection = FindbugsPlugin.getBugCollection(project, monitor);
                        if (bugCollection != null) {
                            MarkerUtil.removeMarkers((IResource)project);
                            for (BugInstance bugInstance : bugCollection) {
                                if (!MarkerUtil.displayWarning(bugInstance, userPrefs.getFilterSettings())) continue;
                                MarkerUtil.createMarker(bugInstance, javaProject, (BugCollection)bugCollection);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        FindbugsPlugin.getDefault().logException(e, "Error redisplaying FindBugs warning markers");
                    }
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            FindbugsPlugin.getDefault().logException(e, "Error redisplaying FindBugs warning markers");
        }
    }

    @CheckForNull
    public static BugInstance findBugInstanceForMarker(IMarker marker) {
        IResource resource = marker.getResource();
        if (resource == null) {
            FindbugsPlugin.getDefault().logError("No resource for warning marker");
            return null;
        }
        IProject project = resource.getProject();
        if (project == null) {
            FindbugsPlugin.getDefault().logError("No project for warning marker");
            return null;
        }
        try {
            if (!marker.isSubtypeOf("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker")) {
                return null;
            }
            String uniqueId = marker.getAttribute("FINDBUGS_UNIQUE_ID", null);
            if (uniqueId == null) {
                FindbugsPlugin.getDefault().logError("Marker does not contain unique id for warning");
                return null;
            }
            SortedBugCollection bugCollection = FindbugsPlugin.getBugCollection(project, null);
            if (bugCollection == null) {
                FindbugsPlugin.getDefault().logError("Could not get BugCollection for FindBugs marker");
                return null;
            }
            String bugId = (String)marker.getAttribute("FINDBUGS_UNIQUE_ID");
            String bugType = (String)marker.getAttribute("BUGTYPE");
            Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
            if (bugId == null || bugType == null || lineNumber == null) {
                FindbugsPlugin.getDefault().logError("Could not get find attributes for marker " + marker + ": (" + bugId + ", " + bugType + ", " + lineNumber + ")");
                return null;
            }
            BugInstance bug = bugCollection.findBug(bugId, bugType, lineNumber.intValue());
            return bug;
        }
        catch (RuntimeException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not get BugInstance for FindBugs marker");
            return null;
        }
        catch (Exception e) {
            FindbugsPlugin.getDefault().logException(e, "Could not get BugInstance for FindBugs marker");
            return null;
        }
    }

    public static IMarker getMarkerFromSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            for (Object selectedObj : structuredSelection) {
                if (Reporter.DEBUG) {
                    System.out.println("\tSelection element: " + selectedObj.getClass().getName());
                }
                if (!(selectedObj instanceof IMarker)) continue;
                if (Reporter.DEBUG) {
                    System.out.println("Selection element is an IMarker!");
                }
                return (IMarker)selectedObj;
            }
        }
        return null;
    }
}

