/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils;

import eclipseme.model.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static final String ATTR_VERSION = "version";
    private static final String XSLT_TEMPLATE = "<xsl:stylesheet version=\"1.0\"\r\n      xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n   <xsl:output method=\"xml\"/>\r\n   <xsl:param name=\"indent-increment\" select=\"'   '\" />\r\n\r\n   <xsl:template match=\"*\">\r\n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>\r\n\r\n      <xsl:value-of select=\"$indent\"/>\r\n      <xsl:copy>\r\n        <xsl:copy-of select=\"@*\" />\r\n        <xsl:apply-templates>\r\n          <xsl:with-param name=\"indent\"\r\n               select=\"concat($indent, $indent-increment)\"/>\r\n        </xsl:apply-templates>\r\n        <xsl:if test=\"*\">\r\n          <xsl:value-of select=\"$indent\"/>\r\n        </xsl:if>\r\n      </xsl:copy>\r\n   </xsl:template>\r\n\r\n   <xsl:template match=\"comment()|processing-instruction()\">\r\n      <xsl:copy />\r\n   </xsl:template>\r\n\r\n   <!-- WARNING: this is dangerous. Handle with care -->\r\n   <xsl:template match=\"text()[normalize-space(.)='']\"/>\r\n\r\n</xsl:stylesheet>";

    public static Element createRootElement(String elementName, Version version) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = document.createElement(elementName);
        document.appendChild(element);
        element.setAttribute(ATTR_VERSION, version.toString());
        return element;
    }

    public static Document readDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        if (xmlFile != null && xmlFile.exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(xmlFile);
        }
        return document;
    }

    public static void writeDocument(File xmlFile, Document document) throws TransformerException, IOException {
        FileWriter fw = new FileWriter(xmlFile);
        StreamResult destination = new StreamResult(fw);
        DOMSource source = new DOMSource(document);
        StringReader xslReader = new StringReader(XSLT_TEMPLATE);
        StreamSource xslSource = new StreamSource(xslReader);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer(xslSource);
        serializer.transform(source, destination);
        fw.close();
    }

    private XMLUtils() {
    }
}

