/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils;

import eclipseme.EclipseMEPlugin;
import eclipseme.utils.IClasspathEntryVisitor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ClasspathEntryVisitorRunner {
    public void run(IJavaProject javaProject, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            this.visitEntry(javaProject, entry, entryVisitor, monitor);
            ++i;
        }
    }

    private void visitEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        switch (entry.getEntryKind()) {
            case 5: {
                this.visitContainerEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 1: {
                this.visitLibraryEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 2: {
                this.visitProjectEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 3: {
                this.visitSourceEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 4: {
                this.visitVariableEntry(javaProject, entry, entryVisitor, monitor);
            }
        }
    }

    private void visitContainerEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        IPath containerPath = entry.getPath();
        if (entryVisitor.visitContainer(javaProject, containerPath.lastSegment(), monitor)) {
            IClasspathContainer cpContainer = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
            IClasspathEntry[] entries = cpContainer.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry2 = entries[i];
                this.visitEntry(javaProject, entry2, entryVisitor, monitor);
                ++i;
            }
        }
    }

    private void visitLibraryEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        entryVisitor.visitLibraryEntry(javaProject, entry, monitor);
    }

    private void visitProjectEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        IPath projectPath = entry.getPath();
        IProject project = (IProject)EclipseMEPlugin.getWorkspace().getRoot().findMember(projectPath);
        IJavaProject jProject = JavaCore.create((IProject)project);
        if (entryVisitor.visitProject(javaProject, jProject, monitor)) {
            this.run(jProject, entryVisitor, monitor);
        }
    }

    private void visitSourceEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        entryVisitor.visitSourceEntry(javaProject, entry, monitor);
    }

    private void visitVariableEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        String variableName = entry.getPath().lastSegment();
        if (entryVisitor.visitVariable(javaProject, variableName, monitor)) {
            IClasspathEntry entry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
            this.visitEntry(javaProject, entry2, entryVisitor, monitor);
        }
    }
}

