/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.wizards;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.ui.wizards.J2MEJavaCapabilityConfigurationPage;
import eclipseme.ui.wizards.PlatformDefinitionWizardPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewJ2MEProjectWizard
extends Wizard
implements INewWizard {
    public static final String MAIN_PAGE_NAME = "NewProjectCreationPage";
    private IConfigurationElement configElement;
    private WizardNewProjectCreationPage mainPage;
    private J2MEJavaCapabilityConfigurationPage javaWizardPage;
    private PlatformDefinitionWizardPage platformDefPage;
    private boolean projectLocationExisted;

    private static String getResourceString(String key) {
        return EclipseMEPlugin.getResourceString(key);
    }

    public NewJ2MEProjectWizard() {
        this.setWindowTitle(NewJ2MEProjectWizard.getResourceString("wiz.newproj.title"));
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage(MAIN_PAGE_NAME);
        this.mainPage.setTitle(NewJ2MEProjectWizard.getResourceString("wiz.newproj.main.title"));
        this.mainPage.setDescription(NewJ2MEProjectWizard.getResourceString("wiz.newproj.main.description"));
        this.platformDefPage = new PlatformDefinitionWizardPage();
        this.javaWizardPage = new J2MEJavaCapabilityConfigurationPage(this.mainPage);
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.platformDefPage);
        this.addPage((IWizardPage)this.javaWizardPage);
    }

    public boolean canFinish() {
        return this.platformDefPage.canFlipToNextPage() && super.canFinish();
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
    }

    public boolean performCancel() {
        if (!this.projectLocationExisted) {
            this.removeProject();
        }
        return super.performCancel();
    }

    private void removeProject() {
        IProject project;
        IJavaProject javaProject = this.javaWizardPage.getJavaProject();
        if (javaProject != null && (project = javaProject.getProject()) != null && project.exists()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("##Remove Project", 3);
                    try {
                        try {
                            project.delete(true, false, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    monitor.done();
                }
            };
            try {
                this.getContainer().run(false, true, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean performFinish() {
        boolean completed = true;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                NewJ2MEProjectWizard.this.getProjectCreationRunnable().run(monitor);
                NewJ2MEProjectWizard.this.getJavaNatureRunnable().run(monitor);
                NewJ2MEProjectWizard.this.getJ2MEUpdatesRunnable().run(monitor);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(runnable));
        }
        catch (InvocationTargetException e) {
            EclipseMEPlugin.log(4, "performFinish", e);
            completed = false;
        }
        catch (InterruptedException e) {
            completed = false;
        }
        return completed;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private IRunnableWithProgress getProjectCreationRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    File projectLocationFile = NewJ2MEProjectWizard.this.mainPage.getLocationPath().toFile();
                    NewJ2MEProjectWizard.this.projectLocationExisted = projectLocationFile.exists();
                    IProject project = NewJ2MEProjectWizard.this.mainPage.getProjectHandle();
                    JavaCapabilityConfigurationPage.createProject((IProject)project, (IPath)NewJ2MEProjectWizard.this.mainPage.getLocationPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private IRunnableWithProgress getJavaNatureRunnable() {
        IRunnableWithProgress runnable = this.javaWizardPage.getRunnable();
        if (runnable == null) {
            this.javaWizardPage.updateConfiguration();
            runnable = this.javaWizardPage.getRunnable();
        }
        return runnable;
    }

    private IRunnableWithProgress getJ2MEUpdatesRunnable() {
        IProject project = this.mainPage.getProjectHandle();
        IJavaProject javaProject = this.javaWizardPage.getJavaProject();
        IPlatformDefinition def = this.platformDefPage.getPlatformDefinition();
        return MidletSuiteProject.getMidletSuiteCreationRunnable(project, javaProject, def);
    }
}

