/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.view.platformcomponents;

import eclipseme.model.IConfiguration;
import eclipseme.model.IProfile;
import eclipseme.model.IWirelessToolkit;
import eclipseme.ui.utils.AbstractTreeNode;
import eclipseme.ui.utils.ITreeNode;
import eclipseme.ui.view.platformcomponents.AddWirelessToolkitAction;
import eclipseme.ui.view.platformcomponents.ConfigurationTreeNode;
import eclipseme.ui.view.platformcomponents.ProfileTreeNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;

public class WirelessToolkitTreeNode
extends AbstractTreeNode {
    private IWirelessToolkit toolkit;
    private Action[] actions;

    public WirelessToolkitTreeNode(ITreeNode parent, IWirelessToolkit toolkit) {
        super(parent);
        this.toolkit = toolkit;
    }

    public Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new AddWirelessToolkitAction(), new RemoveWirelessToolkitAction()};
        }
        return this.actions;
    }

    public IWirelessToolkit getToolkit() {
        return this.toolkit;
    }

    protected ITreeNode[] calculateChildren() {
        IProfile[] profiles = this.toolkit.getProfiles();
        IConfiguration[] configurations = this.toolkit.getConfigurations();
        ITreeNode[] nodes = new ITreeNode[profiles.length + configurations.length];
        int i = 0;
        while (i < configurations.length) {
            nodes[i] = new ConfigurationTreeNode(this, configurations[i]);
            ++i;
        }
        int length = configurations.length;
        int i2 = 0;
        while (i2 < profiles.length) {
            nodes[i2 + length] = new ProfileTreeNode(this, profiles[i2]);
            ++i2;
        }
        return nodes;
    }

    public String toString() {
        return this.toolkit.getName();
    }

    private class RemoveWirelessToolkitAction
    extends Action {
        public RemoveWirelessToolkitAction() {
            super("Remove Wireless Toolkit");
        }

        public void run() {
            boolean shouldRemove = MessageDialog.openConfirm(null, (String)"Remove Confirmation", (String)("Remove \"" + WirelessToolkitTreeNode.this.toolkit.getName() + "\"?"));
            if (shouldRemove) {
                WirelessToolkitTreeNode.this.toolkit.deregisterDerivedComponents();
                WirelessToolkitTreeNode.this.getRegistry().remove(WirelessToolkitTreeNode.this.toolkit);
                WirelessToolkitTreeNode.this.updateComponentsStore((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

