/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.view.platformcomponents;

import eclipseme.model.IProfile;
import eclipseme.ui.utils.AbstractTreeNode;
import eclipseme.ui.utils.ITreeNode;
import eclipseme.ui.view.platformcomponents.AddProfileAction;
import eclipseme.ui.view.platformcomponents.ProfileLibraryTreeNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;

public class ProfileTreeNode
extends AbstractTreeNode {
    private static Action[] actions;
    private IProfile profile;

    public ProfileTreeNode(ITreeNode parent, IProfile profile) {
        super(parent);
        this.profile = profile;
    }

    public Action[] getActions() {
        if (actions == null) {
            actions = new Action[]{new AddProfileAction(), new RemoveProfileAction()};
        }
        return actions;
    }

    protected ITreeNode[] calculateChildren() {
        IClasspathEntry[] libraries = this.profile.getLibraries();
        ITreeNode[] nodes = new ITreeNode[libraries.length];
        int i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry = libraries[i];
            nodes[i] = new ProfileLibraryTreeNode(this, entry);
            ++i;
        }
        return nodes;
    }

    public String toString() {
        return this.profile.getName();
    }

    private class RemoveProfileAction
    extends Action {
        public RemoveProfileAction() {
            super("Remove Profile");
        }

        public boolean isEnabled() {
            return !ProfileTreeNode.this.profile.hasDependentComponents();
        }

        public void run() {
            boolean shouldRemove = MessageDialog.openConfirm(null, (String)"Remove Confirmation", (String)("Remove Profile \"" + ProfileTreeNode.this.profile.getName() + "\"?"));
            if (shouldRemove) {
                ProfileTreeNode.this.getRegistry().remove(ProfileTreeNode.this.profile);
                ProfileTreeNode.this.updateComponentsStore((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

