/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.view.platformcomponents;

import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.ui.utils.AbstractTreeNode;
import eclipseme.ui.utils.ITreeNode;
import eclipseme.ui.view.platformcomponents.AddPlatformDefinitionAction;
import eclipseme.ui.view.platformcomponents.ConfigurationTreeNode;
import eclipseme.ui.view.platformcomponents.ProfileTreeNode;
import eclipseme.ui.view.platformcomponents.WirelessToolkitTreeNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;

public class PlatformDefinitionTreeNode
extends AbstractTreeNode {
    private static Action[] actions;
    private IPlatformDefinition platformDefinition;

    public PlatformDefinitionTreeNode(ITreeNode parent, IPlatformDefinition platformDefinition) {
        super(parent);
        this.platformDefinition = platformDefinition;
    }

    public Action[] getActions() {
        if (actions == null) {
            actions = new Action[]{new AddPlatformDefinitionAction(), new RemovePlatformDefinitionAction()};
        }
        return actions;
    }

    protected ITreeNode[] calculateChildren() {
        IProfile[] profiles = this.platformDefinition.getProfiles();
        ITreeNode[] nodes = new ITreeNode[profiles.length + 2];
        nodes[0] = new WirelessToolkitTreeNode(this, this.platformDefinition.getWirelessToolkit());
        nodes[1] = new ConfigurationTreeNode(this, this.platformDefinition.getConfiguration());
        int i = 0;
        while (i < profiles.length) {
            nodes[i + 2] = new ProfileTreeNode(this, profiles[i]);
            ++i;
        }
        return nodes;
    }

    public String toString() {
        return this.platformDefinition.getName();
    }

    private class RemovePlatformDefinitionAction
    extends Action {
        public RemovePlatformDefinitionAction() {
            super("Remove Platform Definition");
        }

        public boolean isEnabled() {
            return !PlatformDefinitionTreeNode.this.platformDefinition.hasDependentComponents();
        }

        public void run() {
            boolean shouldRemove = MessageDialog.openConfirm(null, (String)"Remove Confirmation", (String)("Remove \"" + PlatformDefinitionTreeNode.this.platformDefinition.getName() + "\"?"));
            if (shouldRemove) {
                IProfile[] profiles = PlatformDefinitionTreeNode.this.platformDefinition.getProfiles();
                int i = 0;
                while (i < profiles.length) {
                    IProfile profile = profiles[i];
                    profile.removeDependentComponent(PlatformDefinitionTreeNode.this.platformDefinition);
                    ++i;
                }
                PlatformDefinitionTreeNode.this.getRegistry().remove(PlatformDefinitionTreeNode.this.platformDefinition);
                PlatformDefinitionTreeNode.this.updateComponentsStore((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

