/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.editor.jad;

import eclipseme.ui.editor.jad.AbstractJADEditorPage;
import eclipseme.ui.editor.jad.JADEditor;
import eclipseme.ui.editor.jad.NewMidletDialog;
import eclipseme.utils.ManifestPreferenceStore;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class JADMidletsEditorPage
extends AbstractJADEditorPage {
    public static final String MIDLET_PREFIX = "MIDlet-";
    private ArrayList midlets = new ArrayList();
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private int storedMidletCount;

    public JADMidletsEditorPage(JADEditor editor, String title) {
        super(editor, title);
    }

    public void doSave(IProgressMonitor monitor) {
        ManifestPreferenceStore store = this.getPreferenceStore();
        int currentMidletCount = this.midlets.size();
        int i = 0;
        while (i < currentMidletCount) {
            MidletDefinition def = (MidletDefinition)this.midlets.get(i);
            store.setValue(MIDLET_PREFIX + (i + 1), def.toString());
            ++i;
        }
        while (i < this.storedMidletCount) {
            store.setToDefault(MIDLET_PREFIX + (i + 1));
            ++i;
        }
        this.storedMidletCount = currentMidletCount;
        this.setDirty(false);
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    protected void addPageControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setBackground(parent.getBackground());
        this.createTableViewer(composite);
        this.createButtons(composite);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)input);
        }
        this.setDirty(false);
        this.updateMidletProperties();
    }

    private void addItem() {
        NewMidletDialog dialog = new NewMidletDialog(this.getSite().getShell(), this.getProject());
        if (dialog.open() == 0) {
            this.midlets.add(dialog.getMidletDefinition());
            this.tableViewer.refresh();
            this.setDirty(true);
        }
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        composite.setLayout((Layout)layout);
        this.addButton = new Button(composite, 0);
        this.addButton.setText(AbstractJADEditorPage.getResourceString("editor.button.add"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADMidletsEditorPage.this.addItem();
            }
        });
        Label l = new Label(composite, 0);
        l.setBackground(parent.getBackground());
        this.removeButton = new Button(composite, 0);
        this.removeButton.setText(AbstractJADEditorPage.getResourceString("editor.button.remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADMidletsEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(Composite parent) {
        String[] columns = new String[]{AbstractJADEditorPage.getResourceString("property.jad.midlet.name"), AbstractJADEditorPage.getResourceString("property.jad.midlet.icon"), AbstractJADEditorPage.getResourceString("property.jad.midlet.class")};
        this.tableViewer = new TableViewer(parent, 68356);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                JADMidletsEditorPage.this.removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        TableLayout layout = new TableLayout();
        int width = 100 / columns.length;
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(width));
            ++i;
        }
        table.setLayout((Layout)layout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private IProject getProject() {
        IProject project = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            project = file.getProject();
        }
        return project;
    }

    private void removeSelectedItems() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            this.midlets.remove(index);
            --i;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        this.midlets.clear();
        ManifestPreferenceStore store = this.getPreferenceStore();
        int i = 1;
        while (i < 1000) {
            String propName = MIDLET_PREFIX + i;
            if (!store.contains(propName)) break;
            String propValue = store.getString(propName);
            this.midlets.add(new MidletDefinition(propValue));
            ++i;
        }
        this.storedMidletCount = this.midlets.size();
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    static class MidletDefinition {
        public String[] fields = new String[3];

        MidletDefinition(String definitionString) {
            String[] tokens = this.tokenize(definitionString, ',');
            int i = 0;
            while (i < 3) {
                this.fields[i] = i > tokens.length ? "" : tokens[i];
                ++i;
            }
        }

        MidletDefinition(String name, String icon, String className) {
            this.fields[0] = name;
            this.fields[1] = icon;
            this.fields[2] = className;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < 3) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.fields[i]);
                ++i;
            }
            return sb.toString();
        }

        private String[] tokenize(String string, char delimiter) {
            ArrayList<String> tokens = new ArrayList<String>();
            int offset = 0;
            int delimiterIndex = 0;
            do {
                if ((delimiterIndex = string.indexOf(delimiter, offset)) == -1) {
                    tokens.add(string.substring(offset));
                    continue;
                }
                tokens.add(string.substring(offset, delimiterIndex));
                offset = delimiterIndex + 1;
            } while (delimiterIndex != -1);
            return tokens.toArray(new String[tokens.size()]);
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return JADMidletsEditorPage.this.midlets.toArray(new Object[JADMidletsEditorPage.this.midlets.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((MidletDefinition)element).fields[columnIndex];
        }
    }
}

