/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.editor.jad;

import eclipseme.EclipseMEPlugin;
import eclipseme.ui.editor.jad.JADEditor;
import eclipseme.utils.ManifestPreferenceStore;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractJADEditorPage
extends EditorPart
implements IPropertyChangeListener {
    private boolean dirty;
    private JADEditor editor;

    protected static String getResourceString(String key) {
        return EclipseMEPlugin.getResourceString(key);
    }

    public AbstractJADEditorPage(JADEditor editor, String title) {
        this.editor = editor;
        this.setPartName(title);
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        Color backgroundColor = EclipseMEPlugin.getColor(display, 255, 255, 255);
        parent.setBackground(backgroundColor);
        Composite gridComposite = new Composite(parent, 0);
        gridComposite.setBackground(parent.getBackground());
        gridComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        gridComposite.setLayout((Layout)layout);
        Label titleLabel = new Label(gridComposite, 0);
        titleLabel.setBackground(backgroundColor);
        titleLabel.setText(String.valueOf(this.getTitle()) + "     ");
        Color titleColor = EclipseMEPlugin.getColor(display, 0, 0, 255);
        titleLabel.setForeground(titleColor);
        FontData fontData = titleLabel.getFont().getFontData()[0];
        Font font = EclipseMEPlugin.getFont(display, fontData.getName(), fontData.getHeight() + 2, 3);
        titleLabel.setFont(font);
        Composite pageComposite = new Composite(gridComposite, 2048);
        pageComposite.setBackground(backgroundColor);
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        pageComposite.setLayoutData((Object)new GridData(1808));
        this.addPageControls(pageComposite);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return this.dirty || this.getPreferenceStore().needsSaving();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    protected abstract void addPageControls(Composite var1);

    protected ManifestPreferenceStore getPreferenceStore() {
        return this.editor.getPreferenceStore();
    }
}

