/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.dialog;

import eclipseme.model.IPlatformDefinition;
import eclipseme.model.registry.PlatformComponentRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PlatformDefinitionSelectDialog
extends Dialog {
    private IPlatformDefinition platformDefinition;
    private Combo definitionCombo;

    public PlatformDefinitionSelectDialog(Shell parentShell) {
        super(parentShell);
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            int selectedItem = this.definitionCombo.getSelectionIndex();
            String selectedName = this.definitionCombo.getItem(selectedItem);
            this.platformDefinition = this.getRegistry().getPlatformDefinition(selectedName);
        }
        return super.close();
    }

    public IPlatformDefinition getPlatformDefinition() {
        return this.platformDefinition;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        parent.getShell().setText("Select Platform Definition");
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText("Select Platform Definition:");
        this.definitionCombo = new Combo(composite, 8);
        this.initializeDefinitionsCombo();
        this.definitionCombo.select(0);
        return dialogArea;
    }

    private PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    private void initializeDefinitionsCombo() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator defs = this.getRegistry().getRegisteredPlatformDefinitions();
        while (defs.hasNext()) {
            IPlatformDefinition def = (IPlatformDefinition)defs.next();
            names.add(def.getName());
        }
        Collections.sort(names);
        String[] namesArray = names.toArray(new String[names.size()]);
        this.definitionCombo.setItems(namesArray);
    }
}

