/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.actions;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.model.registry.PlatformComponentRegistry;
import eclipseme.nature.J2MENature;
import eclipseme.ui.dialog.PlatformDefinitionSelectDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertToMidletSuiteAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart workbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty()) {
            IPlatformDefinition def = this.getPlatformDefinition();
            if (def == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error During Conversion", (String)"No Platform Definition Available or Selected for Conversion");
            } else {
                this.convertSelectedProjects(def);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    private void convertProject(IJavaProject javaProject, IPlatformDefinition def, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, JavaModelException {
        IProject project = javaProject.getProject();
        IRunnableWithProgress runnable = MidletSuiteProject.getMidletSuiteCreationRunnable(project, javaProject, def);
        runnable.run(monitor);
        this.removeJ2SELibraries(javaProject, monitor);
    }

    private void convertSelectedProjects(IPlatformDefinition def) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.open();
            IProgressMonitor monitor = dialog.getProgressMonitor();
            EclipseMEPlugin.getWorkspace().run(this.getRunnable(def), monitor);
            dialog.close();
        }
        catch (CoreException e) {
            this.handleException(e);
        }
    }

    private IJavaProject getJavaProject(Object selected) {
        IJavaProject javaProject = null;
        if (selected != null) {
            if (selected instanceof IJavaProject) {
                javaProject = (IJavaProject)selected;
            } else if (selected instanceof IProject) {
                javaProject = JavaCore.create((IProject)((IProject)selected));
            }
        }
        return javaProject;
    }

    private IPlatformDefinition getPlatformDefinition() {
        PlatformDefinitionSelectDialog dialog;
        IPlatformDefinition def = null;
        Iterator defs = PlatformComponentRegistry.getInstance().getRegisteredPlatformDefinitions();
        if (defs.hasNext() && (dialog = new PlatformDefinitionSelectDialog(this.getShell())).open() == 0) {
            def = dialog.getPlatformDefinition();
        }
        return def;
    }

    private IWorkspaceRunnable getRunnable(final IPlatformDefinition def) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Converting Projects", ConvertToMidletSuiteAction.this.selection.size());
                Iterator iter = ConvertToMidletSuiteAction.this.selection.iterator();
                while (iter.hasNext()) {
                    IJavaProject javaProject = ConvertToMidletSuiteAction.this.getJavaProject(iter.next());
                    monitor.setTaskName("Converting Project " + javaProject.getElementName());
                    if (javaProject != null) {
                        boolean hasNature = false;
                        try {
                            IProject project = javaProject.getProject();
                            hasNature = J2MENature.hasJ2MENature(project);
                        }
                        catch (CoreException project) {
                            // empty catch block
                        }
                        if (!hasNature) {
                            try {
                                ConvertToMidletSuiteAction.this.convertProject(javaProject, def, monitor);
                            }
                            catch (InvocationTargetException e1) {
                                EclipseMEPlugin.throwCoreException(4, -999, e1.getTargetException());
                            }
                            catch (InterruptedException e1) {
                                EclipseMEPlugin.throwCoreException(4, -999, e1);
                            }
                        }
                    }
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
    }

    private Shell getShell() {
        return this.workbenchPart.getSite().getShell();
    }

    private void handleException(Throwable e) {
        EclipseMEPlugin.log(4, e);
        MessageDialog.openError((Shell)this.getShell(), (String)"Error During Conversion", (String)e.toString());
    }

    private boolean isJ2SELibraryEntry(IClasspathEntry entry) {
        boolean isJ2SEEntry = false;
        if (entry.getEntryKind() == 1) {
            if (entry.getPath().lastSegment().equals("JRE_LIB")) {
                isJ2SEEntry = true;
            }
        } else if (entry.getEntryKind() == 5 && entry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            isJ2SEEntry = true;
        }
        return isJ2SEEntry;
    }

    private void removeJ2SELibraries(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            if (!this.isJ2SELibraryEntry(entries[i])) {
                list.add(entries[i]);
            }
            ++i;
        }
        entries = list.toArray(new IClasspathEntry[list.size()]);
        javaProject.setRawClasspath(entries, monitor);
    }
}

