/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui;

import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.model.impl.generic.UnspecifiedPlatformDefinition;
import eclipseme.model.registry.PlatformComponentRegistry;
import eclipseme.nature.J2MENature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class J2MEProjectPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Combo platformDefsCombo;

    public boolean isValid() {
        boolean valid = false;
        if (this.platformDefsCombo == null) {
            valid = true;
        } else {
            int selectedIndex = this.platformDefsCombo.getSelectionIndex();
            if (selectedIndex != -1) {
                String unspecifiedName;
                String selectedName = this.platformDefsCombo.getItem(selectedIndex);
                valid = !selectedName.equals(unspecifiedName = UnspecifiedPlatformDefinition.singleton.getName());
            }
        }
        return valid;
    }

    public boolean performOk() {
        boolean succeeded = false;
        IProject project = this.getProject();
        boolean j2meProject = false;
        try {
            j2meProject = J2MENature.hasJ2MENature(project);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (j2meProject) {
            try {
                IMidletSuiteProject midletProject = this.getMidletSuiteProject();
                String name = this.platformDefsCombo.getText();
                IPlatformDefinition platformDef = this.getRegistry().getPlatformDefinition(name);
                midletProject.setPlatformDefinition(platformDef);
                succeeded = true;
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Set platform failed: " + ex.getMessage()));
            }
        } else {
            succeeded = true;
        }
        return succeeded;
    }

    protected Control createContents(Composite parent) {
        Control control = null;
        IProject project = this.getProject();
        if (this.isJ2MEProject(project)) {
            control = this.createJ2MEProjectContents(parent);
        } else {
            Label l = new Label(parent, 0);
            l.setText("Not a J2ME Midlet Suite project.");
            control = l;
        }
        return control;
    }

    private Control createJ2MEProjectContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        IMidletSuiteProject midletProject = this.getMidletSuiteProject();
        Label l = new Label(composite, 1);
        l.setText("J2ME Platform Definition:");
        this.platformDefsCombo = new Combo(composite, 12);
        this.platformDefsCombo.setTextLimit(150);
        this.platformDefsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (J2MEProjectPropertiesPage.this.getContainer() != null) {
                    J2MEProjectPropertiesPage.this.getContainer().updateButtons();
                }
                J2MEProjectPropertiesPage.this.updateApplyButton();
            }
        });
        this.initializePlatformDefinitions();
        String platformName = null;
        try {
            platformName = midletProject.getPlatformDefinitionName();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (platformName == null) {
            this.platformDefsCombo.select(-1);
        } else {
            String unspecifiedName = UnspecifiedPlatformDefinition.singleton.getName();
            if (platformName.equals(unspecifiedName)) {
                this.platformDefsCombo.add(unspecifiedName);
            }
            this.platformDefsCombo.setText(platformName);
        }
        return composite;
    }

    private IMidletSuiteProject getMidletSuiteProject() {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        IMidletSuiteProject midletProject = MidletSuiteProject.getMidletSuiteProject(javaProject);
        return midletProject;
    }

    private PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    private void initializePlatformDefinitions() {
        ArrayList<String> defs = new ArrayList<String>();
        Iterator defIter = this.getRegistry().getRegisteredPlatformDefinitions();
        if (defIter.hasNext()) {
            while (defIter.hasNext()) {
                IPlatformDefinition def = (IPlatformDefinition)defIter.next();
                defs.add(def.getName());
            }
            Object[] defNames = defs.toArray(new String[defs.size()]);
            Arrays.sort(defNames);
            this.platformDefsCombo.setItems((String[])defNames);
        }
    }

    private IProject getProject() {
        IProject project = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            project = (IProject)adaptable;
        } else if (adaptable instanceof IJavaProject) {
            project = ((IJavaProject)adaptable).getProject();
        }
        return project;
    }

    private boolean isJ2MEProject(IProject project) {
        boolean j2meProject = false;
        if (project != null) {
            try {
                IProjectNature nature = project.getNature("eclipseme.nature");
                j2meProject = nature != null;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return j2meProject;
    }
}

