/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IResourceFilter;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SourceResourcesFilter
implements IResourceFilter {
    private static final String[] IGNORED_FILE_SUFFIXES = new String[]{"java", "jad"};
    private static final String[] IGNORED_PROJECT_FILES = new String[]{".classpath", ".project", ".eclipseme"};
    private IJavaProject javaProject;
    private Set ignoredFileSuffixes;
    private Set ignoredProjectFolders;
    private Set ignoredProjectFiles;
    private Set classpathLibs;

    public SourceResourcesFilter(IJavaProject javaProject) throws JavaModelException {
        this.javaProject = javaProject;
        this.initIgnoredProjectFiles();
        this.initIgnoredFileSuffixes();
        this.initIgnoredProjectFolders();
        this.initIgnoredClasspathLibs(javaProject);
    }

    public boolean shouldTraverseContainer(IContainer container) {
        return !this.isIgnoredProjectFolder(container);
    }

    public boolean shouldBeIncluded(IFile file) {
        boolean isIgnoredProjectFile;
        boolean bl = isIgnoredProjectFile = this.parentIsProject((IResource)file) && this.ignoredProjectFiles.contains(file.getName());
        return !isIgnoredProjectFile && !this.isIgnoredProjectFolder(file.getParent()) && !this.classpathLibs.contains(file.getFullPath()) && !this.ignoredFileSuffixes.contains(file.getFileExtension());
    }

    private void initIgnoredClasspathLibs(IJavaProject javaProject) throws JavaModelException {
        this.classpathLibs = new HashSet();
        IClasspathEntry[] rawEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < rawEntries.length) {
            IClasspathEntry entry = rawEntries[i];
            this.addClasspathEntryIfLib(entry);
            ++i;
        }
    }

    private void initIgnoredProjectFolders() {
        this.ignoredProjectFolders = new HashSet();
        this.ignoredProjectFolders.add(EclipseMEPlugin.getDeploymentDirectoryName());
        this.ignoredProjectFolders.add(EclipseMEPlugin.getResourcesDirectoryName());
        this.ignoredProjectFolders.add(EclipseMEPlugin.getVerifiedOutputDirectoryName());
    }

    private void initIgnoredFileSuffixes() {
        this.ignoredFileSuffixes = new HashSet();
        int i = 0;
        while (i < IGNORED_FILE_SUFFIXES.length) {
            this.ignoredFileSuffixes.add(IGNORED_FILE_SUFFIXES[i]);
            ++i;
        }
    }

    private void initIgnoredProjectFiles() {
        this.ignoredProjectFiles = new HashSet();
        int i = 0;
        while (i < IGNORED_PROJECT_FILES.length) {
            this.ignoredProjectFiles.add(IGNORED_PROJECT_FILES[i]);
            ++i;
        }
    }

    private boolean isIgnoredProjectFolder(IContainer container) {
        return this.parentIsProject((IResource)container) && this.ignoredProjectFolders.contains(container.getName());
    }

    private boolean parentIsProject(IResource resource) {
        return resource.getParent().getType() == 4;
    }

    private void addClasspathEntryIfLib(IClasspathEntry entry) throws JavaModelException {
        switch (entry.getEntryKind()) {
            case 1: {
                this.classpathLibs.add(entry.getPath());
                break;
            }
            case 5: {
                IPath path = entry.getPath();
                if (path.segment(0).equals("J2MELIB")) break;
                IClasspathContainer cpContainer = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)this.javaProject);
                IClasspathEntry[] entries = cpContainer.getClasspathEntries();
                int i = 0;
                while (i < entries.length) {
                    this.addClasspathEntryIfLib(entries[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                IClasspathEntry entry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                this.addClasspathEntryIfLib(entry2);
                break;
            }
        }
    }
}

