/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.model.impl.generic.PlatformDefinition;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;

public class J2MEClasspathContainer
implements IClasspathContainer {
    public static final String J2ME_CONTAINER = "J2MELIB";
    private IPath path;
    private IJavaProject project;
    private IClasspathEntry[] entriesCache;
    private String platformName;

    public static IPlatformDefinition getPlatformDefinition(IJavaProject project) throws CoreException {
        IPlatformDefinition platformDef = null;
        IMidletSuiteProject midletPrj = MidletSuiteProject.getMidletSuiteProject(project);
        if (midletPrj != null) {
            platformDef = midletPrj.getPlatformDefinition();
            if (platformDef == null) {
                EclipseMEPlugin.throwCoreException(4, 4, "Missing platform definition for this project");
            }
        } else {
            EclipseMEPlugin.throwCoreException(4, 4, "Project is not J2ME project");
        }
        return platformDef;
    }

    public J2MEClasspathContainer(IJavaProject project, IPath path) throws CoreException {
        this.project = project;
        this.path = path;
        IPlatformDefinition platform = J2MEClasspathContainer.getPlatformDefinition(project);
        this.platformName = platform.getName();
        this.entriesCache = PlatformDefinition.getClasspathEntriesForPlatform(platform);
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entriesCache;
    }

    public String getDescription() {
        return this.platformName == null ? "J2ME library (failed to get platform definition)" : "J2ME library [" + this.platformName + "]";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }
}

