/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model;

import eclipseme.utils.ManifestProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ApplicationDescriptor {
    public static final String MIDLET_PREFIX = "MIDlet-";
    private File sourceFile;
    private List midletDefinitions;
    private ManifestProperties manifestProperties;

    public ApplicationDescriptor(File jadFile) throws IOException {
        this.sourceFile = jadFile;
        this.midletDefinitions = new ArrayList();
        this.parseDescriptor(jadFile);
    }

    public void addMidletDefinition(MidletDefinition midletDefinition) {
        this.midletDefinitions.add(midletDefinition);
    }

    public List getMidletDefinitions() {
        return this.midletDefinitions;
    }

    public int getMidletCount() {
        return this.midletDefinitions.size();
    }

    public void store() throws IOException {
        this.store(this.sourceFile);
    }

    public void store(File jadFile) throws IOException {
        int index = 1;
        ManifestProperties copy = this.copyProperties();
        Iterator iter = this.midletDefinitions.iterator();
        while (iter.hasNext()) {
            MidletDefinition def = (MidletDefinition)iter.next();
            String key = MIDLET_PREFIX + index++;
            String value = def.toString();
            copy.setProperty(key, value);
        }
        FileOutputStream fos = new FileOutputStream(jadFile);
        copy.store(fos, "Midlet Property Definitions");
        fos.close();
    }

    private ManifestProperties copyProperties() {
        ManifestProperties copy = new ManifestProperties();
        Iterator<Object> keys = this.manifestProperties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = this.manifestProperties.getProperty(key);
            copy.setProperty(key, value);
        }
        return copy;
    }

    private void parseDescriptor(File jadFile) throws IOException {
        FileInputStream fis = new FileInputStream(jadFile);
        this.manifestProperties = new ManifestProperties();
        this.manifestProperties.load(fis);
        this.parseMidletDefinitions();
    }

    private void parseMidletDefinitions() {
        ArrayList<String> keysToRemove = new ArrayList<String>(this.manifestProperties.size());
        Iterator<Object> iter = this.manifestProperties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(MIDLET_PREFIX)) continue;
            int midletNumber = -1;
            try {
                midletNumber = Integer.parseInt(key.substring(MIDLET_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (midletNumber == -1) continue;
            String value = this.manifestProperties.getProperty(key);
            MidletDefinition def = new MidletDefinition(value);
            if (midletNumber >= this.midletDefinitions.size()) {
                this.midletDefinitions.add(def);
            } else {
                this.midletDefinitions.add(midletNumber, def);
            }
            keysToRemove.add(key);
        }
        Iterator keyIter = keysToRemove.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            this.manifestProperties.remove(key);
        }
    }

    public static class MidletDefinition {
        private String name;
        private String icon;
        private String className;

        MidletDefinition(String definitionString) {
            int fieldCount = 0;
            this.name = "";
            this.icon = "";
            this.className = "";
            StringTokenizer st = new StringTokenizer(definitionString, ",", true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals(",")) {
                    ++fieldCount;
                    continue;
                }
                switch (fieldCount) {
                    case 0: {
                        this.name = token;
                        break;
                    }
                    case 1: {
                        this.icon = token;
                        break;
                    }
                    case 2: {
                        this.className = token;
                    }
                }
            }
        }

        public MidletDefinition(String name, String icon, String className) {
            this.name = name;
            this.icon = icon;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name).append(',');
            sb.append(this.icon).append(',');
            sb.append(this.className);
            return sb.toString();
        }
    }
}

