/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.migration;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.nature.J2MENature;
import eclipseme.utils.ManifestProperties;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JADFileMigrator {
    private IWorkspaceRoot workspaceRoot;

    public JADFileMigrator(IWorkspaceRoot workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
    }

    public void doMigration() throws CoreException {
        IProject[] projects = this.workspaceRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen() && J2MENature.hasJ2MENature(projects[i])) {
                try {
                    this.migrateJadFileAsNecessary(projects[i]);
                }
                catch (IOException e) {
                    EclipseMEPlugin.throwCoreException(2, 999, e);
                }
            }
            ++i;
        }
    }

    private void copyProperties(Properties source, ManifestProperties target) {
        Iterator<Map.Entry<Object, Object>> iterator = source.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            target.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private IMidletSuiteProject getMidletSuite(IProject project) {
        IMidletSuiteProject midletSuite = null;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            midletSuite = MidletSuiteProject.getMidletSuiteProject(javaProject);
        }
        return midletSuite;
    }

    private void migrateJadFile(IFile jadFile) throws IOException, CoreException {
        Properties properties = new Properties();
        properties.load(jadFile.getContents(true));
        ManifestProperties newProperties = new ManifestProperties();
        this.copyProperties(properties, newProperties);
        FileOutputStream fos = new FileOutputStream(jadFile.getLocation().toOSString());
        newProperties.store(fos, "");
        fos.close();
        jadFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
    }

    private void migrateJadFileAsNecessary(IProject project) throws CoreException, IOException {
        String jadFileName;
        IFile jadFile;
        IMidletSuiteProject midletSuite = this.getMidletSuite(project);
        if (midletSuite != null && (jadFile = project.getFile(jadFileName = midletSuite.getJadFilename())).exists() && !jadFile.isReadOnly()) {
            this.migrateJadFileAsNecessary(jadFile);
        }
    }

    private void migrateJadFileAsNecessary(IFile jadFile) throws CoreException, IOException {
        boolean requiresMigration = this.shouldMigrateFile(jadFile);
        if (requiresMigration) {
            this.migrateJadFile(jadFile);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldMigrateFile(IFile jadFile) throws CoreException {
        boolean requiresMigration = true;
        InputStream jadStream = jadFile.getContents(true);
        try {
            try {
                Manifest manifest = new Manifest(jadStream);
                requiresMigration = false;
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                jadStream.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (IOException e1) {
            return requiresMigration;
        }
        jadStream.close();
        return requiresMigration;
    }
}

