/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import eclipseme.EclipseMEPlugin;
import eclipseme.model.IExecutableEmulator;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;

public class EmulatorRunner
extends AbstractVMRunner {
    private IExecutableEmulator emulator;
    private boolean debugMode;

    private static String getResourceString(String key) {
        return EclipseMEPlugin.getResourceString(key);
    }

    private static String getResourceString(String key, Object[] substitutions) {
        return EclipseMEPlugin.getResourceString(key, substitutions);
    }

    private static String renderDebugTarget(String classToRun, int host) {
        return EmulatorRunner.getResourceString("debugvmrunner.debug_target_string", new String[]{classToRun, String.valueOf(host)});
    }

    public static String renderProcessLabel(String[] commandLine) {
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return EmulatorRunner.getResourceString("debugvmrunner.process_label_string", new String[]{commandLine[0], timestamp});
    }

    private static String renderCommandLine(String[] commandLine) {
        StringBuffer buf = new StringBuffer();
        if (commandLine.length > 1) {
            int i = 0;
            while (i < commandLine.length) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(commandLine[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    public EmulatorRunner(IExecutableEmulator emulator, String mode) {
        this.emulator = emulator;
        this.debugMode = "debug".equals(mode);
    }

    public void run(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (this.debugMode) {
            this.runInDebug(vmRunnerConfig, launchConfig, launch, monitor);
        } else {
            this.runWithoutDebug(vmRunnerConfig, launchConfig, launch, monitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runInDebug(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(EmulatorRunner.getResourceString("debugvmrunner.launching_vm"), 4);
        subMonitor.subTask(EmulatorRunner.getResourceString("debugvmrunner.finding_free_socket"));
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(EmulatorRunner.getResourceString("debugvmrunner.no_free_socket"), null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(EmulatorRunner.getResourceString("debugvmrunner.constructing_cmd_line"));
        String[] cmdLine = this.getCommandLine(launchConfig, port);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(EmulatorRunner.getResourceString("debugvmrunner.starting_VM"));
        Connector connector = this.getConnector();
        if (connector == null) {
            this.abort(EmulatorRunner.getResourceString("debugvmrunner.no_connector"), null, 119);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        this.specifyArguments(map, port);
        Process p = null;
        try {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            try {
                                File workingDir;
                                if (monitor.isCanceled()) {
                                    Object var16_11 = null;
                                    break block19;
                                }
                                if (!this.emulator.isDebugServer()) {
                                    ((ListeningConnector)connector).startListening(map);
                                }
                                if ((p = this.exec(cmdLine, workingDir = this.getWorkingDir(vmRunnerConfig))) == null) {
                                    break block20;
                                }
                                if (monitor.isCanceled()) {
                                    p.destroy();
                                    break block21;
                                }
                                IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)EmulatorRunner.renderProcessLabel(cmdLine), (Map)this.getDefaultProcessMap());
                                process.setAttribute(IProcess.ATTR_CMDLINE, EmulatorRunner.renderCommandLine(cmdLine));
                                subMonitor.worked(1);
                                subMonitor.subTask(EmulatorRunner.getResourceString("debugvmrunner.establishing_debug_conn"));
                                if (this.emulator.isDebugServer()) {
                                    IPreferenceStore store = EclipseMEPlugin.getDefault().getPreferenceStore();
                                    int milliDelay = store.getInt("rmt_debug_delay");
                                    try {
                                        Thread.sleep(milliDelay);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                VirtualMachine vm = this.createVirtualMachine(connector, map, p, process, monitor);
                                JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)EmulatorRunner.renderDebugTarget(vmRunnerConfig.getClassToLaunch(), port), (IProcess)process, (boolean)true, (boolean)false);
                                subMonitor.worked(1);
                                subMonitor.done();
                                break block22;
                            }
                            catch (Throwable throwable) {
                                Object var16_15 = null;
                                if (!this.emulator.isDebugServer()) {
                                    ((ListeningConnector)connector).stopListening(map);
                                }
                                throw throwable;
                            }
                        }
                        if (this.emulator.isDebugServer()) return;
                        ((ListeningConnector)connector).stopListening(map);
                        return;
                    }
                    Object var16_12 = null;
                    if (this.emulator.isDebugServer()) return;
                    ((ListeningConnector)connector).stopListening(map);
                    return;
                }
                Object var16_13 = null;
                if (this.emulator.isDebugServer()) return;
                ((ListeningConnector)connector).stopListening(map);
                return;
            }
            Object var16_14 = null;
            if (this.emulator.isDebugServer()) return;
            ((ListeningConnector)connector).stopListening(map);
            return;
        }
        catch (IOException e) {
            this.abort(EmulatorRunner.getResourceString("debugvmrunner.couldnt_connect_to_vm"), e, 120);
        }
        catch (IllegalConnectorArgumentsException e) {
            this.abort(EmulatorRunner.getResourceString("debugvmrunner.couldnt_connect_to_vm"), e, 120);
        }
        if (p != null) {
            p.destroy();
        }
    }

    private VirtualMachine createVirtualMachine(Connector connector, Map map, Process p, IProcess process, IProgressMonitor monitor) throws IOException, IllegalConnectorArgumentsException, CoreException {
        VirtualMachine vm = this.emulator.isDebugServer() ? ((AttachingConnector)connector).attach(map) : this.waitForDebuggerConnection((ListeningConnector)connector, p, process, map, monitor);
        return vm;
    }

    private Connector getConnector() {
        Connector connector = this.emulator.isDebugServer() ? this.getAttachingConnector() : this.getListeningConnector();
        return connector;
    }

    private VirtualMachine waitForDebuggerConnection(ListeningConnector connector, Process p, IProcess process, Map map, IProgressMonitor monitor) throws CoreException, IOException, IllegalConnectorArgumentsException {
        VirtualMachine vm = null;
        boolean retry = false;
        while (true) {
            try {
                ConnectRunnable runnable = new ConnectRunnable(connector, map);
                Thread connectThread = new Thread((Runnable)runnable, "Listening Connector");
                connectThread.start();
                while (connectThread.isAlive()) {
                    if (monitor.isCanceled()) {
                        connector.stopListening(map);
                        p.destroy();
                        break;
                    }
                    try {
                        p.exitValue();
                        try {
                            connector.stopListening(map);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.checkErrorMessage(process);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Exception ex = runnable.getException();
                if (ex instanceof IllegalConnectorArgumentsException) {
                    throw (IllegalConnectorArgumentsException)ex;
                }
                if (ex instanceof InterruptedIOException) {
                    throw (InterruptedIOException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                vm = runnable.getVirtualMachine();
            }
            catch (InterruptedIOException e) {
                this.checkErrorMessage(process);
                Status status = new Status(4, "eclipseme", 117, "", (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                retry = false;
                if (handler == null) {
                    throw new CoreException((IStatus)status);
                }
                Object result = handler.handleStatus((IStatus)status, (Object)this);
                if (!(result instanceof Boolean)) continue;
                retry = (Boolean)result;
                if (retry) continue;
            }
            break;
        }
        return vm;
    }

    public void runWithoutDebug(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(EmulatorRunner.getResourceString("debugvmrunner.launching_vm"), 3);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(EmulatorRunner.getResourceString("debugvmrunner.constructing_cmd_line"));
        String[] cmdLine = this.getCommandLine(launchConfig, -1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(EmulatorRunner.getResourceString("debugvmrunner.starting_VM"));
        if (monitor.isCanceled()) {
            return;
        }
        File workingDir = this.getWorkingDir(vmRunnerConfig);
        Process p = this.exec(cmdLine, workingDir);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)EmulatorRunner.renderProcessLabel(cmdLine), (Map)this.getDefaultProcessMap());
        process.setAttribute(IProcess.ATTR_CMDLINE, EmulatorRunner.renderCommandLine(cmdLine));
        subMonitor.worked(1);
    }

    protected String getPluginIdentifier() {
        return "eclipseme";
    }

    protected void addArguments(String[] args, List allArgs) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                allArgs.add(args[i]);
                ++i;
            }
        }
    }

    protected void checkErrorMessage(IProcess process) throws CoreException {
        String errorMessage = process.getStreamsProxy().getErrorStreamMonitor().getContents();
        if (errorMessage.length() == 0) {
            errorMessage = process.getStreamsProxy().getOutputStreamMonitor().getContents();
        }
        if (errorMessage.length() != 0) {
            this.abort(errorMessage, null, 116);
        }
    }

    private boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    private AttachingConnector getAttachingConnector() {
        AttachingConnector connector = null;
        List<AttachingConnector> connectors = Bootstrap.virtualMachineManager().attachingConnectors();
        int i = 0;
        while (i < connectors.size()) {
            AttachingConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketAttach".equals(c.name())) {
                connector = c;
            }
            ++i;
        }
        return connector;
    }

    private ListeningConnector getListeningConnector() {
        ListeningConnector connector = null;
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        int i = 0;
        while (i < connectors.size()) {
            ListeningConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketListen".equals(c.name())) {
                connector = c;
            }
            ++i;
        }
        return connector;
    }

    private File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        File dir = null;
        String path = config.getWorkingDirectory();
        if (path != null && !(dir = new File(path)).isDirectory()) {
            this.abort(EmulatorRunner.getResourceString("debugvmrunner.workingdir_not_dir", new String[]{path}), null, 108);
        }
        return dir;
    }

    private void specifyArguments(Map map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    protected String[] getCommandLine(ILaunchConfiguration config, int port) throws CoreException {
        ArrayList<String> arguments = new ArrayList<String>(12);
        String commandLineString = this.emulator.getArguments(config, this.debugMode, port);
        ExecutionArguments execArgs = new ExecutionArguments("", commandLineString);
        File executable = this.emulator.getExecutable();
        if (executable != null) {
            arguments.add(executable.toString());
        }
        arguments.addAll(Arrays.asList(execArgs.getProgramArgumentsArray()));
        String[] cmdLine = arguments.toArray(new String[arguments.size()]);
        return cmdLine;
    }

    public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector connector, Map map) {
            this.fConnector = connector;
            this.fConnectionMap = map;
        }

        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (IllegalConnectorArgumentsException e) {
                this.fException = e;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

