/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.launching;

import eclipseme.EclipseMEPlugin;
import eclipseme.launching.EmulatorRunner;
import eclipseme.model.ApplicationDescriptor;
import eclipseme.model.IEmulator;
import eclipseme.model.IExecutableEmulator;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.model.impl.generic.UnspecifiedPlatformDefinition;
import eclipseme.utils.Utils;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class EmulatorLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final IStatus PROMPTER_STATUS = new Status(1, DebugUIPlugin.getUniqueIdentifier(), 200, "", null);
    private static final IStatus NO_MIDLET_STATUS = new Status(4, "eclipseme", 100, "", null);

    protected IVMRunner getVMRunner(ILaunchConfiguration launchConfig, IPlatformDefinition platformDef, String mode) throws CoreException {
        IExecutableEmulator emulator = (IExecutableEmulator)this.getEmulator(launchConfig, platformDef);
        return new EmulatorRunner(emulator, mode);
    }

    protected VMRunnerConfiguration getVMRunnerConfiguration(ILaunchConfiguration launchConfig, IPlatformDefinition platformDef, String mode) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(launchConfig);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        IEmulator emulator = this.getEmulator(launchConfig, platformDef);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(emulator.getName(), new String[0]);
        runConfig.setVMArguments(new String[0]);
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(new HashMap());
        return runConfig;
    }

    public void launch(ILaunchConfiguration launchConfig, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPlatformDefinition platformDef;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((platformDef = this.getPlatformDefinition(launchConfig)) == UnspecifiedPlatformDefinition.singleton) {
            EclipseMEPlugin.throwCoreException(4, -999, "Platform Definition Is Unspecified");
        }
        monitor.beginTask(EclipseMEPlugin.getResourceString("launchdelegate.launching", new Object[]{launchConfig.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(EclipseMEPlugin.getResourceString("launchdelegate.verifying_attrs"));
        IVMRunner runner = this.getVMRunner(launchConfig, platformDef, mode);
        VMRunnerConfiguration runConfig = this.getVMRunnerConfiguration(launchConfig, platformDef, mode);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        monitor.subTask(EclipseMEPlugin.getResourceString("launchdelegate.source_locator"));
        this.setDefaultSourceLocator(launch, launchConfig);
        monitor.worked(1);
        ((EmulatorRunner)runner).run(runConfig, launchConfig, launch, monitor);
        Utils.dumpCommandLine(launch);
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean continueLaunch = super.preLaunchCheck(configuration, mode, monitor);
        if (continueLaunch) {
            continueLaunch = this.verifyEmulationSettings(configuration, monitor);
        }
        return continueLaunch;
    }

    private IEmulator getEmulator(ILaunchConfiguration launchConfig, IPlatformDefinition platformDef) throws CoreException {
        return platformDef.getEmulator();
    }

    private IPlatformDefinition getPlatformDefinition(ILaunchConfiguration launchConfig) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(launchConfig);
        IMidletSuiteProject midletProject = MidletSuiteProject.getMidletSuiteProject(javaProject);
        return midletProject.getPlatformDefinition();
    }

    private boolean verifyEmulationSettings(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IMidletSuiteProject suite;
        ApplicationDescriptor desc;
        IJavaProject javaProject;
        boolean valid = true;
        boolean doOTA = configuration.getAttribute("eclipseme.do_ota", false);
        if (doOTA && (javaProject = this.getJavaProject(configuration)) != null && (desc = (suite = MidletSuiteProject.getMidletSuiteProject(javaProject)).getApplicationDescriptor()) != null) {
            boolean bl = valid = desc.getMidletCount() > 0;
            if (!valid) {
                valid = this.shouldContinue();
            }
        }
        return valid;
    }

    private boolean shouldContinue() throws CoreException {
        boolean shouldContinue = false;
        IStatusHandler prompterStatus = DebugPlugin.getDefault().getStatusHandler(PROMPTER_STATUS);
        if (prompterStatus == null) {
            throw new CoreException(NO_MIDLET_STATUS);
        }
        Object result = prompterStatus.handleStatus(NO_MIDLET_STATUS, (Object)this);
        if (result instanceof Boolean) {
            shouldContinue = (Boolean)result;
        }
        return shouldContinue;
    }
}

