/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.builder;

import eclipseme.EclipseMEPlugin;
import eclipseme.builder.BuildInfo;
import eclipseme.builder.ResourceDeltaBuilder;
import eclipseme.utils.AbstractClasspathEntryVisitor;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class PreverificationBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IJavaProject[] requiredProjects = this.getRequiredProjects(javaProject, monitor);
        monitor.beginTask("Preverification", requiredProjects.length + 1);
        BuildInfo buildInfo = new BuildInfo(kind, args, javaProject);
        this.preverifyProject(buildInfo, monitor);
        int i = 0;
        while (i < requiredProjects.length) {
            javaProject = requiredProjects[i];
            buildInfo.setCurrentJavaProject(javaProject);
            this.preverifyProject(buildInfo, monitor);
            ++i;
        }
        this.setResourcesAsDerived(buildInfo.getVerifiedFolder(monitor), monitor);
        monitor.done();
        IProject[] interestingProjects = new IProject[requiredProjects.length];
        int i2 = 0;
        while (i2 < requiredProjects.length) {
            interestingProjects[i2] = requiredProjects[i2].getProject();
            ++i2;
        }
        return interestingProjects;
    }

    private IJavaProject[] getRequiredProjects(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        RequiredProjectsCPEntryVisitor visitor = new RequiredProjectsCPEntryVisitor();
        visitor.getRunner().run(javaProject, visitor, monitor);
        ArrayList projects = visitor.getRequiredProjects();
        return projects.toArray(new IJavaProject[projects.size()]);
    }

    private void preverifyProject(BuildInfo buildInfo, IProgressMonitor monitor) throws CoreException {
        IProject project = buildInfo.getCurrentJavaProject().getProject();
        if (project != null && project.isAccessible()) {
            monitor.setTaskName("Preverifying " + project.getName());
            buildInfo.setCurrentResourceDelta(null);
            if (buildInfo.getBuildKind() != 6) {
                buildInfo.setCurrentResourceDelta(this.getDelta(project));
            }
            ResourceDeltaBuilder deltaBuilder = new ResourceDeltaBuilder(buildInfo);
            deltaBuilder.build(monitor);
            monitor.worked(1);
        }
    }

    private void setResourcesAsDerived(IFolder verifiedFolder, IProgressMonitor monitor) throws CoreException {
        verifiedFolder.refreshLocal(2, monitor);
        EclipseMEPlugin.setResourcesAsDerived((IContainer)verifiedFolder);
    }

    private class RequiredProjectsCPEntryVisitor
    extends AbstractClasspathEntryVisitor {
        private ArrayList requiredProjects = new ArrayList();

        RequiredProjectsCPEntryVisitor() {
        }

        public ArrayList getRequiredProjects() {
            return this.requiredProjects;
        }

        public boolean visitProject(IJavaProject javaProject, IJavaProject classpathProject, IProgressMonitor monitor) throws CoreException {
            this.requiredProjects.add(classpathProject);
            return true;
        }
    }
}

