/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.propertysheet;

import java.util.Vector;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.examples.propertysheet.MessageUtil;
import org.eclipse.ui.examples.propertysheet.StreetAddress;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Address
implements IPropertySource {
    private String city;
    private Integer province;
    private String postalCode;
    private StreetAddress street;
    public static final String P_ID_STREET = "Address.Street";
    public static final String P_ID_CITY = "Address.City";
    public static final String P_ID_PROVINCE = "Address.Province";
    public static final String P_ID_POSTALCODE = "Address.PostalCode";
    public static final String P_STREET = MessageUtil.getString("Street");
    public static final String P_CITY = MessageUtil.getString("City");
    public static final String P_PROVINCE = MessageUtil.getString("Province");
    public static final String P_POSTALCODE = MessageUtil.getString("PostalCode");
    public static final String P_DESCRIPTORS = "properties";
    private static final StreetAddress STREET_DEFAULT = new StreetAddress();
    private static final String CITY_DEFAULT = MessageUtil.getString("unspecified_city");
    private static final Integer PROVINCE_DEFAULT = new Integer(0);
    private static final String POSTALCODE_DEFAULT = "A1B2C3";
    private static Vector descriptors = new Vector();
    private static String[] provinceValues = new String[]{MessageUtil.getString("British_Columbia"), MessageUtil.getString("Alberta"), MessageUtil.getString("Saskatchewan"), MessageUtil.getString("Manitoba"), MessageUtil.getString("Ontario"), MessageUtil.getString("Quebec"), MessageUtil.getString("Newfoundland"), MessageUtil.getString("Prince_Edward_Island"), MessageUtil.getString("Nova_Scotia"), MessageUtil.getString("New_Brunswick"), MessageUtil.getString("Yukon"), MessageUtil.getString("North_West_Territories"), MessageUtil.getString("Nunavut")};

    static {
        descriptors.addElement(new PropertyDescriptor((Object)P_ID_STREET, P_STREET));
        descriptors.addElement(new TextPropertyDescriptor((Object)P_ID_CITY, P_CITY));
        TextPropertyDescriptor propertyDescriptor = new TextPropertyDescriptor((Object)P_ID_POSTALCODE, P_POSTALCODE);
        propertyDescriptor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                if (value == null) {
                    return MessageUtil.getString("postal_code_is_incomplete");
                }
                String testPostalCode = ((String)value).toUpperCase();
                int length = testPostalCode.length();
                StringBuffer postalCodeBuffer = new StringBuffer(6);
                int i = 0;
                while (i < length) {
                    char current = testPostalCode.charAt(i);
                    if (current != ' ') {
                        postalCodeBuffer.append(current);
                    }
                    ++i;
                }
                testPostalCode = postalCodeBuffer.toString();
                if (testPostalCode.length() != 6) {
                    return MessageUtil.getString("postal_code_is_incomplete");
                }
                if (testPostalCode.charAt(1) < '0' || testPostalCode.charAt(1) > '9' || testPostalCode.charAt(3) < '0' || testPostalCode.charAt(3) > '9' || testPostalCode.charAt(5) < '0' || testPostalCode.charAt(5) > '9' || testPostalCode.charAt(0) < 'A' || testPostalCode.charAt(0) > 'Z' || testPostalCode.charAt(2) < 'A' || testPostalCode.charAt(2) > 'Z' || testPostalCode.charAt(4) < 'A' || testPostalCode.charAt(4) > 'Z') {
                    return MessageUtil.format("_is_an_invalid_format_for_a_postal_code", new Object[]{testPostalCode});
                }
                return null;
            }
        });
        descriptors.addElement(propertyDescriptor);
        ComboBoxPropertyDescriptor desc = new ComboBoxPropertyDescriptor((Object)P_ID_PROVINCE, P_PROVINCE, provinceValues);
        desc.setLabelProvider((ILabelProvider)new ProvinceLabelProvider());
        descriptors.addElement(desc);
    }

    Address() {
    }

    public Address(StreetAddress street, String city, Integer province, String postalCode) {
        this.setStreet(street);
        this.setCity(city);
        this.setPostalCode(postalCode);
        this.setProvince(province);
    }

    private String getCity() {
        if (this.city == null) {
            this.city = CITY_DEFAULT;
        }
        return this.city;
    }

    private static Vector getDescriptors() {
        return descriptors;
    }

    public Object getEditableValue() {
        return this.toString();
    }

    private String getPostalCode() {
        if (this.postalCode == null) {
            this.postalCode = POSTALCODE_DEFAULT;
        }
        return this.postalCode;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Address.getDescriptors().toArray(new IPropertyDescriptor[Address.getDescriptors().size()]);
    }

    public Object getPropertyValue(Object propKey) {
        if (propKey.equals(P_ID_PROVINCE)) {
            return this.getProvince();
        }
        if (propKey.equals(P_ID_STREET)) {
            return this.getStreet();
        }
        if (propKey.equals(P_ID_CITY)) {
            return this.getCity();
        }
        if (propKey.equals(P_ID_POSTALCODE)) {
            return this.getPostalCode();
        }
        return null;
    }

    private Integer getProvince() {
        if (this.province == null) {
            this.province = PROVINCE_DEFAULT;
        }
        return this.province;
    }

    public StreetAddress getStreet() {
        if (this.street == null) {
            this.street = new StreetAddress();
        }
        return this.street;
    }

    public boolean isPropertySet(Object property) {
        if (property.equals(P_ID_PROVINCE)) {
            return this.getProvince() != PROVINCE_DEFAULT;
        }
        if (property.equals(P_ID_STREET)) {
            return !STREET_DEFAULT.equals(this.getStreet());
        }
        if (property.equals(P_ID_CITY)) {
            return this.getCity() != CITY_DEFAULT;
        }
        if (property.equals(P_ID_POSTALCODE)) {
            return this.getPostalCode() != POSTALCODE_DEFAULT;
        }
        return false;
    }

    public void resetPropertyValue(Object property) {
        if (P_ID_POSTALCODE.equals(property)) {
            this.setPostalCode(POSTALCODE_DEFAULT);
            return;
        }
        if (P_ID_CITY.equals(property)) {
            this.setCity(CITY_DEFAULT);
            return;
        }
        if (P_ID_PROVINCE.equals(property)) {
            this.setProvince(PROVINCE_DEFAULT);
            return;
        }
        if (P_ID_STREET.equals(property)) {
            this.setStreet(new StreetAddress());
            return;
        }
    }

    private void setCity(String newCity) {
        this.city = newCity;
    }

    private void setPostalCode(String newPostalCode) {
        this.postalCode = newPostalCode.toUpperCase();
    }

    public void setPropertyValue(Object name, Object value) {
        if (P_ID_POSTALCODE.equals(name)) {
            this.setPostalCode((String)value);
            return;
        }
        if (P_ID_CITY.equals(name)) {
            this.setCity((String)value);
            return;
        }
        if (P_ID_PROVINCE.equals(name)) {
            this.setProvince((Integer)value);
            return;
        }
    }

    private void setProvince(Integer newProvince) {
        this.province = newProvince;
    }

    private void setStreet(StreetAddress newStreet) {
        this.street = newStreet;
    }

    public String toString() {
        StringBuffer outStringBuffer = new StringBuffer();
        if (!this.getStreet().equals(STREET_DEFAULT)) {
            outStringBuffer.append(this.getStreet());
            outStringBuffer.append(", ");
        }
        outStringBuffer.append(this.getCity());
        outStringBuffer.append(" ");
        outStringBuffer.append(provinceValues[this.getProvince()]);
        outStringBuffer.append(", ");
        outStringBuffer.append(this.getPostalCode());
        return outStringBuffer.toString();
    }

    private static class ProvinceLabelProvider
    extends LabelProvider {
        ProvinceLabelProvider() {
        }

        public String getText(Object element) {
            String[] provinceValues = new String[]{MessageUtil.getString("British_Columbia"), MessageUtil.getString("Alberta"), MessageUtil.getString("Saskatchewan"), MessageUtil.getString("Manitoba"), MessageUtil.getString("Ontario"), MessageUtil.getString("Quebec"), MessageUtil.getString("Newfoundland"), MessageUtil.getString("Prince_Edward_Island"), MessageUtil.getString("Nova_Scotia"), MessageUtil.getString("New_Brunswick"), MessageUtil.getString("Yukon"), MessageUtil.getString("North_West_Territories"), MessageUtil.getString("Nunavut")};
            return provinceValues[(Integer)element];
        }
    }
}

