/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.PaintPlugin;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.TextFigure;
import org.eclipse.swt.examples.paint.ToolSettings;

public class TextTool
extends BasicPaintSession
implements PaintTool {
    private ToolSettings settings;
    private String drawText = PaintPlugin.getResourceString("tool.Text.settings.defaulttext");

    public TextTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    public String getDisplayName() {
        return PaintPlugin.getResourceString("tool.Text.label");
    }

    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintPlugin.getResourceString("session.Text.message"));
    }

    public void endSession() {
        this.getPaintSurface().clearRubberbandSelection();
    }

    public void resetSession() {
        this.getPaintSurface().clearRubberbandSelection();
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            this.getPaintSurface().commitRubberbandSelection();
        } else {
            this.getPaintSurface().clearRubberbandSelection();
            InputDialog inputDialog = new InputDialog(this.getPaintSurface().getShell(), PaintPlugin.getResourceString("tool.Text.dialog.title"), PaintPlugin.getResourceString("tool.Text.dialog.message"), this.drawText, null);
            inputDialog.setBlockOnOpen(true);
            inputDialog.open();
            if (inputDialog.getReturnCode() == 0) {
                this.drawText = inputDialog.getValue();
            }
            inputDialog.close();
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
    }

    public void mouseMove(MouseEvent event) {
        PaintSurface ps = this.getPaintSurface();
        ps.setStatusCoord(ps.getCurrentPosition());
        ps.clearRubberbandSelection();
        ps.addRubberbandSelection(new TextFigure(this.settings.commonForegroundColor, this.settings.commonFont, this.drawText, event.x, event.y));
    }
}

