/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.paint.AirbrushTool;
import org.eclipse.swt.examples.paint.EllipseTool;
import org.eclipse.swt.examples.paint.LineTool;
import org.eclipse.swt.examples.paint.PaintPlugin;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.PencilTool;
import org.eclipse.swt.examples.paint.PolyLineTool;
import org.eclipse.swt.examples.paint.RectangleTool;
import org.eclipse.swt.examples.paint.RoundedRectangleTool;
import org.eclipse.swt.examples.paint.TextTool;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class PaintView
extends ViewPart {
    private Display workbenchDisplay;
    private ToolSettings toolSettings;
    private PaintSurface paintSurface;
    private HashMap paintToolMap;
    private HashMap paintFillTypeMap;
    private HashMap paintLineStyleMap;
    private IAction activeToolAction;
    private IAction activeFillTypeAction;
    private IAction activeLineStyleAction;
    private Canvas activeForegroundColorCanvas;
    private Canvas activeBackgroundColorCanvas;
    private static final int numPaletteRows = 3;
    private static final int numPaletteCols = 50;
    private Color paintColorBlack;
    private Color paintColorWhite;
    private Color[] paintColors;
    private Font paintDefaultFont;

    public void dispose() {
        if (this.paintSurface != null) {
            this.paintSurface.dispose();
        }
        if (this.paintColors != null) {
            int i = 0;
            while (i < this.paintColors.length) {
                Color color = this.paintColors[i];
                if (color != null) {
                    color.dispose();
                }
                ++i;
            }
        }
        this.paintDefaultFont = null;
        this.paintColors = null;
        this.paintSurface = null;
        super.dispose();
    }

    public void setFocus() {
        this.paintSurface.setFocus();
    }

    public void createPartControl(Composite parent) {
        this.workbenchDisplay = parent.getDisplay();
        this.paintColorWhite = new Color((Device)this.workbenchDisplay, 255, 255, 255);
        this.paintColorBlack = new Color((Device)this.workbenchDisplay, 0, 0, 0);
        this.paintDefaultFont = this.workbenchDisplay.getSystemFont();
        this.paintColors = new Color[150];
        this.paintColors[0] = this.paintColorBlack;
        this.paintColors[1] = this.paintColorWhite;
        int i = 2;
        while (i < this.paintColors.length) {
            this.paintColors[i] = new Color((Device)this.workbenchDisplay, i * 7 % 255, i * 23 % 255, i * 51 % 255);
            ++i;
        }
        this.toolSettings = new ToolSettings();
        this.toolSettings.commonForegroundColor = this.paintColorBlack;
        this.toolSettings.commonBackgroundColor = this.paintColorWhite;
        this.toolSettings.commonFont = this.paintDefaultFont;
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IContributionItem)new GroupMarker("group.tools"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.Pencil"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.Airbrush"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.Line"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.PolyLine"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.Rectangle"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.RoundedRectangle"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.Ellipse"));
        toolbarManager.appendToGroup("group.tools", (IAction)new SelectPaintToolAction("tool.Text"));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IContributionItem)new GroupMarker("group.options.fill"));
        toolbarManager.appendToGroup("group.options.fill", (IAction)new SelectFillTypeAction("fill.None"));
        toolbarManager.appendToGroup("group.options.fill", (IAction)new SelectFillTypeAction("fill.Outline"));
        toolbarManager.appendToGroup("group.options.fill", (IAction)new SelectFillTypeAction("fill.Solid"));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IContributionItem)new GroupMarker("group.options.linestyle"));
        toolbarManager.appendToGroup("group.options.linestyle", (IAction)new SelectLineStyleAction("linestyle.Solid"));
        toolbarManager.appendToGroup("group.options.linestyle", (IAction)new SelectLineStyleAction("linestyle.Dash"));
        toolbarManager.appendToGroup("group.options.linestyle", (IAction)new SelectLineStyleAction("linestyle.Dot"));
        toolbarManager.appendToGroup("group.options.linestyle", (IAction)new SelectLineStyleAction("linestyle.DashDot"));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IContributionItem)new GroupMarker("group.options"));
        toolbarManager.appendToGroup("group.options", (IAction)new SelectFontAction("options.Font"));
        actionBars.updateActionBars();
        this.createGUI(parent);
        this.setPaintToolByID("tool.Pencil");
        this.setFillTypeByID("fill.None");
        this.setLineStyleByID("linestyle.Solid");
        this.setForegroundColor(this.paintColorBlack);
        this.setBackgroundColor(this.paintColorWhite);
    }

    private void createGUI(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        displayArea.setLayout((Layout)gridLayout);
        Canvas paintCanvas = new Canvas(displayArea, 1313536);
        GridData gridData = new GridData(1808);
        paintCanvas.setLayoutData((Object)gridData);
        paintCanvas.setBackground(this.paintColorWhite);
        Composite colorFrame = new Composite(displayArea, 0);
        gridData = new GridData(784);
        colorFrame.setLayoutData((Object)gridData);
        Composite toolSettingsFrame = new Composite(displayArea, 0);
        gridData = new GridData(784);
        toolSettingsFrame.setLayoutData((Object)gridData);
        Text statusText = new Text(displayArea, 2060);
        gridData = new GridData(784);
        statusText.setLayoutData((Object)gridData);
        this.paintSurface = new PaintSurface(paintCanvas, statusText, this.paintColorWhite);
        this.paintToolMap = new HashMap();
        this.paintToolMap.put("tool.Pencil", new PencilTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.Airbrush", new AirbrushTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.Line", new LineTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.PolyLine", new PolyLineTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.Rectangle", new RectangleTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.RoundedRectangle", new RoundedRectangleTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.Ellipse", new EllipseTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.Text", new TextTool(this.toolSettings, this.paintSurface));
        this.paintToolMap.put("tool.Null", null);
        this.paintFillTypeMap = new HashMap();
        this.paintFillTypeMap.put("fill.None", new Integer(0));
        this.paintFillTypeMap.put("fill.Outline", new Integer(1));
        this.paintFillTypeMap.put("fill.Solid", new Integer(2));
        this.paintLineStyleMap = new HashMap();
        this.paintLineStyleMap.put("linestyle.Solid", new Integer(1));
        this.paintLineStyleMap.put("linestyle.Dash", new Integer(2));
        this.paintLineStyleMap.put("linestyle.Dot", new Integer(3));
        this.paintLineStyleMap.put("linestyle.DashDot", new Integer(4));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        colorFrame.setLayout((Layout)gridLayout);
        this.activeForegroundColorCanvas = new Canvas(colorFrame, 2048);
        gridData = new GridData(256);
        gridData.heightHint = 24;
        gridData.widthHint = 24;
        this.activeForegroundColorCanvas.setLayoutData((Object)gridData);
        this.activeBackgroundColorCanvas = new Canvas(colorFrame, 2048);
        gridData = new GridData(256);
        gridData.heightHint = 24;
        gridData.widthHint = 24;
        this.activeBackgroundColorCanvas.setLayoutData((Object)gridData);
        final Canvas paletteCanvas = new Canvas(colorFrame, 264192);
        gridData = new GridData(768);
        gridData.heightHint = 24;
        paletteCanvas.setLayoutData((Object)gridData);
        paletteCanvas.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Rectangle bounds = paletteCanvas.getClientArea();
                Color color = this.getColorAt(bounds, e.x, e.y);
                if (e.button == 1) {
                    PaintView.this.setForegroundColor(color);
                } else {
                    PaintView.this.setBackgroundColor(color);
                }
            }

            private Color getColorAt(Rectangle bounds, int x, int y) {
                if (bounds.height <= 1 && bounds.width <= 1) {
                    return PaintView.this.paintColorWhite;
                }
                int row = (y - bounds.y) * 3 / bounds.height;
                int col = (x - bounds.x) * 50 / bounds.width;
                return PaintView.this.paintColors[Math.min(Math.max(row * 50 + col, 0), PaintView.this.paintColors.length - 1)];
            }
        });
        Listener refreshListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.gc == null) {
                    return;
                }
                Rectangle bounds = paletteCanvas.getClientArea();
                int row = 0;
                while (row < 3) {
                    int col = 0;
                    while (col < 50) {
                        int x = bounds.width * col / 50;
                        int y = bounds.height * row / 3;
                        int width = Math.max(bounds.width * (col + 1) / 50 - x, 1);
                        int height = Math.max(bounds.height * (row + 1) / 3 - y, 1);
                        e.gc.setBackground(PaintView.this.paintColors[row * 50 + col]);
                        e.gc.fillRectangle(bounds.x + x, bounds.y + y, width, height);
                        ++col;
                    }
                    ++row;
                }
            }
        };
        paletteCanvas.addListener(11, refreshListener);
        paletteCanvas.addListener(9, refreshListener);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        toolSettingsFrame.setLayout((Layout)gridLayout);
        Label label = new Label(toolSettingsFrame, 0);
        label.setText(PaintPlugin.getResourceString("settings.AirbrushRadius.text"));
        final Scale airbrushRadiusScale = new Scale(toolSettingsFrame, 256);
        airbrushRadiusScale.setMinimum(5);
        airbrushRadiusScale.setMaximum(50);
        airbrushRadiusScale.setSelection(this.toolSettings.airbrushRadius);
        airbrushRadiusScale.setLayoutData((Object)new GridData(784));
        airbrushRadiusScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PaintView)PaintView.this).toolSettings.airbrushRadius = airbrushRadiusScale.getSelection();
                PaintView.this.updateToolSettings();
            }
        });
        label = new Label(toolSettingsFrame, 0);
        label.setText(PaintPlugin.getResourceString("settings.AirbrushIntensity.text"));
        final Scale airbrushIntensityScale = new Scale(toolSettingsFrame, 256);
        airbrushIntensityScale.setMinimum(1);
        airbrushIntensityScale.setMaximum(100);
        airbrushIntensityScale.setSelection(this.toolSettings.airbrushIntensity);
        airbrushIntensityScale.setLayoutData((Object)new GridData(784));
        airbrushIntensityScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PaintView)PaintView.this).toolSettings.airbrushIntensity = airbrushIntensityScale.getSelection();
                PaintView.this.updateToolSettings();
            }
        });
    }

    private void updateToolSettings() {
        PaintTool activePaintTool = this.paintSurface.getPaintTool();
        if (activePaintTool == null) {
            return;
        }
        activePaintTool.endSession();
        activePaintTool.set(this.toolSettings);
        activePaintTool.beginSession();
    }

    public void setForegroundColor(Color color) {
        if (this.activeForegroundColorCanvas != null) {
            this.activeForegroundColorCanvas.setBackground(color);
        }
        this.toolSettings.commonForegroundColor = color;
        this.updateToolSettings();
    }

    public void setBackgroundColor(Color color) {
        if (this.activeBackgroundColorCanvas != null) {
            this.activeBackgroundColorCanvas.setBackground(color);
        }
        this.toolSettings.commonBackgroundColor = color;
        this.updateToolSettings();
    }

    public void setPaintToolByID(String id) {
        this.activeToolAction = this.handleRadioAction(this.activeToolAction, id);
        PaintTool paintTool = (PaintTool)this.paintToolMap.get(id);
        this.paintSurface.setPaintSession(paintTool);
        this.updateToolSettings();
    }

    public void setFillTypeByID(String id) {
        this.activeFillTypeAction = this.handleRadioAction(this.activeFillTypeAction, id);
        Integer fillType = (Integer)this.paintFillTypeMap.get(id);
        this.toolSettings.commonFillType = fillType;
        this.updateToolSettings();
    }

    public void setLineStyleByID(String id) {
        this.activeLineStyleAction = this.handleRadioAction(this.activeLineStyleAction, id);
        Integer lineType = (Integer)this.paintLineStyleMap.get(id);
        this.toolSettings.commonLineStyle = lineType;
        this.updateToolSettings();
    }

    private IAction handleRadioAction(IAction oldAction, String id) {
        IAction action = this.getActionByID(id);
        if (action != null) {
            if (oldAction != null) {
                oldAction.setChecked(false);
            }
            if (!action.isChecked()) {
                action.setChecked(true);
            }
            return action;
        }
        return oldAction;
    }

    private IAction getActionByID(String id) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        ActionContributionItem contributionItem = (ActionContributionItem)toolbarManager.find(id);
        if (contributionItem == null) {
            return null;
        }
        return contributionItem.getAction();
    }

    public Display getDisplay() {
        return this.workbenchDisplay;
    }

    abstract class PaintAction
    extends Action {
        public PaintAction(String id) {
            this.setId(id);
            try {
                URL installUrl = PaintPlugin.getDefault().getDescriptor().getInstallURL();
                URL imageUrl = new URL(installUrl, PaintPlugin.getResourceString(String.valueOf(id) + ".image"));
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imageUrl));
            }
            catch (MalformedURLException e) {
                PaintPlugin.logError("", e);
            }
            this.setText(PaintPlugin.getResourceString(String.valueOf(id) + ".label"));
            this.setToolTipText(PaintPlugin.getResourceString(String.valueOf(id) + ".tooltip"));
            this.setDescription(PaintPlugin.getResourceString(String.valueOf(id) + ".description"));
        }
    }

    class SelectPaintToolAction
    extends PaintAction {
        public SelectPaintToolAction(String id) {
            super(id);
        }

        public int getStyle() {
            return 2;
        }

        public void run() {
            PaintView.this.setPaintToolByID(this.getId());
        }
    }

    class SelectFillTypeAction
    extends PaintAction {
        public SelectFillTypeAction(String id) {
            super(id);
        }

        public int getStyle() {
            return 2;
        }

        public void run() {
            PaintView.this.setFillTypeByID(this.getId());
        }
    }

    class SelectLineStyleAction
    extends PaintAction {
        public SelectLineStyleAction(String id) {
            super(id);
        }

        public int getStyle() {
            return 2;
        }

        public void run() {
            PaintView.this.setLineStyleByID(this.getId());
        }
    }

    class SelectFontAction
    extends PaintAction {
        public SelectFontAction(String id) {
            super(id);
        }

        public int getStyle() {
            return 1;
        }

        public void run() {
            FontDialog fontDialog = new FontDialog(PaintView.this.paintSurface.getShell(), 32768);
            FontData[] fontDatum = ((PaintView)PaintView.this).toolSettings.commonFont.getFontData();
            if (fontDatum != null && fontDatum.length > 0) {
                fontDialog.setFontList(fontDatum);
            }
            fontDialog.setText(PaintPlugin.getResourceString("options.Font.dialog.title"));
            PaintView.this.paintSurface.hideRubberband();
            FontData fontData = fontDialog.open();
            PaintView.this.paintSurface.showRubberband();
            if (fontData != null) {
                try {
                    Font font;
                    ((PaintView)PaintView.this).toolSettings.commonFont = font = new Font((Device)PaintView.this.workbenchDisplay, fontData);
                    PaintView.this.updateToolSettings();
                }
                catch (SWTException sWTException) {}
            }
        }
    }
}

