/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintPlugin;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.graphics.Point;

public abstract class DragPaintSession
extends BasicPaintSession {
    private boolean dragInProgress = false;
    private Point anchorPosition = new Point(-1, -1);
    private Point tempPosition = new Point(-1, -1);

    protected DragPaintSession(PaintSurface paintSurface) {
        super(paintSurface);
    }

    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintPlugin.getResourceString("session.DragInteractivePaint.message"));
        this.anchorPosition.x = -1;
        this.dragInProgress = false;
    }

    public void endSession() {
    }

    public void resetSession() {
        this.getPaintSurface().clearRubberbandSelection();
        this.anchorPosition.x = -1;
        this.dragInProgress = false;
    }

    public void mouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (this.dragInProgress) {
            return;
        }
        this.dragInProgress = true;
        this.anchorPosition.x = event.x;
        this.anchorPosition.y = event.y;
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
        if (event.button != 1) {
            this.resetSession();
            return;
        }
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        if (this.anchorPosition.x == -1) {
            return;
        }
        this.getPaintSurface().commitRubberbandSelection();
    }

    public void mouseMove(MouseEvent event) {
        PaintSurface ps = this.getPaintSurface();
        if (!this.dragInProgress) {
            ps.setStatusCoord(ps.getCurrentPosition());
            return;
        }
        ps.setStatusCoordRange(this.anchorPosition, ps.getCurrentPosition());
        ps.clearRubberbandSelection();
        this.tempPosition.x = event.x;
        this.tempPosition.y = event.y;
        ps.addRubberbandSelection(this.createFigure(this.anchorPosition, this.tempPosition));
    }

    protected abstract Figure createFigure(Point var1, Point var2);
}

