/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.multipageeditor;

import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.examples.multipageeditor.MessageUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageEditorExample
extends MultiPageEditorPart
implements IGotoMarker {
    private TextEditor editor;
    private int editorIndex = 0;
    private Font font;
    private StyledText text;

    void createPage0() {
        try {
            this.editor = new TextEditor();
            this.editorIndex = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(this.editorIndex, MessageUtil.getString("Source"));
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)MessageUtil.getString("ErrorCreatingNestedEditor"), null, (IStatus)e.getStatus());
        }
    }

    void createPage1() {
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 2;
        Button fontButton = new Button(composite, 0);
        GridData gd = new GridData(1);
        gd.horizontalSpan = 2;
        fontButton.setLayoutData((Object)gd);
        fontButton.setText(MessageUtil.getString("ChangeFont"));
        fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MultiPageEditorExample.this.setFont();
            }
        });
        int index = this.addPage((Control)composite);
        this.setPageText(index, MessageUtil.getString("Properties"));
    }

    void createPage2() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.text = new StyledText(composite, 768);
        this.text.setEditable(false);
        int index = this.addPage((Control)composite);
        this.setPageText(index, MessageUtil.getString("Preview"));
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.createPage2();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(MessageUtil.getString("InvalidInput"));
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 2) {
            this.sortWords();
        }
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.getSite().getShell());
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    void sortWords() {
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        StringTokenizer tokenizer = new StringTokenizer(editorText, " \t\n\r\f!@#$%^&*()-_=+`~[]{};:'\",.<>/?|\\");
        ArrayList<String> editorWords = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            editorWords.add(tokenizer.nextToken());
        }
        Collections.sort(editorWords, Collator.getInstance());
        StringWriter displayText = new StringWriter();
        int i = 0;
        while (i < editorWords.size()) {
            displayText.write((String)editorWords.get(i));
            displayText.write("\n");
            ++i;
        }
        this.text.setText(displayText.toString());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.editorIndex);
        IDE.gotoMarker((IEditorPart)this.editor, (IMarker)marker);
    }
}

