/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.examples.xml.AttributesImpl;
import org.eclipse.compare.examples.xml.XMLChildren;
import org.eclipse.compare.examples.xml.XMLCompareMessages;
import org.eclipse.compare.examples.xml.XMLNode;
import org.eclipse.compare.examples.xml.XMLPlugin;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLStructureCreator
implements IStructureCreator {
    protected static final boolean DEBUG_MODE = false;
    public static final String DEFAULT_NAME = XMLCompareMessages.getString("XMLStructureCreator.pluginname");
    public static final String USE_UNORDERED = XMLCompareMessages.getString("XMLStructureCreator.unordered");
    public static final String USE_ORDERED;
    public static final String DEFAULT_IDMAP;
    public static final String TYPE_ELEMENT = "element";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_ATTRIBUTE = "attribute";
    public static final String ROOT_ID = "root";
    public static final char SIGN_SEPARATOR = '>';
    public static final char SIGN_ENCLOSING = '$';
    public static final String SIGN_ELEMENT = "$element$";
    public static final String SIGN_TEXT = "$text$";
    public static final String SIGN_ATTRIBUTE = "$attribute$";
    public static final String IDMAP_UNORDERED;
    public static final char ID_SEPARATOR = '<';
    public static final char ID_TYPE_BODY = '<';
    private XMLNode fcurrentParent;
    private String fsignature;
    private Document fdoc;
    private boolean ignoreBodies = false;
    private HashMap fIdMapsInternal;
    private HashMap fIdMaps;
    private HashMap fIdExtensionToName;
    private HashMap fOrderedElementsInternal;
    private HashMap fOrderedElements;
    private HashMap idMap;
    private ArrayList fOrdered;
    private String fIdMapToUse = DEFAULT_IDMAP;
    private boolean fUseIdMap = false;
    private String fFileExt;
    private boolean fFirstCall = true;
    private boolean fRemoveWhiteSpace;

    static {
        DEFAULT_IDMAP = USE_ORDERED = XMLCompareMessages.getString("XMLStructureCreator.ordered");
        IDMAP_UNORDERED = XMLCompareMessages.getString("XMLStructureCreator.idmap_unordered");
    }

    public XMLStructureCreator() {
        XMLPlugin plugin = XMLPlugin.getDefault();
        if (plugin != null) {
            this.fIdMaps = plugin.getIdMaps();
            this.fIdMapsInternal = plugin.getIdMapsInternal();
            this.fIdExtensionToName = plugin.getIdExtensionToName();
            this.fOrderedElements = plugin.getOrderedElements();
            this.fOrderedElementsInternal = plugin.getOrderedElementsInternal();
        }
        this.fRemoveWhiteSpace = false;
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public void setFileExtension(String ext) {
        this.fFileExt = ext;
    }

    public void initIdMaps() {
        if (this.fFirstCall && this.fFileExt != null) {
            this.fFirstCall = false;
            String fileExtLower = this.fFileExt.toLowerCase();
            if (this.fIdExtensionToName.containsKey(fileExtLower)) {
                this.setIdMap((String)this.fIdExtensionToName.get(fileExtLower));
            }
        }
        this.setUseIdMap();
        this.fOrdered = null;
        if (!this.isUseIdMap()) {
            this.idMap = null;
        } else if (this.fIdMaps.containsKey(this.fIdMapToUse)) {
            this.idMap = (HashMap)this.fIdMaps.get(this.fIdMapToUse);
        } else if (this.fIdMapsInternal.containsKey(this.fIdMapToUse)) {
            this.idMap = (HashMap)this.fIdMapsInternal.get(this.fIdMapToUse);
        }
        if (this.fOrderedElements != null) {
            this.fOrdered = (ArrayList)this.fOrderedElements.get(this.fIdMapToUse);
        }
        if (this.fOrdered == null && this.fOrderedElementsInternal != null) {
            this.fOrdered = (ArrayList)this.fOrderedElementsInternal.get(this.fIdMapToUse);
        }
    }

    public IStructureComparator getStructure(Object input) {
        if (!(input instanceof IStreamContentAccessor)) {
            return null;
        }
        IStreamContentAccessor sca = (IStreamContentAccessor)input;
        try {
            String contents = XMLStructureCreator.readString(sca);
            if (contents == null) {
                contents = "";
            }
            this.fdoc = new Document(contents);
            this.fsignature = "root>";
            XMLChildren root = new XMLChildren(TYPE_ELEMENT, ROOT_ID, "", String.valueOf(this.fsignature) + SIGN_ELEMENT, (IDocument)this.fdoc, 0, this.fdoc.getLength());
            this.fcurrentParent = root;
            XMLHandler handler = new XMLHandler();
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser parser = factory.newSAXParser();
                parser.parse(new InputSource(new StringReader(contents)), (DefaultHandler)handler);
            }
            catch (SAXParseException e) {
                XMLPlugin.log(e);
                return null;
            }
            catch (Exception e) {
                XMLPlugin.log(e);
                return null;
            }
            return root;
        }
        catch (CoreException ex) {
            XMLPlugin.log(ex);
            return null;
        }
    }

    public boolean canSave() {
        return true;
    }

    public boolean canRewriteTree() {
        return false;
    }

    public void rewriteTree(Differencer differencer, IDiffContainer root) {
    }

    public void save(IStructureComparator structure, Object input) {
        if (input instanceof IEditableContent && structure instanceof XMLNode) {
            IDocument document = ((XMLNode)structure).getDocument();
            IEditableContent bca = (IEditableContent)input;
            String contents = document.get();
            String encoding = null;
            if (input instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)input).getCharset();
                }
                catch (CoreException coreException) {}
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                bca.setContent(contents.getBytes(encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bca.setContent(contents.getBytes());
            }
        }
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof XMLNode) {
            String s = ((XMLNode)((Object)node)).getValue();
            if (ignoreWhitespace) {
                s = s.trim();
            }
            return s;
        }
        return null;
    }

    public IStructureComparator locate(Object path, Object source) {
        return null;
    }

    static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        String encoding = null;
        if (sa instanceof IEncodedStreamContentAccessor) {
            encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return XMLStructureCreator.readString(is, encoding);
    }

    /*
     * Exception decompiling
     */
    private static String readString(InputStream is, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 109->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Attributes sortAttributes(Attributes attrs) {
        AttributesImpl attributes = new AttributesImpl();
        int len = attrs != null ? attrs.getLength() : 0;
        int i = 0;
        while (i < len) {
            String name = attrs.getQName(i);
            int count = attributes.getLength();
            int j = 0;
            while (j < count) {
                if (name.compareTo(attributes.getQName(j)) < 0) break;
                ++j;
            }
            attributes.insertAttributeAt(j, name, attrs.getType(i), attrs.getValue(i));
            ++i;
        }
        return attributes;
    }

    public void setIdMap(String idmap_name) {
        this.fIdMapToUse = idmap_name;
    }

    public String getIdMap() {
        return this.fIdMapToUse;
    }

    public void setUseIdMap() {
        if (this.fIdMaps != null && this.fIdMapsInternal != null) {
            this.fUseIdMap = this.fIdMaps.containsKey(this.fIdMapToUse) || this.fIdMapsInternal.containsKey(this.fIdMapToUse);
        }
    }

    public boolean isUseIdMap() {
        return this.fUseIdMap;
    }

    public void updateIdMaps() {
        this.fIdMaps = XMLPlugin.getDefault().getIdMaps();
        this.fOrderedElements = XMLPlugin.getDefault().getOrderedElements();
    }

    protected boolean isWhiteSpace(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }

    protected String removeWhiteSpace(String str) {
        str = this.trimWhiteSpace(str);
        StringBuffer retStr = new StringBuffer();
        int start = 0;
        int end = 0;
        while (true) {
            if (end < str.length() && !this.isWhiteSpace(str.charAt(end))) {
                ++end;
                continue;
            }
            if (end > str.length()) break;
            if (start != 0) {
                retStr.append(' ');
            }
            retStr.append(str.substring(start, end));
            ++end;
            while (end < str.length() && this.isWhiteSpace(str.charAt(end))) {
                ++end;
            }
            start = end;
        }
        return retStr.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String trimWhiteSpace(String str) {
        start = 0;
        end = str.length() - 1;
        while (start < str.length() && this.isWhiteSpace(str.charAt(start))) {
            ++start;
        }
        if (start != str.length()) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            --end;
lbl9:
            // 2 sources

            ** while (end >= 0 && this.isWhiteSpace((char)str.charAt((int)end)))
        }
lbl10:
        // 1 sources

        return str.substring(start, end + 1);
    }

    public void setRemoveWhiteSpace(boolean removeWhiteSpace) {
        this.fRemoveWhiteSpace = removeWhiteSpace;
    }

    public boolean getRemoveWhiteSpace() {
        return this.fRemoveWhiteSpace;
    }

    protected class XMLHandler
    extends DefaultHandler {
        protected Locator prevlocator;
        protected Locator locator;

        protected XMLHandler() {
        }

        public void setDocumentLocator(Locator locator0) {
            this.locator = locator0;
        }

        public void processingInstruction(String target, String data) {
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void startDocument() {
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void startElement(String uri, String local, String raw, Attributes attrs) {
            block28: {
                try {
                    String element_string;
                    int column_offset;
                    int[] element_lines_length;
                    int element_lines_length_size;
                    String elementName;
                    String elementId;
                    XMLChildren currentParent = (XMLChildren)XMLStructureCreator.this.fcurrentParent;
                    ++currentParent.children;
                    IRegion r = XMLStructureCreator.this.fdoc.getLineInformation(this.prevlocator.getLineNumber() - 1);
                    String parentSig = XMLStructureCreator.this.fsignature;
                    XMLStructureCreator.this.fsignature = String.valueOf(XMLStructureCreator.this.fsignature) + raw + '>';
                    if (XMLStructureCreator.this.isUseIdMap() && XMLStructureCreator.this.idMap.containsKey(XMLStructureCreator.this.fsignature)) {
                        String attrName = (String)XMLStructureCreator.this.idMap.get(XMLStructureCreator.this.fsignature);
                        elementId = String.valueOf(raw) + new Character('<') + attrs.getValue(attrName);
                        elementName = String.valueOf(raw) + " [" + attrName + "=" + attrs.getValue(attrName) + "]";
                    } else {
                        if (!currentParent.childElements.containsKey(raw)) {
                            currentParent.childElements.put(raw, new Integer(1));
                        } else {
                            currentParent.childElements.put(raw, new Integer((Integer)currentParent.childElements.get(raw) + 1));
                        }
                        elementId = String.valueOf(raw) + new Character('<') + "[" + currentParent.childElements.get(raw) + "]";
                        elementName = MessageFormat.format("{0} [{1}]", raw, currentParent.childElements.get(raw).toString());
                    }
                    int start = r.getOffset() + this.prevlocator.getColumnNumber() - 1;
                    if (start < 0) {
                        start = 0;
                    }
                    XMLNode currentElement = new XMLChildren(XMLStructureCreator.TYPE_ELEMENT, elementId, elementId, String.valueOf(XMLStructureCreator.this.fsignature) + XMLStructureCreator.SIGN_ELEMENT, (IDocument)XMLStructureCreator.this.fdoc, start, 0);
                    currentElement.setName(elementName);
                    if (XMLStructureCreator.this.isUseIdMap() && XMLStructureCreator.this.idMap.containsKey(XMLStructureCreator.this.fsignature)) {
                        currentElement.setUsesIDMAP(true);
                    }
                    if (XMLStructureCreator.this.fOrdered != null && XMLStructureCreator.this.fOrdered.contains(parentSig)) {
                        currentElement.setIsOrderedChild(true);
                    }
                    XMLStructureCreator.this.fcurrentParent.addChild(currentElement);
                    currentElement.setParent(XMLStructureCreator.this.fcurrentParent);
                    XMLStructureCreator.this.fcurrentParent = currentElement;
                    if (attrs == null) break block28;
                    int len = attrs.getLength();
                    if (XMLStructureCreator.this.fcurrentParent.getParent().getId().equals(XMLStructureCreator.ROOT_ID)) {
                        element_lines_length_size = this.locator.getLineNumber() - this.prevlocator.getLineNumber();
                        element_lines_length = new int[element_lines_length_size];
                        column_offset = 0;
                        element_string = "";
                        int i_ell = 0;
                        while (i_ell < element_lines_length.length) {
                            IRegion attr_r = XMLStructureCreator.this.fdoc.getLineInformation(i_ell + this.prevlocator.getLineNumber());
                            element_lines_length[i_ell] = XMLStructureCreator.this.fdoc.get(attr_r.getOffset(), attr_r.getLength()).length() + 1;
                            element_string = String.valueOf(element_string) + XMLStructureCreator.this.fdoc.get(attr_r.getOffset(), attr_r.getLength()) + " ";
                            ++i_ell;
                        }
                    } else {
                        element_lines_length_size = this.locator.getLineNumber() - this.prevlocator.getLineNumber() + 1;
                        element_lines_length = new int[element_lines_length_size];
                        IRegion first_line = XMLStructureCreator.this.fdoc.getLineInformation(this.prevlocator.getLineNumber() - 1);
                        column_offset = this.prevlocator.getColumnNumber() - 1;
                        int first_line_relevant_offset = first_line.getOffset() + column_offset;
                        int first_line_relevant_length = first_line.getLength() - column_offset;
                        element_string = String.valueOf(XMLStructureCreator.this.fdoc.get(first_line_relevant_offset, first_line_relevant_length)) + " ";
                        element_lines_length[0] = element_string.length();
                        int i_ell = 1;
                        while (i_ell < element_lines_length.length) {
                            IRegion attr_r = XMLStructureCreator.this.fdoc.getLineInformation(i_ell + this.prevlocator.getLineNumber() - 1);
                            element_lines_length[i_ell] = XMLStructureCreator.this.fdoc.get(attr_r.getOffset(), attr_r.getLength()).length() + 1;
                            element_string = String.valueOf(element_string) + XMLStructureCreator.this.fdoc.get(attr_r.getOffset(), attr_r.getLength()) + " ";
                            ++i_ell;
                        }
                    }
                    int i_attr = 0;
                    while (i_attr < len) {
                        String attr_name = attrs.getQName(i_attr);
                        String attr_value = attrs.getValue(i_attr);
                        boolean found = false;
                        int first_quotes = -1;
                        int second_quotes = -1;
                        int id_index = -1;
                        while (!found) {
                            String value;
                            first_quotes = element_string.indexOf("\"", second_quotes + 1);
                            second_quotes = element_string.indexOf("\"", first_quotes + 1);
                            try {
                                value = element_string.substring(first_quotes + 1, second_quotes);
                            }
                            catch (Exception exception) {
                                value = "";
                            }
                            if (value.equals("")) {
                                found = true;
                                continue;
                            }
                            if (!value.equals(attr_value)) continue;
                            id_index = element_string.lastIndexOf(attr_name, first_quotes - 1);
                            boolean wrong = false;
                            boolean found_equal = false;
                            int i_char = id_index + attr_name.length();
                            while (i_char < first_quotes && !wrong) {
                                if (element_string.charAt(i_char) == '=') {
                                    if (!found_equal) {
                                        found_equal = true;
                                    } else {
                                        wrong = true;
                                    }
                                } else if (!Character.isWhitespace(element_string.charAt(i_char))) {
                                    wrong = true;
                                }
                                ++i_char;
                            }
                            if (wrong) continue;
                            found = true;
                        }
                        int line_of_index = 0;
                        line_of_index = 0;
                        while (id_index > element_lines_length[line_of_index] - 1) {
                            id_index -= element_lines_length[line_of_index];
                            ++line_of_index;
                        }
                        if (line_of_index == 0) {
                            id_index += column_offset;
                        }
                        line_of_index = XMLStructureCreator.this.fcurrentParent.getParent().getId().equals(XMLStructureCreator.ROOT_ID) ? (line_of_index += this.prevlocator.getLineNumber()) : (line_of_index += this.prevlocator.getLineNumber() - 1);
                        int line_of_end_of_value = 0;
                        int end_of_value_index = second_quotes;
                        line_of_end_of_value = 0;
                        while (end_of_value_index > element_lines_length[line_of_end_of_value] - 1) {
                            end_of_value_index -= element_lines_length[line_of_end_of_value];
                            ++line_of_end_of_value;
                        }
                        if (line_of_end_of_value == 0) {
                            end_of_value_index += column_offset;
                        }
                        line_of_end_of_value = XMLStructureCreator.this.fcurrentParent.getParent().getId().equals(XMLStructureCreator.ROOT_ID) ? (line_of_end_of_value += this.prevlocator.getLineNumber()) : (line_of_end_of_value += this.prevlocator.getLineNumber() - 1);
                        int attr_start_doc_offset = XMLStructureCreator.this.fdoc.getLineInformation(line_of_index).getOffset() + id_index;
                        int attr_length_doc_offset = XMLStructureCreator.this.fdoc.getLineInformation(line_of_end_of_value).getOffset() + end_of_value_index + 1 - attr_start_doc_offset;
                        currentElement = new XMLNode(XMLStructureCreator.TYPE_ATTRIBUTE, attr_name, attr_value, String.valueOf(XMLStructureCreator.this.fsignature) + attr_name + '>' + XMLStructureCreator.SIGN_ATTRIBUTE, (IDocument)XMLStructureCreator.this.fdoc, attr_start_doc_offset, attr_length_doc_offset);
                        currentElement.setName(attr_name);
                        XMLStructureCreator.this.fcurrentParent.addChild(currentElement);
                        currentElement.setParent(XMLStructureCreator.this.fcurrentParent);
                        ++i_attr;
                    }
                }
                catch (BadLocationException badLocationException) {
                    XMLChildren currentElement = new XMLChildren(XMLStructureCreator.TYPE_ELEMENT, String.valueOf(raw) + "_(" + ((XMLChildren)((XMLStructureCreator)XMLStructureCreator.this).fcurrentParent).children + ")", String.valueOf(raw) + "_(" + ((XMLChildren)((XMLStructureCreator)XMLStructureCreator.this).fcurrentParent).children + ")", String.valueOf(XMLStructureCreator.this.fsignature) + XMLStructureCreator.SIGN_ELEMENT, (IDocument)XMLStructureCreator.this.fdoc, 0, 0);
                }
            }
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void characters(char[] ch, int start, int length) {
            String chars;
            if (!XMLStructureCreator.this.ignoreBodies && !XMLStructureCreator.this.trimWhiteSpace(chars = new String(ch, start, length)).equals("")) {
                try {
                    IRegion r = XMLStructureCreator.this.fdoc.getLineInformation(this.locator.getLineNumber() - 1);
                    int offset = r.getOffset() + this.locator.getColumnNumber() - 1 - length;
                    ++((XMLStructureCreator)XMLStructureCreator.this).fcurrentParent.bodies;
                    String body_value = new String(ch, start, length);
                    if (XMLStructureCreator.this.fRemoveWhiteSpace) {
                        body_value = XMLStructureCreator.this.removeWhiteSpace(body_value);
                    }
                    XMLNode bodynode = new XMLNode(XMLStructureCreator.TYPE_TEXT, "body_(" + ((XMLStructureCreator)XMLStructureCreator.this).fcurrentParent.bodies + ")", body_value, String.valueOf(XMLStructureCreator.this.fsignature) + XMLStructureCreator.SIGN_TEXT, (IDocument)XMLStructureCreator.this.fdoc, offset, length);
                    bodynode.setName(MessageFormat.format("{0} ({1})", XMLCompareMessages.getString("XMLStructureCreator.body"), Integer.toString(((XMLStructureCreator)XMLStructureCreator.this).fcurrentParent.bodies)));
                    XMLStructureCreator.this.fcurrentParent.addChild(bodynode);
                    bodynode.setParent(XMLStructureCreator.this.fcurrentParent);
                    String popsig = XMLStructureCreator.this.fcurrentParent.getParent().getSignature();
                    popsig = popsig.substring(0, popsig.lastIndexOf(XMLStructureCreator.SIGN_ELEMENT));
                    if (XMLStructureCreator.this.isUseIdMap() && ((XMLStructureCreator)XMLStructureCreator.this).fcurrentParent.bodies == 1 && XMLStructureCreator.this.idMap.containsKey(popsig)) {
                        String pid = XMLStructureCreator.this.fcurrentParent.getId();
                        String pelementname = pid.substring(0, pid.indexOf("<"));
                        if (((String)XMLStructureCreator.this.idMap.get(popsig)).equals(String.valueOf('<') + pelementname)) {
                            XMLNode pop = XMLStructureCreator.this.fcurrentParent.getParent();
                            String popid = pop.getId();
                            String popelementname = popid.substring(0, popid.indexOf("<"));
                            pop.setId(String.valueOf(popelementname) + "<" + body_value);
                            pop.setOrigId(String.valueOf(popelementname) + "<" + body_value);
                            pop.setName(MessageFormat.format("{0} [{1}={2}]", popelementname, pelementname, body_value));
                            pop.setUsesIDMAP(true);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    XMLStructureCreator.this.fcurrentParent.addChild(new XMLNode(XMLStructureCreator.TYPE_TEXT, "body_(" + ((XMLStructureCreator)XMLStructureCreator.this).fcurrentParent.bodies + ")", new String(ch, start, length), String.valueOf(XMLStructureCreator.this.fsignature) + XMLStructureCreator.SIGN_TEXT, (IDocument)XMLStructureCreator.this.fdoc, 0, 0));
                }
            }
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void endElement(String uri, String local, String raw) {
            if (XMLStructureCreator.this.fcurrentParent.getParent() != null) {
                try {
                    IRegion r2 = XMLStructureCreator.this.fdoc.getLineInformation(this.locator.getLineNumber() - 1);
                    Position pos = XMLStructureCreator.this.fcurrentParent.getRange();
                    int elem_length = r2.getOffset() + this.locator.getColumnNumber() - 1 - pos.getOffset();
                    XMLStructureCreator.this.fcurrentParent.setLength(elem_length);
                    try {
                        XMLStructureCreator.this.fcurrentParent.setValue(XMLStructureCreator.this.fdoc.get(pos.getOffset(), elem_length));
                    }
                    catch (BadLocationException badLocationException) {
                        try {
                            XMLStructureCreator.this.fcurrentParent.setValue(XMLStructureCreator.this.fdoc.get(pos.getOffset(), elem_length - 1));
                        }
                        catch (BadLocationException badLocationException2) {}
                    }
                    XMLStructureCreator.this.fcurrentParent = XMLStructureCreator.this.fcurrentParent.getParent();
                }
                catch (BadLocationException badLocationException) {}
            }
            this.prevlocator = new LocatorImpl(this.locator);
            int ssi = XMLStructureCreator.this.fsignature.lastIndexOf(62);
            ssi = XMLStructureCreator.this.fsignature.lastIndexOf(62, ssi - 1);
            XMLStructureCreator.this.fsignature = XMLStructureCreator.this.fsignature.substring(0, ssi + 1);
        }

        public void warning(SAXParseException ex) {
            System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void error(SAXParseException ex) {
            System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }
    }
}

