/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.examples.xml.XMLStructureCreator;
import org.eclipse.compare.examples.xml.XMLStructureViewer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class XMLPlugin
extends AbstractUIPlugin {
    private ListenerList fViewers;
    public static final String PLUGIN_ID = "org.eclipse.compare.examples.xml";
    private static final String ID_MAPPING_EXTENSION_POINT = "idMapping";
    private static final String MAPPING_ELEMENT_NAME = "mapping";
    private static final String IDMAP_NAME_ATTRIBUTE = "name";
    private static final String EXTENSION_NAME_ATTRIBUTE = "extension";
    private static final String MAPPING_SIGNATURE_ATTRIBUTE = "signature";
    private static final String MAPPING_ID_ATTRIBUTE = "id";
    private static final String MAPPING_ID_SOURCE = "id-source";
    private static final String MAPPING_ID_SOURCE_BODY = "body";
    private static final String ORDERED_ELEMENT_NAME = "ordered";
    private static final String ORDERED_SIGNATURE_ATTRIBUTE = "signature";
    public static final String DEFAULT_PREFIX = "XML";
    public static final String IMAGE_TYPE_PREFIX = "xml_";
    public static final String IMAGE_TYPE_ORDERED_SUFFIX = "_ordered";
    public static final String IDMAP_PREFERENCE_NAME = "idmap";
    public static final String IDMAP_PREFIX = "idmap";
    public static final char IDMAP_SEPARATOR = '*';
    public static final char IDMAP_FIELDS_SEPARATOR = '!';
    public static final String ORDERED_PREFERENCE_NAME = "ordered";
    public static final char ORDERED_FIELDS_SEPARATOR = '!';
    private static XMLPlugin fgXMLPlugin;
    private IPreferenceStore fPrefStore;
    private HashMap fIdMapsInternal;
    private HashMap fIdMaps;
    private HashMap fIdExtensionToName;
    private HashMap fOrderedElementsInternal;
    private HashMap fOrderedElements;

    public XMLPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgXMLPlugin = this;
        this.fViewers = new ListenerList();
        CompareUI.removeAllStructureViewerAliases((String)DEFAULT_PREFIX);
        this.initPrefStore();
        CompareUI.registerImageDescriptor((String)"xml_element", (ImageDescriptor)this.getImageDescriptor("obj16/element_obj.gif"));
        CompareUI.registerImageDescriptor((String)"xml_attribute", (ImageDescriptor)this.getImageDescriptor("obj16/attribute_obj.gif"));
        CompareUI.registerImageDescriptor((String)"xml_text", (ImageDescriptor)this.getImageDescriptor("obj16/text_obj.gif"));
        CompareUI.registerImageDescriptor((String)"xml_element_ordered", (ImageDescriptor)this.getImageDescriptor("obj16/element_ordered_obj.gif"));
        this.registerExtensions();
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        URL installURL = this.getDescriptor().getInstallURL();
        if (installURL != null) {
            try {
                URL url = new URL(installURL, "icons/full/" + relativePath);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException malformedURLException) {
                Assert.isTrue((boolean)false);
            }
        }
        return null;
    }

    public static XMLPlugin getDefault() {
        return fgXMLPlugin;
    }

    public void initPrefStore() {
        String IdMapName;
        this.fIdMaps = new HashMap();
        this.fIdExtensionToName = new HashMap();
        this.fPrefStore = this.getPreferenceStore();
        String IdMapPrefValue = this.fPrefStore.getString("idmap");
        int start = 0;
        int end = IdMapPrefValue.indexOf(42);
        while (end >= 0) {
            HashMap Mappings;
            String IdMapAttribute;
            String CurrentIdMap = IdMapPrefValue.substring(start, end);
            int end_of_IdMapName = CurrentIdMap.indexOf(33);
            IdMapName = CurrentIdMap.substring(0, end_of_IdMapName);
            int end_of_signature = CurrentIdMap.indexOf(33, end_of_IdMapName + 1);
            String IdMapSignature = CurrentIdMap.substring(end_of_IdMapName + 1, end_of_signature);
            int end_of_attribute = CurrentIdMap.indexOf(33, end_of_signature + 1);
            if (end_of_attribute < 0) {
                IdMapAttribute = CurrentIdMap.substring(end_of_signature + 1, CurrentIdMap.length());
            } else {
                IdMapAttribute = CurrentIdMap.substring(end_of_signature + 1, end_of_attribute);
                String IdMapExtension = CurrentIdMap.substring(end_of_attribute + 1, CurrentIdMap.length());
                if (!IdMapExtension.equals("") && !this.fIdExtensionToName.containsKey(IdMapExtension)) {
                    this.fIdExtensionToName.put(IdMapExtension, IdMapName);
                    CompareUI.addStructureViewerAlias((String)DEFAULT_PREFIX, (String)IdMapExtension);
                }
            }
            if (this.fIdMaps.containsKey(IdMapName)) {
                Mappings = (HashMap)this.fIdMaps.get(IdMapName);
                Mappings.put(IdMapSignature, IdMapAttribute);
            } else {
                Mappings = new HashMap();
                Mappings.put(IdMapSignature, IdMapAttribute);
                this.fIdMaps.put(IdMapName, Mappings);
            }
            start = end + 1;
            end = IdMapPrefValue.indexOf(42, end + 1);
        }
        this.fOrderedElements = new HashMap();
        String OrderedPrefValue = this.fPrefStore.getString("ordered");
        StringTokenizer orderedTokens = new StringTokenizer(OrderedPrefValue, new Character('!').toString());
        while (orderedTokens.hasMoreTokens()) {
            ArrayList idmapAL;
            IdMapName = orderedTokens.nextToken();
            String signature = orderedTokens.nextToken();
            if (this.fOrderedElements.containsKey(IdMapName)) {
                idmapAL = (ArrayList)this.fOrderedElements.get(IdMapName);
                idmapAL.add(signature);
                continue;
            }
            idmapAL = new ArrayList();
            idmapAL.add(signature);
            this.fOrderedElements.put(IdMapName, idmapAL);
        }
    }

    public void setIdMaps(HashMap IdMap2, HashMap IdExtensionToName, HashMap OrderedElements, boolean refresh) {
        String signature;
        this.fIdMaps = IdMap2;
        if (IdExtensionToName != null && !IdExtensionToName.equals(this.fIdExtensionToName)) {
            CompareUI.removeAllStructureViewerAliases((String)DEFAULT_PREFIX);
            this.fIdExtensionToName = IdExtensionToName;
            Set newkeySet = this.fIdExtensionToName.keySet();
            Iterator iter = newkeySet.iterator();
            while (iter.hasNext()) {
                String extension = (String)iter.next();
                CompareUI.addStructureViewerAlias((String)DEFAULT_PREFIX, (String)extension);
            }
        }
        StringBuffer IdMapPrefValue = new StringBuffer();
        Set idmapKeys = this.fIdMaps.keySet();
        Iterator iter_idmap = idmapKeys.iterator();
        while (iter_idmap.hasNext()) {
            String IdMapName = (String)iter_idmap.next();
            HashMap idmapHM = (HashMap)this.fIdMaps.get(IdMapName);
            Set mappingKeys = idmapHM.keySet();
            String extension = "";
            if (this.fIdExtensionToName.containsValue(IdMapName)) {
                Set keySet = this.fIdExtensionToName.keySet();
                Iterator iter = keySet.iterator();
                while (iter.hasNext()) {
                    extension = (String)iter.next();
                    if (((String)this.fIdExtensionToName.get(extension)).equals(IdMapName)) break;
                }
            }
            Iterator iter_mapping = mappingKeys.iterator();
            while (iter_mapping.hasNext()) {
                signature = (String)iter_mapping.next();
                IdMapPrefValue.append(String.valueOf(IdMapName) + '!' + signature + '!' + idmapHM.get(signature) + '!' + extension + '*');
            }
        }
        this.fPrefStore.setValue("idmap", IdMapPrefValue.toString());
        if (OrderedElements != null) {
            this.fOrderedElements = OrderedElements;
            StringBuffer OrderedPrefValue = new StringBuffer();
            Set orderedKeys = this.fOrderedElements.keySet();
            Iterator iter_ordered = orderedKeys.iterator();
            while (iter_ordered.hasNext()) {
                String IdMapName = (String)iter_ordered.next();
                ArrayList idmapAL = (ArrayList)this.fOrderedElements.get(IdMapName);
                Iterator iter_idmapAL = idmapAL.iterator();
                while (iter_idmapAL.hasNext()) {
                    signature = (String)iter_idmapAL.next();
                    OrderedPrefValue.append(String.valueOf(IdMapName) + '!' + signature + '!');
                }
            }
            this.fPrefStore.setValue("ordered", OrderedPrefValue.toString());
        }
        if (refresh) {
            Object[] viewers = this.fViewers.getListeners();
            int i = 0;
            while (i < viewers.length) {
                XMLStructureViewer viewer = (XMLStructureViewer)((Object)viewers[i]);
                viewer.updateIdMaps();
                viewer.contentChanged();
                ++i;
            }
        }
    }

    public HashMap getIdMaps() {
        return this.fIdMaps;
    }

    public HashMap getIdMapsInternal() {
        return this.fIdMapsInternal;
    }

    public HashMap getIdExtensionToName() {
        return this.fIdExtensionToName;
    }

    public HashMap getOrderedElements() {
        return this.fOrderedElements;
    }

    public HashMap getOrderedElementsInternal() {
        return this.fOrderedElementsInternal;
    }

    private void registerExtensions() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IConfigurationElement[] idmaps = registry.getConfigurationElementsFor(PLUGIN_ID, ID_MAPPING_EXTENSION_POINT);
        this.fIdMapsInternal = new HashMap();
        this.fOrderedElementsInternal = new HashMap();
        int i_idmap = 0;
        while (i_idmap < idmaps.length) {
            IConfigurationElement idmap = idmaps[i_idmap];
            String idmap_name = idmap.getAttribute(IDMAP_NAME_ATTRIBUTE);
            if (!idmap_name.equals(XMLStructureCreator.USE_UNORDERED) && !idmap_name.equals(XMLStructureCreator.USE_ORDERED)) {
                String ext_name;
                HashMap<String, String> idmapHM = new HashMap<String, String>();
                this.fIdMapsInternal.put(idmap_name, idmapHM);
                IConfigurationElement[] mappings = idmap.getChildren(MAPPING_ELEMENT_NAME);
                int i_mapping = 0;
                while (i_mapping < mappings.length) {
                    IConfigurationElement mapping = mappings[i_mapping];
                    String signature = mapping.getAttribute("signature");
                    String attribute = mapping.getAttribute(MAPPING_ID_ATTRIBUTE);
                    String idsource = mapping.getAttribute(MAPPING_ID_SOURCE);
                    String bodyid = "";
                    if (signature != null && !signature.equals("") && attribute != null && !attribute.equals("")) {
                        if (idsource != null && idsource.equals(MAPPING_ID_SOURCE_BODY)) {
                            bodyid = new Character('<').toString();
                        }
                        idmapHM.put("root>" + signature + '>', String.valueOf(bodyid) + attribute);
                    }
                    ++i_mapping;
                }
                IConfigurationElement[] orderedEntries = idmap.getChildren("ordered");
                if (orderedEntries.length > 0) {
                    ArrayList<String> orderedAL = new ArrayList<String>();
                    int i_ordered = 0;
                    while (i_ordered < orderedEntries.length) {
                        IConfigurationElement ordered = orderedEntries[i_ordered];
                        String signature = ordered.getAttribute("signature");
                        if (signature != null && !signature.equals("")) {
                            orderedAL.add("root>" + signature + '>');
                        }
                        ++i_ordered;
                    }
                    if (orderedAL.size() > 0) {
                        this.fOrderedElementsInternal.put(idmap_name, orderedAL);
                    }
                }
                if ((ext_name = idmap.getAttribute(EXTENSION_NAME_ATTRIBUTE)) != null && !this.fIdExtensionToName.containsKey(ext_name)) {
                    ext_name = ext_name.toLowerCase();
                    this.fIdExtensionToName.put(ext_name, idmap_name);
                    CompareUI.addStructureViewerAlias((String)DEFAULT_PREFIX, (String)ext_name);
                }
            }
            ++i_idmap;
        }
    }

    public ListenerList getViewers() {
        return this.fViewers;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = XMLPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = fgXMLPlugin.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            final WindowRef windowRef = new WindowRef();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    XMLPlugin.setActiveWorkbenchWindow(windowRef);
                }
            });
            return windowRef.window;
        }
        return window;
    }

    private static void setActiveWorkbenchWindow(WindowRef windowRef) {
        windowRef.window = null;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            shell = shell.getParent();
        }
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Object data = shells[i].getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            ++i;
        }
    }

    public static void log(Throwable e) {
        XMLPlugin.log((IStatus)new Status(4, XMLPlugin.getPluginId(), 4, "Internal Error", e));
    }

    public static void log(IStatus status) {
        XMLPlugin.getDefault().getLog().log(status);
    }

    public static String getPluginId() {
        return XMLPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    private static class WindowRef {
        public IWorkbenchWindow window;

        WindowRef() {
        }
    }
}

