/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.examples.launcher.ItemDescriptor;
import org.eclipse.swt.examples.launcher.ItemTreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LauncherPlugin
extends AbstractUIPlugin {
    private static LauncherPlugin plugin;
    private static ResourceBundle resourceBundle;
    private static final String LAUNCH_ITEMS_POINT_ID = "org.eclipse.swt.examples.launcher.launchItems";
    private static final String LAUNCH_ITEMS_XML_CATEGORY = "category";
    private static final String LAUNCH_ITEMS_XML_ITEM = "item";
    private static final String LAUNCH_ITEMS_XML_ITEM_ICON = "icon";
    private static final String LAUNCH_ITEMS_XML_ITEM_DESCRIPTION = "description";
    private static final String LAUNCH_ITEMS_XML_PROGRAM = "program";
    private static final String LAUNCH_ITEMS_XML_PROGRAM_PLUGIN = "pluginId";
    private static final String LAUNCH_ITEMS_XML_PROGRAM_CLASS = "mainClass";
    private static final String LAUNCH_ITEMS_XML_VIEW = "view";
    private static final String LAUNCH_ITEMS_XML_VIEW_VIEWID = "viewId";
    private static final String LAUNCH_ITEMS_XML_ATTRIB_ID = "id";
    private static final String LAUNCH_ITEMS_XML_ATTRIB_NAME = "name";
    private static final String LAUNCH_ITEMS_XML_ATTRIB_ENABLED = "enabled";
    private static final String LAUNCH_ITEMS_XML_ATTRIB_CATEGORY = "category";
    private static final String LAUNCH_ITEMS_XML_VALUE_TRUE = "true";
    private static final String LAUNCH_ITEMS_XML_VALUE_FALSE = "false";
    static final int liClosedFolder = 0;
    static final int liOpenFolder = 1;
    static final int liGenericExample = 2;
    static final String[] imageLocations;
    static Image[] images;

    static {
        imageLocations = new String[]{"icons/closedFolder.gif", "icons/openFolder.gif", "icons/generic_example.gif"};
    }

    public LauncherPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        resourceBundle = descriptor.getResourceBundle();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        LauncherPlugin.freeResources();
    }

    public static LauncherPlugin getDefault() {
        return plugin;
    }

    public static void initResources() {
        if (images == null) {
            images = new Image[imageLocations.length];
            int i = 0;
            while (i < imageLocations.length) {
                LauncherPlugin.images[i] = LauncherPlugin.getImageFromPlugin(plugin.getDescriptor(), imageLocations[i]);
                if (images[i] == null) {
                    LauncherPlugin.freeResources();
                    LauncherPlugin.logError(LauncherPlugin.getResourceString("error.CouldNotLoadResources"), null);
                    throw new IllegalStateException();
                }
                ++i;
            }
        }
    }

    public static void freeResources() {
        if (images != null) {
            int i = 0;
            while (i < images.length) {
                Image image = images[i];
                if (image != null) {
                    image.dispose();
                }
                ++i;
            }
            images = null;
        }
    }

    public static void logError(String message, Throwable exception) {
        plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, message, exception));
    }

    public static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(LauncherPlugin.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static ItemTreeNode getLaunchItemTree() {
        String attribId;
        String ceName;
        IConfigurationElement ce;
        ItemTreeNode categoryTree = new ItemTreeNode(new ItemDescriptor("<<Root>>", "<<Root>>", null, null, null, null, null));
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] configurationElements = pluginRegistry.getConfigurationElementsFor(LAUNCH_ITEMS_POINT_ID);
        if (configurationElements == null || configurationElements.length == 0) {
            LauncherPlugin.logError(LauncherPlugin.getResourceString("error.CouldNotFindRegisteredExtensions"), null);
            return categoryTree;
        }
        HashMap<String, ItemTreeNode> idMap = new HashMap<String, ItemTreeNode>();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement ce2 = configurationElements[i];
            String ceName2 = ce2.getName();
            String attribId2 = LauncherPlugin.getItemAttribute(ce2, LAUNCH_ITEMS_XML_ATTRIB_ID, null);
            if (!idMap.containsKey(attribId2) && ceName2.equalsIgnoreCase("category")) {
                String attribName = LauncherPlugin.getItemName(ce2);
                ItemDescriptor theDescriptor = new ItemDescriptor(attribId2, attribName, LauncherPlugin.getItemDescription(ce2), null, null, null, null);
                idMap.put(attribId2, new ItemTreeNode(theDescriptor));
            }
            ++i;
        }
        HashSet<String> tempIdSet = new HashSet<String>();
        int i2 = 0;
        while (i2 < configurationElements.length) {
            ce = configurationElements[i2];
            ceName = ce.getName();
            attribId = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_ID, null);
            if (!tempIdSet.contains(attribId) && ceName.equalsIgnoreCase("category")) {
                ItemTreeNode theNode = (ItemTreeNode)idMap.get(attribId);
                LauncherPlugin.addItemByCategory(ce, categoryTree, theNode, idMap);
                tempIdSet.add(attribId);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < configurationElements.length) {
            ItemDescriptor theDescriptor;
            String enabled;
            ce = configurationElements[i2];
            ceName = ce.getName();
            attribId = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_ID, null);
            if (!idMap.containsKey(attribId) && !ceName.equalsIgnoreCase("category") && ceName.equalsIgnoreCase(LAUNCH_ITEMS_XML_ITEM) && !(enabled = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_ENABLED, LAUNCH_ITEMS_XML_VALUE_TRUE)).equalsIgnoreCase(LAUNCH_ITEMS_XML_VALUE_FALSE) && (theDescriptor = LauncherPlugin.createItemDescriptor(ce, attribId)) != null) {
                ItemTreeNode theNode = new ItemTreeNode(theDescriptor);
                LauncherPlugin.addItemByCategory(ce, categoryTree, theNode, idMap);
                idMap.put(attribId, theNode);
            }
            ++i2;
        }
        return categoryTree;
    }

    private static void addItemByCategory(IConfigurationElement ce, ItemTreeNode root, ItemTreeNode theNode, HashMap idMap) {
        String attribCategory = LauncherPlugin.getItemAttribute(ce, "category", null);
        ItemTreeNode parentNode = null;
        if (attribCategory != null) {
            parentNode = (ItemTreeNode)idMap.get(attribCategory);
        }
        if (parentNode == null) {
            parentNode = root;
        }
        parentNode.addSortedNode(theNode);
    }

    private static ItemDescriptor createItemDescriptor(IConfigurationElement ce, String attribId) {
        String attribName = LauncherPlugin.getItemName(ce);
        Image attribIcon = LauncherPlugin.getItemIcon(ce);
        String attribDescription = LauncherPlugin.getItemDescription(ce);
        IConfigurationElement viewCE = LauncherPlugin.getItemElement(ce, LAUNCH_ITEMS_XML_VIEW);
        if (viewCE != null) {
            String attribView = LauncherPlugin.getItemAttribute(viewCE, LAUNCH_ITEMS_XML_VIEW_VIEWID, null);
            if (attribView == null) {
                LauncherPlugin.logError(LauncherPlugin.getResourceString("error.IncompleteViewLaunchItem", new Object[]{attribId}), null);
                return null;
            }
            return new ItemDescriptor(attribId, attribName, attribDescription, attribIcon, attribView, null, null);
        }
        IConfigurationElement programCE = LauncherPlugin.getItemElement(ce, LAUNCH_ITEMS_XML_PROGRAM);
        if (programCE != null) {
            String attribPluginId = LauncherPlugin.getItemAttribute(programCE, LAUNCH_ITEMS_XML_PROGRAM_PLUGIN, null);
            String attribClass = LauncherPlugin.getItemAttribute(programCE, LAUNCH_ITEMS_XML_PROGRAM_CLASS, null);
            if (attribClass == null || attribPluginId == null) {
                LauncherPlugin.logError(LauncherPlugin.getResourceString("error.IncompleteProgramLaunchItem", new Object[]{attribId}), null);
                return null;
            }
            return new ItemDescriptor(attribId, attribName, attribDescription, attribIcon, null, attribClass, attribPluginId);
        }
        LauncherPlugin.logError(LauncherPlugin.getResourceString("error.IncompleteLaunchItem", new Object[]{attribId}), null);
        return null;
    }

    private static IConfigurationElement getItemElement(IConfigurationElement ce, String element) {
        IConfigurationElement[] elementCEs = ce.getChildren(element);
        return elementCEs != null && elementCEs.length != 0 ? elementCEs[0] : null;
    }

    private static String getItemAttribute(IConfigurationElement ce, String attribute, String defaultValue) {
        String value = ce.getAttribute(attribute);
        return value != null ? value : defaultValue;
    }

    private static String getItemDescription(IConfigurationElement ce) {
        String description = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ITEM_DESCRIPTION, "");
        return description.length() == 0 ? null : description;
    }

    private static String getItemName(IConfigurationElement ce) {
        return LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_NAME, LauncherPlugin.getResourceString("launchitem.Missing.name"));
    }

    private static Image getItemIcon(IConfigurationElement ce) {
        Image icon;
        String iconPath = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ITEM_ICON, "");
        if (iconPath.length() != 0 && (icon = LauncherPlugin.getImageFromPlugin(ce.getDeclaringExtension().getDeclaringPluginDescriptor(), iconPath)) != null) {
            Image[] newImages = new Image[images.length + 1];
            System.arraycopy(images, 0, newImages, 0, images.length);
            newImages[LauncherPlugin.images.length] = icon;
            images = newImages;
            return icon;
        }
        return images[2];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Image getImageFromPlugin(IPluginDescriptor pd, String iconPath) {
        Image image2;
        InputStream is = null;
        try {
            try {
                Image image;
                URL installUrl = pd.getInstallURL();
                URL url = new URL(installUrl, iconPath);
                is = url.openConnection().getInputStream();
                ImageData source = new ImageData(is);
                ImageData mask = source.getTransparencyMask();
                image2 = image = new Image(null, source, mask);
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Image image3 = null;
                Object var8_11 = null;
                try {
                    if (is == null) return image3;
                    is.close();
                    return image3;
                }
                catch (IOException iOException) {}
                return image3;
            }
        }
        catch (Throwable throwable2) {
            Object var8_12 = null;
            try {}
            catch (IOException iOException) {
                throw throwable2;
            }
            if (is == null) throw throwable2;
            is.close();
            throw throwable2;
        }
        try {}
        catch (IOException iOException) {}
        if (is == null) return image2;
        is.close();
        return image2;
    }
}

