/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.texteditor;

import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.texteditor.Images;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TextEditor {
    Shell shell;
    ToolBar toolBar;
    StyledText text;
    Images images = new Images();
    Vector cachedStyles = new Vector();
    Color RED = null;
    Color BLUE = null;
    Color GREEN = null;
    Font font = null;
    boolean isBold = false;
    ExtendedModifyListener extendedModifyListener;
    static ResourceBundle resources = ResourceBundle.getBundle("examples_texteditor");

    Menu createEditMenu() {
        Menu bar = this.shell.getMenuBar();
        Menu menu = new Menu(bar);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(resources.getString("Cut_menuitem"));
        item.setAccelerator(SWT.MOD1 + 88);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.handleCutCopy();
                TextEditor.this.text.cut();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(resources.getString("Copy_menuitem"));
        item.setAccelerator(SWT.MOD1 + 67);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.handleCutCopy();
                TextEditor.this.text.copy();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(resources.getString("Paste_menuitem"));
        item.setAccelerator(SWT.MOD1 + 86);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.text.paste();
            }
        });
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        item.setText(resources.getString("Font_menuitem"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.setFont();
            }
        });
        return menu;
    }

    Menu createFileMenu() {
        Menu bar = this.shell.getMenuBar();
        Menu menu = new Menu(bar);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(resources.getString("Exit_menuitem"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.shell.close();
            }
        });
        return menu;
    }

    void bold(boolean bold) {
        this.isBold = bold;
        Point sel = this.text.getSelectionRange();
        if (sel != null && sel.y != 0) {
            int fontStyle = 0;
            if (this.isBold) {
                fontStyle = 1;
            }
            StyleRange style = new StyleRange(sel.x, sel.y, null, null, fontStyle);
            this.text.setStyleRange(style);
        }
        this.text.setSelectionRange(sel.x + sel.y, 0);
    }

    void clear() {
        Point sel = this.text.getSelectionRange();
        if (sel != null && sel.y != 0) {
            StyleRange style = new StyleRange(sel.x, sel.y, null, null, 0);
            this.text.setStyleRange(style);
        }
        this.text.setSelectionRange(sel.x + sel.y, 0);
    }

    void fgColor(int color) {
        Point sel = this.text.getSelectionRange();
        if (sel == null || sel.y == 0) {
            return;
        }
        Object fg = color == 3 ? this.RED : (color == 5 ? this.GREEN : (color == 9 ? this.BLUE : null));
        int i = sel.x;
        while (i < sel.x + sel.y) {
            StyleRange range = this.text.getStyleRangeAtOffset(i);
            StyleRange style = range == null ? new StyleRange(i, 1, fg, null, 0) : new StyleRange(i, 1, fg, null, range.fontStyle);
            this.text.setStyleRange(style);
            ++i;
        }
        this.text.setSelectionRange(sel.x + sel.y, 0);
    }

    void createMenuBar() {
        Menu bar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(bar);
        MenuItem fileItem = new MenuItem(bar, 64);
        fileItem.setText(resources.getString("File_menuitem"));
        fileItem.setMenu(this.createFileMenu());
        MenuItem editItem = new MenuItem(bar, 64);
        editItem.setText(resources.getString("Edit_menuitem"));
        editItem.setMenu(this.createEditMenu());
    }

    void createShell(Display display) {
        this.shell = new Shell(display);
        this.shell.setText(resources.getString("Window_title"));
        this.images.loadAll(display);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setLayout((Layout)layout);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TextEditor.this.font != null) {
                    TextEditor.this.font.dispose();
                }
                TextEditor.this.images.freeAll();
                TextEditor.this.RED.dispose();
                TextEditor.this.GREEN.dispose();
                TextEditor.this.BLUE.dispose();
            }
        });
    }

    void createStyledText() {
        this.initializeColors();
        this.text = new StyledText((Composite)this.shell, 2818);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)spec);
        this.extendedModifyListener = new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                TextEditor.this.handleExtendedModify(e);
            }
        };
        this.text.addExtendedModifyListener(this.extendedModifyListener);
    }

    void createToolBar() {
        this.toolBar = new ToolBar((Composite)this.shell, 0);
        ToolItem item = new ToolItem(this.toolBar, 32);
        item.setImage(this.images.Bold);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.bold(((ToolItem)event.widget).getSelection());
            }
        });
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.images.Red);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.fgColor(3);
            }
        });
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.images.Green);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.fgColor(5);
            }
        });
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.images.Blue);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.fgColor(9);
            }
        });
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(this.images.Erase);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditor.this.clear();
            }
        });
    }

    void displayError(String msg) {
        MessageBox box = new MessageBox(this.shell, 1);
        box.setMessage(msg);
        box.open();
    }

    void handleCutCopy() {
        this.cachedStyles = new Vector();
        Point sel = this.text.getSelectionRange();
        int startX = sel.x;
        int i = sel.x;
        while (i <= sel.x + sel.y - 1) {
            StyleRange style = this.text.getStyleRangeAtOffset(i);
            if (style != null) {
                style.start -= startX;
                if (!this.cachedStyles.isEmpty()) {
                    StyleRange lastStyle = (StyleRange)this.cachedStyles.lastElement();
                    if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                        ++lastStyle.length;
                    } else {
                        this.cachedStyles.addElement(style);
                    }
                } else {
                    this.cachedStyles.addElement(style);
                }
            }
            ++i;
        }
    }

    void handleExtendedModify(ExtendedModifyEvent event) {
        block6: {
            block4: {
                block5: {
                    if (event.length == 0) {
                        return;
                    }
                    if (event.length != 1 && !this.text.getTextRange(event.start, event.length).equals(this.text.getLineDelimiter())) break block4;
                    int caretOffset = this.text.getCaretOffset();
                    StyleRange style = null;
                    if (caretOffset < this.text.getCharCount()) {
                        style = this.text.getStyleRangeAtOffset(caretOffset);
                    }
                    if (style == null) break block5;
                    style.start = event.start;
                    style.length = event.length;
                    int fontStyle = 0;
                    if (this.isBold) {
                        fontStyle = 1;
                    }
                    style.fontStyle = fontStyle;
                    this.text.setStyleRange(style);
                    break block6;
                }
                if (!this.isBold) break block6;
                StyleRange newStyle = new StyleRange(event.start, event.length, null, null, 1);
                this.text.setStyleRange(newStyle);
                break block6;
            }
            int i = 0;
            while (i < this.cachedStyles.size()) {
                StyleRange style = (StyleRange)this.cachedStyles.elementAt(i);
                StyleRange newStyle = (StyleRange)style.clone();
                newStyle.start = style.start + event.start;
                this.text.setStyleRange(newStyle);
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        TextEditor example = new TextEditor();
        Shell shell = example.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        this.createShell(display);
        this.createMenuBar();
        this.createToolBar();
        this.createStyledText();
        this.shell.setSize(500, 300);
        this.shell.open();
        return this.shell;
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.shell);
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.shell.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    void initializeColors() {
        Display display = Display.getDefault();
        this.RED = new Color((Device)display, new RGB(255, 0, 0));
        this.BLUE = new Color((Device)display, new RGB(0, 0, 255));
        this.GREEN = new Color((Device)display, new RGB(0, 255, 0));
    }
}

