/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.layoutexample.FillLayoutTab;
import org.eclipse.swt.examples.layoutexample.FormLayoutTab;
import org.eclipse.swt.examples.layoutexample.GridLayoutTab;
import org.eclipse.swt.examples.layoutexample.RowLayoutTab;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class LayoutExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_layout");
    private TabFolder tabFolder;

    public LayoutExample(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        Tab[] tabs = new Tab[]{new FillLayoutTab(this), new RowLayoutTab(this), new GridLayoutTab(this), new FormLayoutTab(this)};
        int i = 0;
        while (i < tabs.length) {
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(tabs[i].getTabText());
            item.setControl((Control)tabs[i].createTabFolderPage(this.tabFolder));
            ++i;
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void dispose() {
        this.tabFolder = null;
    }

    public static void main(String[] args) {
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        new LayoutExample((Composite)shell);
        shell.setText(LayoutExample.getResourceString("window.title"));
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                Shell[] shells = display.getShells();
                int i = 0;
                while (i < shells.length) {
                    if (shells[i] != shell) {
                        shells[i].close();
                    }
                    ++i;
                }
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(LayoutExample.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }
}

