/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class ToolBarTab
extends Tab {
    ToolBar imageToolBar;
    ToolBar textToolBar;
    Group imageToolBarGroup;
    Group textToolBarGroup;
    Button horizontalButton;
    Button verticalButton;
    Button flatButton;
    Button shadowOutButton;
    Button wrapButton;
    Button rightButton;

    ToolBarTab(ControlExample instance) {
        super(instance);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.imageToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageToolBarGroup.setLayout((Layout)new GridLayout());
        this.imageToolBarGroup.setLayoutData((Object)new GridData(784));
        this.imageToolBarGroup.setText(ControlExample.getResourceString("Image_ToolBar"));
        this.textToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.textToolBarGroup.setLayout((Layout)new GridLayout());
        this.textToolBarGroup.setLayoutData((Object)new GridData(784));
        this.textToolBarGroup.setText(ControlExample.getResourceString("Text_ToolBar"));
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.flatButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.shadowOutButton.getSelection()) {
            style |= 8;
        }
        if (this.rightButton.getSelection()) {
            style |= 0x20000;
        }
        this.imageToolBar = new ToolBar((Composite)this.imageToolBarGroup, style);
        ToolItem item = new ToolItem(this.imageToolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.imageToolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 32);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 2);
        item.setToolTipText("SWT.SEPARATOR");
        item = new ToolItem(this.imageToolBar, 4);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.textToolBar = new ToolBar((Composite)this.textToolBarGroup, style);
        item = new ToolItem(this.textToolBar, 8);
        item.setText(ControlExample.getResourceString("Push"));
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.textToolBar, 8);
        item.setText(ControlExample.getResourceString("Push"));
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 32);
        item.setText(ControlExample.getResourceString("Check"));
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 2);
        item.setToolTipText("SWT.SEPARATOR");
        item = new ToolItem(this.textToolBar, 4);
        item.setText(ControlExample.getResourceString("Drop_Down"));
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.horizontalButton = new Button((Composite)this.styleGroup, 16);
        this.horizontalButton.setText("SWT.HORIZONTAL");
        this.verticalButton = new Button((Composite)this.styleGroup, 16);
        this.verticalButton.setText("SWT.VERTICAL");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.shadowOutButton = new Button((Composite)this.styleGroup, 32);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.rightButton = new Button((Composite)this.styleGroup, 32);
        this.rightButton.setText("SWT.RIGHT");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    void disposeExampleWidgets() {
        super.disposeExampleWidgets();
    }

    Item[] getExampleWidgetItems() {
        ToolItem[] imageToolBarItems = this.imageToolBar.getItems();
        ToolItem[] textToolBarItems = this.textToolBar.getItems();
        Item[] allItems = new Item[imageToolBarItems.length + textToolBarItems.length];
        System.arraycopy(imageToolBarItems, 0, allItems, 0, imageToolBarItems.length);
        System.arraycopy(textToolBarItems, 0, allItems, imageToolBarItems.length, textToolBarItems.length);
        return allItems;
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.imageToolBar, this.textToolBar};
    }

    String getTabText() {
        return "ToolBar";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.horizontalButton.setSelection((this.imageToolBar.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection((this.imageToolBar.getStyle() & 0x200) != 0);
        this.flatButton.setSelection((this.imageToolBar.getStyle() & 0x800000) != 0);
        this.wrapButton.setSelection((this.imageToolBar.getStyle() & 0x40) != 0);
        this.shadowOutButton.setSelection((this.imageToolBar.getStyle() & 8) != 0);
        this.borderButton.setSelection((this.imageToolBar.getStyle() & 0x800) != 0);
        this.rightButton.setSelection((this.imageToolBar.getStyle() & 0x20000) != 0);
    }

    class DropDownSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;
        private boolean visible = false;

        DropDownSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.menu == null) {
                Shell shell = ToolBarTab.this.tabFolderPage.getShell();
                this.menu = new Menu((Control)shell);
                int i = 0;
                while (i < 9) {
                    String text = ControlExample.getResourceString("DropDownData_" + i);
                    if (text.length() != 0) {
                        MenuItem menuItem = new MenuItem(this.menu, 0);
                        menuItem.setText(text);
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                            final /* synthetic */ DropDownSelectionListener this$1;
                            {
                                this.this$1 = dropDownSelectionListener;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                DropDownSelectionListener.access$0(this.this$1, false);
                            }
                        });
                    } else {
                        new MenuItem(this.menu, 2);
                    }
                    ++i;
                }
            }
            if (event.detail == 4) {
                if (this.visible) {
                    this.setMenuVisible(false);
                } else {
                    ToolItem toolItem = (ToolItem)event.widget;
                    ToolBar toolBar = toolItem.getParent();
                    Rectangle toolItemBounds = toolItem.getBounds();
                    Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                    this.menu.setLocation(point.x, point.y + toolItemBounds.height);
                    this.setMenuVisible(true);
                }
            }
        }

        private void setMenuVisible(boolean visible) {
            this.menu.setVisible(visible);
            this.visible = visible;
        }

        static /* synthetic */ void access$0(DropDownSelectionListener dropDownSelectionListener, boolean bl) {
            dropDownSelectionListener.setMenuVisible(bl);
        }
    }
}

