/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

class TabFolderTab
extends Tab {
    TabFolder tabFolder1;
    Group tabFolderGroup;
    Button topButton;
    Button bottomButton;
    static String[] TabItems1 = new String[]{ControlExample.getResourceString("TabItem1_0"), ControlExample.getResourceString("TabItem1_1"), ControlExample.getResourceString("TabItem1_2")};

    TabFolderTab(ControlExample instance) {
        super(instance);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.tabFolderGroup = new Group((Composite)this.exampleGroup, 0);
        this.tabFolderGroup.setLayout((Layout)new GridLayout());
        this.tabFolderGroup.setLayoutData((Object)new GridData(784));
        this.tabFolderGroup.setText("TabFolder");
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.topButton.getSelection()) {
            style |= 0x80;
        }
        if (this.bottomButton.getSelection()) {
            style |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.tabFolder1 = new TabFolder((Composite)this.tabFolderGroup, style);
        int i = 0;
        while (i < TabItems1.length) {
            TabItem item = new TabItem(this.tabFolder1, 0);
            item.setText(TabItems1[i]);
            Text content = new Text((Composite)this.tabFolder1, 66);
            content.setText(String.valueOf(ControlExample.getResourceString("TabItem_content")) + ": " + i);
            item.setControl((Control)content);
            ++i;
        }
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.topButton = new Button((Composite)this.styleGroup, 16);
        this.topButton.setText("SWT.TOP");
        this.topButton.setSelection(true);
        this.bottomButton = new Button((Composite)this.styleGroup, 16);
        this.bottomButton.setText("SWT.BOTTOM");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
                TabFolderTab.this.recreateExampleWidgets();
            }
        };
        this.topButton.addSelectionListener((SelectionListener)selectionListener);
        this.bottomButton.addSelectionListener((SelectionListener)selectionListener);
    }

    Item[] getExampleWidgetItems() {
        return this.tabFolder1.getItems();
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.tabFolder1};
    }

    String getTabText() {
        return "TabFolder";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.topButton.setSelection((this.tabFolder1.getStyle() & 0x80) != 0);
        this.bottomButton.setSelection((this.tabFolder1.getStyle() & 0x400) != 0);
        this.borderButton.setSelection((this.tabFolder1.getStyle() & 0x800) != 0);
    }
}

