/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.clipboard;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ClipboardExample {
    Clipboard clipboard;
    Shell shell;
    Text copyText;
    Text pasteText;
    Text copyRtfText;
    Text pasteRtfText;
    Table copyFileTable;
    Table pasteFileTable;
    Text text;
    Combo combo;
    StyledText styledText;
    Label status;
    static final int SIZE = 60;

    public static void main(String[] args) {
        Display display = new Display();
        new ClipboardExample().open(display);
        display.dispose();
    }

    public void open(Display display) {
        this.clipboard = new Clipboard(display);
        this.shell = new Shell(display);
        this.shell.setText("SWT Clipboard");
        this.shell.setLayout((Layout)new GridLayout(2, true));
        Group copyGroup = new Group((Composite)this.shell, 0);
        copyGroup.setText("Copy From:");
        GridData data = new GridData(1808);
        copyGroup.setLayoutData((Object)data);
        copyGroup.setLayout((Layout)new GridLayout(3, false));
        Group pasteGroup = new Group((Composite)this.shell, 0);
        pasteGroup.setText("Paste To:");
        data = new GridData(1808);
        pasteGroup.setLayoutData((Object)data);
        pasteGroup.setLayout((Layout)new GridLayout(3, false));
        Group controlGroup = new Group((Composite)this.shell, 0);
        controlGroup.setText("Control API:");
        data = new GridData(1808);
        data.horizontalSpan = 2;
        controlGroup.setLayoutData((Object)data);
        controlGroup.setLayout((Layout)new GridLayout(5, false));
        Group typesGroup = new Group((Composite)this.shell, 0);
        typesGroup.setText("Available Types");
        data = new GridData(1808);
        data.horizontalSpan = 2;
        typesGroup.setLayoutData((Object)data);
        typesGroup.setLayout((Layout)new GridLayout(2, false));
        this.status = new Label((Composite)this.shell, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.heightHint = 60;
        this.status.setLayoutData((Object)data);
        this.createTextTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createRTFTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createFileTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createMyTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createControlTransfer((Composite)controlGroup);
        this.createAvailableTypes((Composite)typesGroup);
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.clipboard.dispose();
    }

    void createTextTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("TextTransfer:");
        this.copyText = new Text(copyParent, 2818);
        this.copyText.setText("some\nplain\ntext");
        GridData data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        this.copyText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = ClipboardExample.this.copyText.getText();
                if (data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("nothing to copy");
                }
            }
        });
        l = new Label(pasteParent, 0);
        l.setText("TextTransfer:");
        this.pasteText = new Text(pasteParent, 2826);
        data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        this.pasteText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = (String)ClipboardExample.this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (data != null && data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.pasteText.setText("begin paste>" + data + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("nothing to paste");
                }
            }
        });
    }

    void createRTFTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("RTFTransfer:");
        this.copyRtfText = new Text(copyParent, 2818);
        this.copyRtfText.setText("some\nrtf\ntext");
        GridData data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        this.copyRtfText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = ClipboardExample.this.copyRtfText.getText();
                if (data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    data = "{\\rtf1{\\colortbl;\\red255\\green0\\blue0;}\\uc1\\b\\i " + data + "}";
                    ClipboardExample.this.clipboard.setContents(new Object[]{data}, new Transfer[]{RTFTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("nothing to copy");
                }
            }
        });
        l = new Label(pasteParent, 0);
        l.setText("RTFTransfer:");
        this.pasteRtfText = new Text(pasteParent, 2826);
        data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        this.pasteRtfText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = (String)ClipboardExample.this.clipboard.getContents((Transfer)RTFTransfer.getInstance());
                if (data != null && data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.pasteRtfText.setText("start paste>" + data + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("nothing to paste");
                }
            }
        });
    }

    void createFileTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("FileTransfer:");
        Composite c = new Composite(copyParent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(768);
        c.setLayoutData((Object)data);
        this.copyFileTable = new Table(c, 2050);
        data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        data.horizontalSpan = 2;
        this.copyFileTable.setLayoutData((Object)data);
        Button b = new Button(c, 8);
        b.setText("Select file(s)");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ClipboardExample.this.shell, 4098);
                String result = dialog.open();
                if (result != null && result.length() > 0) {
                    String separator = System.getProperty("file.separator");
                    String path = dialog.getFilterPath();
                    String[] names = dialog.getFileNames();
                    int i = 0;
                    while (i < names.length) {
                        TableItem item = new TableItem(ClipboardExample.this.copyFileTable, 0);
                        item.setText(String.valueOf(path) + separator + names[i]);
                        ++i;
                    }
                }
            }
        });
        b = new Button(c, 8);
        b.setText("Select directory");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ClipboardExample.this.shell, 4096);
                String result = dialog.open();
                if (result != null && result.length() > 0) {
                    TableItem item = new TableItem(ClipboardExample.this.copyFileTable, 0);
                    item.setText(result);
                }
            }
        });
        b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ClipboardExample.this.copyFileTable.getItems();
                if (items.length > 0) {
                    ClipboardExample.this.status.setText("");
                    String[] data = new String[items.length];
                    int i = 0;
                    while (i < data.length) {
                        data[i] = items[i].getText();
                        ++i;
                    }
                    ClipboardExample.this.clipboard.setContents(new Object[]{data}, new Transfer[]{FileTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("nothing to copy");
                }
            }
        });
        l = new Label(pasteParent, 0);
        l.setText("FileTransfer:");
        this.pasteFileTable = new Table(pasteParent, 2050);
        data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        this.pasteFileTable.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] data = (String[])ClipboardExample.this.clipboard.getContents((Transfer)FileTransfer.getInstance());
                if (data != null && data.length > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.pasteFileTable.removeAll();
                    int i = 0;
                    while (i < data.length) {
                        TableItem item = new TableItem(ClipboardExample.this.pasteFileTable, 0);
                        item.setText(data[i]);
                        ++i;
                    }
                } else {
                    ClipboardExample.this.status.setText("nothing to paste");
                }
            }
        });
    }

    void createMyTransfer(Composite copyParent, Composite pasteParent) {
    }

    void createControlTransfer(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Text:");
        Button b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.text.cut();
            }
        });
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.text.copy();
            }
        });
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.text.paste();
            }
        });
        this.text = new Text(parent, 2818);
        GridData data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        this.text.setLayoutData((Object)data);
        l = new Label(parent, 0);
        l.setText("Combo:");
        b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.combo.cut();
            }
        });
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.combo.copy();
            }
        });
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.combo.paste();
            }
        });
        this.combo = new Combo(parent, 0);
        this.combo.setItems(new String[]{"Item 1", "Item 2", "Item 3", "A longer Item"});
        l = new Label(parent, 0);
        l.setText("StyledText:");
        l = new Label(parent, 0);
        l.setVisible(false);
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.styledText.copy();
            }
        });
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.styledText.paste();
            }
        });
        this.styledText = new StyledText(parent, 2818);
        data = new GridData(768);
        data.widthHint = 60;
        data.heightHint = 60;
        this.styledText.setLayoutData((Object)data);
    }

    void createAvailableTypes(Composite parent) {
        final List list = new List(parent, 2816);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        list.setLayoutData((Object)data);
        Button b = new Button(parent, 8);
        b.setText("Get Available Types");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                list.removeAll();
                String[] names = ClipboardExample.this.clipboard.getAvailableTypeNames();
                int i = 0;
                while (i < names.length) {
                    list.add(names[i]);
                    ++i;
                }
            }
        });
    }
}

