/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.exampleprojects;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectCreationWizardPage;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectMessages;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectsPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class ExampleProjectCreationOperation
implements IRunnableWithProgress {
    private IResource fElementToOpen = null;
    private ExampleProjectCreationWizardPage[] fPages;
    private IOverwriteQuery fOverwriteQuery;

    public ExampleProjectCreationOperation(ExampleProjectCreationWizardPage[] pages, IOverwriteQuery overwriteQuery) {
        this.fPages = pages;
        this.fOverwriteQuery = overwriteQuery;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(ExampleProjectMessages.getString("ExampleProjectCreationOperation.op_desc"), this.fPages.length);
            IWorkspaceRoot root = ExampleProjectsPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < this.fPages.length) {
                this.createProject(root, this.fPages[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public IResource getElementToOpen() {
        return this.fElementToOpen;
    }

    private void createProject(IWorkspaceRoot root, ExampleProjectCreationWizardPage page, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IResource fileToOpen;
        IConfigurationElement desc = page.getConfigurationElement();
        IConfigurationElement[] imports = desc.getChildren("import");
        IConfigurationElement[] natures = desc.getChildren("nature");
        IConfigurationElement[] references = desc.getChildren("references");
        int nImports = imports == null ? 0 : imports.length;
        int nNatures = natures == null ? 0 : natures.length;
        int nReferences = references == null ? 0 : references.length;
        monitor.beginTask(ExampleProjectMessages.getString("ExampleProjectCreationOperation.op_desc_proj"), nImports + 1);
        String name = page.getName();
        String[] natureIds = new String[nNatures];
        int i = 0;
        while (i < nNatures) {
            natureIds[i] = natures[i].getAttribute("id");
            ++i;
        }
        IProject[] referencedProjects = new IProject[nReferences];
        int i2 = 0;
        while (i2 < nReferences) {
            referencedProjects[i2] = root.getProject(references[i2].getAttribute("id"));
            ++i2;
        }
        IProject proj = this.configNewProject(root, name, natureIds, referencedProjects, monitor);
        int i3 = 0;
        while (i3 < nImports) {
            this.doImports(proj, imports[i3], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i3;
        }
        String open = desc.getAttribute("open");
        if (open != null && open.length() > 0 && (fileToOpen = proj.findMember((IPath)new Path(open))) != null) {
            this.fElementToOpen = fileToOpen;
        }
    }

    private IProject configNewProject(IWorkspaceRoot root, String name, String[] natureIds, IProject[] referencedProjects, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IProject project = root.getProject(name);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription desc = project.getDescription();
            desc.setLocation(null);
            desc.setNatureIds(natureIds);
            desc.setReferencedProjects(referencedProjects);
            project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return project;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void doImports(IProject project, IConfigurationElement curr, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IPath destPath;
            String name = curr.getAttribute("dest");
            if (name == null || name.length() == 0) {
                destPath = project.getFullPath();
            } else {
                IFolder folder = project.getFolder(name);
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                destPath = folder.getFullPath();
            }
            String importPath = curr.getAttribute("src");
            if (importPath == null) {
                importPath = "";
                ExampleProjectsPlugin.log("projectsetup descriptor: import missing");
                return;
            }
            ZipFile zipFile = this.getZipFileFromPluginDir(importPath, this.getContributingPlugin(curr));
            this.importFilesFromZip(zipFile, destPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private IPluginDescriptor getContributingPlugin(IConfigurationElement configurationElement) {
        Object parent = configurationElement;
        while (parent != null) {
            if (parent instanceof IExtension) {
                return ((IExtension)parent).getDeclaringPluginDescriptor();
            }
            parent = parent.getParent();
        }
        return null;
    }

    private ZipFile getZipFileFromPluginDir(String pluginRelativePath, IPluginDescriptor pluginDescriptor) throws CoreException {
        try {
            URL starterURL = new URL(pluginDescriptor.getInstallURL(), pluginRelativePath);
            return new ZipFile(Platform.asLocalURL((URL)starterURL).getFile());
        }
        catch (IOException e) {
            String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
            Status status = new Status(4, ExampleProjectsPlugin.getPluginId(), 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, this.fOverwriteQuery);
        op.run(monitor);
    }
}

