/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.localhistory;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.examples.localhistory.LocalHistorySubscriber;
import org.eclipse.team.examples.localhistory.LocalHistoryVariant;
import org.eclipse.team.examples.localhistory.RevertAllOperation;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class LocalHistoryPartipant
extends SubscriberParticipant {
    public static final String ID = "org.eclipse.team.synchronize.example";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP = "context_group_1";

    public LocalHistoryPartipant() {
        this.setSubscriber(new LocalHistorySubscriber());
    }

    protected void setSubscriber(Subscriber subscriber) {
        super.setSubscriber(subscriber);
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
            this.setInitializationData(descriptor);
            this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        }
        catch (CoreException coreException) {}
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP);
        configuration.addActionContribution((SynchronizePageActionGroup)new LocalHistoryActionContribution());
        configuration.addLabelDecorator((ILabelDecorator)new LocalHistoryDecorator());
    }

    private class LocalHistoryActionContribution
    extends SynchronizePageActionGroup {
        LocalHistoryActionContribution() {
        }

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", LocalHistoryPartipant.CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new SynchronizeModelAction(this, "Revert to latest in local history", configuration){
                final /* synthetic */ LocalHistoryActionContribution this$1;
                {
                    this.this$1 = localHistoryActionContribution;
                }

                protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                    return new RevertAllOperation(configuration, elements);
                }
            });
        }
    }

    private class LocalHistoryDecorator
    extends LabelProvider
    implements ILabelDecorator {
        static /* synthetic */ Class class$0;

        LocalHistoryDecorator() {
        }

        public String decorateText(String text, Object element) {
            ISynchronizeModelElement node;
            if (element instanceof ISynchronizeModelElement && (node = (ISynchronizeModelElement)element) instanceof IAdaptable) {
                SyncInfo info;
                IAdaptable iAdaptable = (IAdaptable)node;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.team.core.synchronize.SyncInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((info = (SyncInfo)iAdaptable.getAdapter((Class)clazz)) != null) {
                    LocalHistoryVariant state = (LocalHistoryVariant)info.getRemote();
                    return String.valueOf(text) + " (" + state.getContentIdentifier() + ")";
                }
            }
            return text;
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }
    }
}

