/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.team.examples.filesystem.ui.GetSynchronizeAction;
import org.eclipse.team.examples.filesystem.ui.PutSynchronizeAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class FileSystemSynchronizeParticipant
extends SubscriberParticipant {
    public static final String ID = "org.eclipse.team.examples.filesystem.participant";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_1 = "context_group_1";

    public FileSystemSynchronizeParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber((Subscriber)FileSystemSubscriber.getInstance());
    }

    protected void setSubscriber(Subscriber subscriber) {
        super.setSubscriber(subscriber);
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
            this.setInitializationData(descriptor);
            this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        }
        catch (CoreException coreException) {}
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        FileSystemParticipantLabelDecorator labelDecorator = new FileSystemParticipantLabelDecorator();
        configuration.addLabelDecorator((ILabelDecorator)labelDecorator);
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        configuration.addActionContribution((SynchronizePageActionGroup)new FileSystemParticipantActionGroup());
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_1);
    }

    private class FileSystemParticipantLabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        FileSystemParticipantLabelDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            try {
                SyncInfo info;
                IResourceVariant variant;
                IResource resource;
                if (element instanceof ISynchronizeModelElement && (resource = ((ISynchronizeModelElement)element).getResource()) != null && resource.getType() == 1 && (variant = (info = FileSystemSubscriber.getInstance().getSyncInfo(resource)).getRemote()) != null) {
                    return String.valueOf(text) + " (" + variant.getContentIdentifier() + ")";
                }
            }
            catch (TeamException teamException) {}
            return null;
        }
    }

    private class FileSystemParticipantActionGroup
    extends SynchronizePageActionGroup {
        FileSystemParticipantActionGroup() {
        }

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", FileSystemSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new GetSynchronizeAction("Get", configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", FileSystemSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new PutSynchronizeAction("Put", configuration));
        }
    }
}

