/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.examples.filesystem.Policy;

public class FileSystemMainPage
extends WizardPage {
    private static final int COMBO_HISTORY_LENGTH = 5;
    String location;
    Combo locationCombo;
    private static final String STORE_LOCATION = "ExamplesFSWizardMainPage.STORE_LOCATION";

    public FileSystemMainPage(String pageName, String title, String description, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(description);
        this.setTitle(title);
    }

    protected Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        return text;
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    protected Combo createEditableCombo(Composite parent) {
        Combo combo = new Combo(parent, 0);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("FileSystemMainPage.location"));
        label.setLayoutData((Object)new GridData());
        this.locationCombo = this.createEditableCombo(composite);
        this.locationCombo.setLayoutData((Object)new GridData(768));
        this.locationCombo.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                FileSystemMainPage.this.location = ((Combo)e.widget).getText();
                FileSystemMainPage.this.validateFields();
            }
        });
        this.locationCombo.setFocus();
        new Label(composite, 0);
        Button browse = new Button(composite, 0);
        browse.setLayoutData((Object)new GridData(128));
        browse.setText(Policy.bind("FileSystemMainPage.browseDir"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog d = new DirectoryDialog(FileSystemMainPage.this.getShell());
                String directory = d.open();
                if (directory != null) {
                    FileSystemMainPage.this.locationCombo.setText(directory);
                }
            }
        });
        this.initializeValues();
        this.validateFields();
    }

    public String getLocation() {
        return this.location;
    }

    public boolean finish(IProgressMonitor monitor) {
        this.saveWidgetValues();
        return true;
    }

    private void initializeValues() {
        String[] locations;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (locations = settings.getArray(STORE_LOCATION)) != null) {
            int i = 0;
            while (i < locations.length) {
                this.locationCombo.add(locations[i]);
                ++i;
            }
            this.locationCombo.select(0);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] locations = settings.getArray(STORE_LOCATION);
            if (locations == null) {
                locations = new String[]{};
            }
            locations = this.addToHistory(locations, this.locationCombo.getText());
            settings.put(STORE_LOCATION, locations);
        }
    }

    private void validateFields() {
        String location = this.locationCombo.getText();
        if (location.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(location);
        if (!file.exists() || !file.isDirectory()) {
            this.setErrorMessage(Policy.bind("FileSystemMainPage.notValidLocation"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

