/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem;

import java.io.File;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.examples.filesystem.FileModificationValidator;
import org.eclipse.team.examples.filesystem.FileSystemOperations;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.Policy;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;

public class FileSystemProvider
extends RepositoryProvider {
    private IPath root;
    private static QualifiedName FILESYSTEM_REPO_LOC = new QualifiedName("org.eclipse.team.examples.filesystem", "disk_location");

    public void configureProject() throws CoreException {
        FileSystemSubscriber.getInstance().handleRootChanged((IResource)this.getProject(), true);
    }

    public void deconfigure() throws CoreException {
        this.getProject().setPersistentProperty(FILESYSTEM_REPO_LOC, null);
        FileSystemSubscriber.getInstance().handleRootChanged((IResource)this.getProject(), false);
    }

    public String getID() {
        return "org.eclipse.team.examples.filesystem.FileSystemProvider";
    }

    public void setTargetLocation(String location) throws TeamException {
        this.root = new Path(location);
        File file = new File(location);
        if (file.exists() && !file.isDirectory()) {
            throw new TeamException(Policy.bind("FileSystemProvider.mustBeFolder", location));
        }
        try {
            this.getProject().setPersistentProperty(FILESYSTEM_REPO_LOC, location);
        }
        catch (CoreException e) {
            throw FileSystemPlugin.wrapException(e);
        }
    }

    public IPath getRoot() {
        if (this.root == null) {
            try {
                String location = this.getProject().getPersistentProperty(FILESYSTEM_REPO_LOC);
                if (location == null) {
                    return null;
                }
                this.root = new Path(location);
            }
            catch (CoreException e) {
                FileSystemPlugin.log(e.getStatus());
                return null;
            }
        }
        return this.root;
    }

    public FileSystemOperations getOperations() {
        return new FileSystemOperations(this);
    }

    public IFileModificationValidator getFileModificationValidator() {
        return new FileModificationValidator(this);
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        File file = this.getFile(resource);
        if (file == null) {
            return null;
        }
        return new FileSystemResourceVariant(file, bytes);
    }

    public IResourceVariant getResourceVariant(IResource resource) {
        File file = this.getFile(resource);
        if (file == null) {
            return null;
        }
        return new FileSystemResourceVariant(file);
    }

    public File getFile(IResource resource) {
        if (resource.getProject().equals((Object)this.getProject())) {
            IPath rootdir = this.getRoot();
            return new File(rootdir.append(resource.getProjectRelativePath()).toOSString());
        }
        return null;
    }
}

