/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.enablement.oda.ws.i18n.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SOAPFaultParser
extends DefaultHandler {
    private final String[] elementNames = new String[]{"faultcode", "faultstring", "reason"};
    private final String[] errorNames = new String[]{Messages.getString("webservice.soap.fault.faultcode"), Messages.getString("webservice.soap.fault.faultstring"), Messages.getString("webservice.soap.fault.reason")};
    private final String SOAP_ENV_COLON_MARK = ":";
    private final String SOAP_ENV_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private final String SOAP_ENV_FAULT = "Fault";
    private final String SOAP_ENV_BLANK_STRING = " ";
    private String[] elementValues = new String[this.elementNames.length];
    private int elementIndex;
    private boolean isSoapFault = false;
    private Map prefixMap = new HashMap();
    private InputStream inputStream;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.datatools.enablement.oda.ws.util.SOAPFaultParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    SOAPFaultParser() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementIndex = -1;
        String[] names = qName.split(":");
        if (names.length == 2 && this.prefixMap.containsKey(names[0])) {
            String namespace = this.prefixMap.get(names[0]).toString().trim();
            String name = names[1].trim();
            if ("http://schemas.xmlsoap.org/soap/envelope/".equalsIgnoreCase(namespace) && name.equalsIgnoreCase("Fault")) {
                this.isSoapFault = true;
            }
        } else {
            int i = 0;
            while (i < this.elementNames.length) {
                if (qName.equalsIgnoreCase(this.elementNames[i])) {
                    this.elementIndex = i;
                    break;
                }
                ++i;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementIndex != -1 && (length > 1 || ch[start] != '\n')) {
            this.elementValues[this.elementIndex] = new String(ch, start, length);
        }
    }

    public boolean isSoapFault() {
        return this.isSoapFault && this.elementValues[0] != null && this.elementValues[1] != null;
    }

    public String getErrorMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.getString("webservice.soap.fault"));
        int i = 0;
        while (i < this.elementNames.length) {
            if (this.elementValues[i] != null) {
                buffer.append(this.errorNames[i]);
                buffer.append(" : ");
                buffer.append(this.elementValues[i]);
                buffer.append(" ");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void parse(InputStream stream) {
        try {
            this.inputStream = stream;
            Object xmlReader = this.createXMLReader();
            this.setContentHandler(xmlReader);
            this.setErrorHandler(xmlReader);
            this.parse(xmlReader);
        }
        catch (Exception exception) {}
    }

    private void parse(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.xml.sax.InputSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method parse = this.getMethod("parse", clazz, classArray);
        try {
            InputSource source = new InputSource(this.inputStream);
            source.setEncoding(source.getEncoding());
            parse.invoke(xmlReader, source);
            this.inputStream.close();
        }
        catch (Exception exception) {}
    }

    private void setErrorHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.xml.sax.ErrorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method setErrorHandler = this.getMethod("setErrorHandler", clazz, classArray);
        this.invokeMethod(setErrorHandler, xmlReader, new Object[]{this});
    }

    private void setContentHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.xml.sax.ContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method setContentHandler = this.getMethod("setContentHandler", clazz, classArray);
        this.invokeMethod(setContentHandler, xmlReader, new Object[]{this});
    }

    private Object createXMLReader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Object xmlReader = Thread.currentThread().getContextClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
            return xmlReader;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
        }
    }

    private Method getMethod(String methodName, Class targetClass, Class[] argument) throws SecurityException, NoSuchMethodException {
        if (!$assertionsDisabled && methodName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && targetClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && argument == null) {
            throw new AssertionError();
        }
        return targetClass.getMethod(methodName, argument);
    }

    private void invokeMethod(Method method, Object targetObject, Object[] argument) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        method.invoke(targetObject, argument);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMap.put(prefix, uri);
    }
}

