/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor;

import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.editor.IExtendedSaveSupport;
import org.eclipse.datatools.sqltools.routineeditor.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.RoutineAnnotationModel;
import org.eclipse.datatools.sqltools.routineeditor.internal.Messages;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLStorageDocumentProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;

public class SQLRoutineDocumentProvider
extends SQLStorageDocumentProvider
implements IRoutineEditorDocumentProvider {
    private SQLEditor _editor;
    static /* synthetic */ Class class$0;

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document;
        if (element instanceof ProcEditorInput) {
            ProcIdentifier procid = ((ProcEditorInput)((Object)element)).getProcIdentifier();
            String text = null;
            try {
                ProcEditorInput input = (ProcEditorInput)((Object)element);
                text = input.getSourceCode();
                if (text == null || "".equals(text.trim())) {
                    IControlConnection controlconnection = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(procid.getDatabaseIdentifier());
                    text = controlconnection.getProcSource(procid);
                    input.setSourceCode(text);
                }
                if (text == null || "".equals(text.trim())) {
                    text = Messages.sqlEditor_SQLEditorDocumentProvider_failGetSource;
                }
            }
            catch (SQLException e) {
                throw new CoreException((IStatus)new Status(4, RoutineEditorActivator.PLUGIN_ID, 0, Messages.sqlEditor_SQLEditorDocumentProvider_failGetSource, (Throwable)e));
            }
            catch (NoSuchProfileException e) {
                throw new CoreException((IStatus)new Status(4, RoutineEditorActivator.PLUGIN_ID, 0, Messages.sqlEditor_SQLEditorDocumentProvider_failGetSource, (Throwable)e));
            }
            document = new Document(text);
        } else {
            document = super.createDocument(element);
        }
        return document;
    }

    public boolean isModifiable(Object element) {
        if (element instanceof ProcEditorInput) {
            return true;
        }
        return super.isModifiable(element);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof ProcEditorInput) {
            ProcIdentifier proc = ((ProcEditorInput)((Object)element)).getProcIdentifier();
            return new RoutineAnnotationModel(proc);
        }
        return super.createAnnotationModel(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.sqltools.sqleditor.SQLEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._editor = (SQLEditor)activeEditor.getAdapter((Class)clazz);
        if (element instanceof ProcEditorInput) {
            ProcIdentifier proc = ((ProcEditorInput)((Object)element)).getProcIdentifier();
            try {
                IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
                SQLDevToolsConfiguration factory = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)proc.getDatabaseIdentifier());
                IExtendedSaveSupport extendedSaveSupport = factory.getSQLEditorService().getExtendedSaveSupport();
                if (extendedSaveSupport != null) {
                    extendedSaveSupport.preSave(controlCon.getReusableConnection(), (TextEditor)this._editor);
                }
                controlCon.saveRoutine(proc, document.get());
                this.refreshFromDatabase(element, controlCon, proc);
                ((ProcEditorInput)((Object)element)).setSourceCode(document.get());
            }
            catch (SQLException e) {
                throw new CoreException((IStatus)new Status(4, RoutineEditorActivator.PLUGIN_ID, 0, NLS.bind((String)Messages.sqlEditor_SQLEditorDocumentProvider_saveDbFail, (Object)e.toString()), (Throwable)e));
            }
            catch (NoSuchProfileException e) {
                throw new CoreException((IStatus)new Status(4, RoutineEditorActivator.PLUGIN_ID, 0, NLS.bind((String)Messages.sqlEditor_SQLEditorDocumentProvider_saveDbFail, (Object)e.toString()), (Throwable)e));
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    public void refreshFromDatabase(Object element, IControlConnection controlCon, ProcIdentifier proc) throws CoreException, SQLException {
        IDocument document = this.getDocument(element);
        document.set(controlCon.getProcSource(proc));
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isReadOnly(Object element) {
        if (element instanceof ProcEditorInput) {
            return false;
        }
        return super.isReadOnly(element);
    }
}

