/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.mysql.MysqlPlugin;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogColumn;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogDatabase;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogForeignKey;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogIndex;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogPrimaryKey;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.impl.PersistentTableImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MySqlCatalogTable
extends PersistentTableImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3761127145711088689L;
    private boolean columnsLoaded = false;
    private boolean constraintLoaded = false;
    private String tableType;
    private boolean isAutoInc;
    private boolean indexLoaded;
    private boolean pkLoaded;

    public void refresh() {
        this.columnsLoaded = false;
        this.constraintLoaded = false;
        this.pkLoaded = false;
        this.indexLoaded = false;
        super.getColumns().clear();
        super.getConstraints().clear();
        super.getIndex().clear();
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((MySqlCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public PrimaryKey getPrimaryKey() {
        if (!this.pkLoaded) {
            this.loadPrimaryKey();
        }
        return this.doGetPrimaryKey();
    }

    private PrimaryKey doGetPrimaryKey() {
        Iterator allConstraints = super.getConstraints().iterator();
        while (allConstraints.hasNext()) {
            Constraint currentConstraint = (Constraint)allConstraints.next();
            if (!(currentConstraint instanceof PrimaryKey)) continue;
            return (PrimaryKey)currentConstraint;
        }
        return null;
    }

    public EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public EList getConstraints() {
        if (!this.constraintLoaded) {
            this.loadConstraints();
        }
        return this.constraints;
    }

    public EList getIndex() {
        if (!this.indexLoaded) {
            this.loadIndexes();
        }
        return this.index;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getColumns();
        } else if (id == 17) {
            this.getConstraints();
        } else if (id == 13) {
            this.getIndex();
        } else if (id == 12) {
            this.getTriggers();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        EList columnList = super.getColumns();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            ResultSet r = metaData.getColumns(null, null, this.getName(), null);
            while (r.next()) {
                String nulls;
                MySqlCatalogColumn column = new MySqlCatalogColumn();
                String columnName = r.getString(4);
                column.setName(columnName);
                String remarks = r.getString(12);
                column.setDescription(remarks);
                String defaultValue = r.getString(13);
                column.setDefaultValue(defaultValue);
                String typeName = r.getString(6);
                DatabaseDefinition databaseDefinition = this.getDatabaseDefinition();
                PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                if (typeDefinition != null) {
                    EStructuralFeature feature;
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)new Integer(r.getInt(7)));
                    } else if (typeDefinition.isPrecisionSupported()) {
                        feature = type.eClass().getEStructuralFeature("precision");
                        type.eSet(feature, (Object)new Integer(r.getInt(10)));
                    }
                    if (typeDefinition.isScaleSupported()) {
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)new Integer(r.getInt(9)));
                    }
                    column.setContainedType((SQLDataType)type);
                }
                if ((nulls = r.getString(18)).equals("YES")) {
                    column.setNullable(true);
                } else {
                    column.setNullable(false);
                }
                columnList.add((Object)column);
            }
            if (this.isAutoInc) {
                this.loadIdentity(this.getConnection());
            }
            this.columnsLoaded = true;
            r.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the Columns for table " + this.getName(), (Throwable)e));
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadIdentity(Connection connection) {
        try {
            Statement s = connection.createStatement();
            String query = "SHOW COLUMNS FROM " + this.getName();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String extra = r.getString("Extra");
                if (extra == null || !extra.equalsIgnoreCase("auto_increment")) continue;
                Column column = this.getColumn(r.getString("Field"));
                Database database = this.getSchema().getDatabase();
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
                IdentitySpecifier identitySpecifier = (IdentitySpecifier)factory.create(SQLSchemaPackage.eINSTANCE.getIdentitySpecifier());
                column.setIdentitySpecifier(identitySpecifier);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the identity type of coulumns for table " + this.getName(), (Throwable)e));
        }
    }

    private synchronized void loadPrimaryKey() {
        if (this.pkLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.pkLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            this.loadPrimaryKey(metaData);
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not get the DatabaseMetaData from connection", (Throwable)e));
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadConstraints() {
        if (this.constraintLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.constraintLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            if (!this.pkLoaded) {
                this.loadPrimaryKey(metaData);
                this.pkLoaded = true;
            }
            this.loadForeignKey(metaData);
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not get the DatabaseMetaData from connection", (Throwable)e));
        }
        this.eSetDeliver(deliver);
    }

    private synchronized MySqlCatalogPrimaryKey loadPrimaryKey(DatabaseMetaData metaData) {
        super.getConstraints();
        MySqlCatalogPrimaryKey key = null;
        try {
            ResultSet r = metaData.getPrimaryKeys(null, null, this.getName());
            KeyColumnCollection columns = new KeyColumnCollection((BaseTable)this);
            while (r.next()) {
                if (key == null) {
                    String name = r.getString(6);
                    key = new MySqlCatalogPrimaryKey();
                    key.setName(name);
                    super.getConstraints().add((Object)key);
                }
                String columnName = r.getString(4);
                int seq = r.getInt(5);
                columns.add(seq, columnName);
            }
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                key.getMembers().add((Object)column);
            }
            r.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the primary keys for table " + this.getName(), (Throwable)e));
        }
        return key;
    }

    private synchronized void loadForeignKey(DatabaseMetaData metaData) {
        try {
            ResultSet r = metaData.getImportedKeys(null, null, this.getName());
            MySqlCatalogForeignKey fk = null;
            MySqlCatalogTable fkTable = null;
            String fkTableName = "";
            String fkName = "";
            while (r.next()) {
                String fkTable_Name = r.getString("PKTABLE_NAME");
                String fk_Name = r.getString("FK_NAME");
                if (!fkTableName.equals(fkTable_Name) || !fkName.equals(fk_Name)) {
                    fkTable = this.getTable(fkTable_Name);
                    if (fkTable == null || fk_Name == null) continue;
                    fkTableName = fkTable_Name;
                    fkName = fk_Name;
                    fk = new MySqlCatalogForeignKey();
                    fk.setName(fk_Name);
                    if (fkTable.getPrimaryKey() != null) {
                        fk.setUniqueConstraint((UniqueConstraint)fkTable.getPrimaryKey());
                    } else {
                        Index index = fkTable.findIndexWithColumnName(r.getString("PKCOLUMN_NAME"));
                        if (index != null) {
                            fk.setUniqueIndex(index);
                        }
                    }
                    short updateRule = r.getShort("UPDATE_RULE");
                    switch (updateRule) {
                        case 0: {
                            fk.setOnUpdate(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnUpdate(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnUpdate(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnUpdate(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        case 3: {
                            fk.setOnUpdate(ReferentialActionType.NO_ACTION_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnUpdate(ReferentialActionType.CASCADE_LITERAL);
                        }
                    }
                    short deleteRule = r.getShort("DELETE_RULE");
                    switch (deleteRule) {
                        case 0: {
                            fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnDelete(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnDelete(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnDelete(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        case 3: {
                            fk.setOnDelete(ReferentialActionType.NO_ACTION_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                        }
                    }
                    short deferrability = r.getShort("DEFERRABILITY");
                    switch (deferrability) {
                        case 5: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(true);
                            break;
                        }
                        case 6: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(false);
                            break;
                        }
                        default: {
                            fk.setDeferrable(false);
                        }
                    }
                    super.getConstraints().add((Object)fk);
                }
                String columnName = r.getString("FKCOLUMN_NAME");
                Column column = this.getColumn(columnName);
                fk.getMembers().add((Object)column);
            }
            r.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the foreign keys for table " + this.getName(), (Throwable)e));
        }
    }

    private Index findIndexWithColumnName(String colName) {
        EList eList = this.getIndex();
        Iterator it = eList.iterator();
        while (it.hasNext()) {
            MySqlCatalogIndex index = (MySqlCatalogIndex)((Object)it.next());
            EList list = index.getMembers();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                IndexMember member = (IndexMember)iter.next();
                if (!member.getColumn().getName().equals(colName)) continue;
                return index;
            }
        }
        return null;
    }

    private synchronized void loadIndexes() {
        if (this.indexLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList indexList = super.getIndex();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            DataModelElementFactory factory = this.getDatabaseDefinition().getDataModelElementFactory();
            ResultSet r = metaData.getIndexInfo(null, null, this.getName(), false, false);
            MySqlCatalogIndex index = null;
            String indexName = "";
            PrimaryKey pk = this.getPrimaryKey();
            while (r.next()) {
                String column_name;
                String indName = r.getString(6);
                if (pk != null && indName.equalsIgnoreCase(pk.getName())) continue;
                if (!indName.equals(indexName)) {
                    indexName = indName;
                    index = new MySqlCatalogIndex();
                    index.setName(indName);
                    index.setSchema(this.getSchema());
                    boolean isUnqiue = !r.getBoolean(4);
                    index.setUnique(isUnqiue);
                    short type = r.getShort(7);
                    if (type == 1) {
                        index.setClustered(true);
                    }
                    indexList.add((Object)index);
                }
                if ((column_name = r.getString(9)) == null) continue;
                IndexMember member = (IndexMember)factory.create(SQLConstraintsPackage.eINSTANCE.getIndexMember());
                member.setColumn(MySqlCatalogTable.getColumn((Table)this, column_name));
                String order = r.getString(10);
                if (order.equals("A")) {
                    member.setIncrementType(IncrementType.ASC_LITERAL);
                } else if (order.equals("D")) {
                    member.setIncrementType(IncrementType.DESC_LITERAL);
                }
                index.getMembers().add((Object)member);
            }
            this.indexLoaded = true;
            r.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the indexes for table " + this.getName(), (Throwable)e));
        }
        this.eSetDeliver(deliver);
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }

    static Column getColumn(Table table, String columnName) {
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column c = (Column)it.next();
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    private Column getColumn(String columnName) {
        Iterator it = super.getColumns().iterator();
        while (it.hasNext()) {
            Column c = (Column)it.next();
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    private MySqlCatalogTable getTable(String tableName) {
        Schema schema = this.getSchema();
        Iterator it = schema.getTables().iterator();
        while (it.hasNext()) {
            MySqlCatalogTable table = (MySqlCatalogTable)((Object)it.next());
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public boolean isAutoInc() {
        return this.isAutoInc;
    }

    public void setAutoInc(boolean autoInc) {
        this.isAutoInc = autoInc;
    }

    private static class KeyColumnCollection {
        private Map keyMap = new TreeMap();
        private BaseTable table;

        public KeyColumnCollection(BaseTable table) {
            this.table = table;
        }

        public void add(int seq, String name) {
            Column column = this.getColumn(name);
            String key = "k" + seq;
            this.keyMap.put(key, column);
        }

        public Iterator iterator() {
            return this.keyMap.values().iterator();
        }

        private Column getColumn(String name) {
            Iterator it = this.table.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!column.getName().equals(name)) continue;
                return column;
            }
            return null;
        }
    }
}

