/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.oda.profile.provider.ProfilePropertyProviderImpl;

public class OdaProfileExplorer {
    private static OdaProfileExplorer sm_instance;
    private static final String sm_className;
    private static Logger sm_logger;
    private Map m_loadedProfilesByFile;
    private File m_defaultProfileStoreFile;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        sm_instance = null;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OdaProfileExplorer getInstance() {
        if (sm_instance != null) return sm_instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (sm_instance != null) return sm_instance;
            sm_instance = new OdaProfileExplorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            sm_instance = null;
            sm_logger = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (sm_logger != null) return sm_logger;
            sm_logger = Logger.getLogger(sm_className);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    protected OdaProfileExplorer() {
    }

    public void refresh() {
        if (this.m_loadedProfilesByFile == null || this.m_loadedProfilesByFile.isEmpty()) {
            return;
        }
        this.m_loadedProfilesByFile.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getLoadedProfilesMap() {
        if (this.m_loadedProfilesByFile == null) {
            OdaProfileExplorer odaProfileExplorer = this;
            synchronized (odaProfileExplorer) {
                if (this.m_loadedProfilesByFile == null) {
                    this.m_loadedProfilesByFile = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        return this.m_loadedProfilesByFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File defaultProfileStoreFile() {
        if (this.m_defaultProfileStoreFile == null) {
            OdaProfileExplorer odaProfileExplorer = this;
            synchronized (odaProfileExplorer) {
                if (this.m_defaultProfileStoreFile == null) {
                    this.m_defaultProfileStoreFile = ConnectionProfileMgmt.getStorageLocation().append("ServerProfiles.dat").toFile();
                }
            }
        }
        return this.m_defaultProfileStoreFile;
    }

    public Map getProfiles(String odaDataSourceId) throws OdaException {
        return this.getProfileIdentifiersByOdaProviderId(odaDataSourceId, null);
    }

    public Map getProfiles(String odaDataSourceId, File storageFile) throws OdaException {
        return this.getProfileIdentifiersByOdaProviderId(odaDataSourceId, storageFile);
    }

    public Map getProfileIdentifiersByOdaProviderId(String odaDataSourceId, File storageFile) throws OdaException {
        return this.getProfileIdentifiersByCategoryOrProviderId(null, odaDataSourceId, storageFile);
    }

    public Map getProfileIdentifiersByCategory(String categoryId, File storageFile) throws OdaException {
        return this.getProfileIdentifiersByCategoryOrProviderId(categoryId, null, storageFile);
    }

    private Map getProfileIdentifiersByCategoryOrProviderId(String categoryId, String odaDataSourceId, File storageFile) throws OdaException {
        IConnectionProfile[] profilesInFile = this.loadProfiles(storageFile);
        Properties profileIds = new Properties();
        int i = 0;
        while (i < profilesInFile.length) {
            IConnectionProfile aProfile = profilesInFile[i];
            if (!(categoryId != null ? !aProfile.getCategory().getId().equals(categoryId) : odaDataSourceId == null || !aProfile.getProviderId().equals(odaDataSourceId))) {
                this.addProfileIdentifier(aProfile, profileIds);
            }
            ++i;
        }
        return profileIds;
    }

    private IConnectionProfile[] loadProfiles(File storageFile) throws OdaException {
        IConnectionProfile[] profilesInFile;
        if (storageFile == null) {
            OdaProfileExplorer.getLogger().fine("A null storageFile argument is specified. Using default profile storage location instead.");
            storageFile = this.defaultProfileStoreFile();
        }
        if ((profilesInFile = this.getLoadedProfiles(storageFile)) != null) {
            return profilesInFile;
        }
        try {
            profilesInFile = ConnectionProfileMgmt.loadCPs((File)storageFile);
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
        return this.addToCacheByFile(storageFile, profilesInFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConnectionProfile[] addToCacheByFile(File storageFile, IConnectionProfile[] profilesInFile) {
        IConnectionProfile[] cachedProfiles;
        Map loadedProfilesMap;
        Map map = loadedProfilesMap = this.getLoadedProfilesMap();
        synchronized (map) {
            cachedProfiles = (IConnectionProfile[])loadedProfilesMap.get(storageFile);
            if (cachedProfiles == null) {
                cachedProfiles = profilesInFile;
                loadedProfilesMap.put(storageFile, cachedProfiles);
            }
        }
        return cachedProfiles;
    }

    private IConnectionProfile[] getLoadedProfiles(File storageFile) {
        return (IConnectionProfile[])this.getLoadedProfilesMap().get(storageFile);
    }

    private void addProfileIdentifier(IConnectionProfile profile, Properties profileIds) {
        if (!($assertionsDisabled || profile != null && profileIds != null)) {
            throw new AssertionError();
        }
        String profileDisplayName = profile.getDescription();
        if (profileDisplayName == null || profileDisplayName.length() == 0) {
            profileDisplayName = profile.getName();
        }
        profileIds.setProperty(profile.getInstanceID(), profileDisplayName);
    }

    private void addToProfileManagerCache(IConnectionProfile profile) throws OdaException {
        try {
            ProfileManager.getInstance().addProfile(profile, true);
        }
        catch (ConnectionProfileException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    public Properties getProfileProperties(String profileInstanceId) {
        IConnectionProfile profile = this.getProfile(profileInstanceId);
        return profile.getBaseProperties();
    }

    public Properties getProfileProperties(String profileInstanceId, File storageFile) {
        IConnectionProfile profile = null;
        try {
            profile = this.getProfileById(profileInstanceId, storageFile);
        }
        catch (OdaException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        if (profile == null) {
            throw new IllegalArgumentException(profileInstanceId);
        }
        return profile.getBaseProperties();
    }

    public IConnectionProfile getProfile(String profileInstanceId) {
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByInstanceID(profileInstanceId);
        if (profile == null) {
            throw new IllegalArgumentException(profileInstanceId);
        }
        return this.createOdaWrapper(profile);
    }

    public IConnectionProfile getProfileById(String profileInstanceId, File storageFile) throws OdaException {
        IConnectionProfile[] profilesInFile = this.loadProfiles(storageFile);
        int i = 0;
        while (i < profilesInFile.length) {
            if (profilesInFile[i].getInstanceID().equals(profileInstanceId)) {
                return this.createOdaWrapper(profilesInFile[i]);
            }
            ++i;
        }
        return null;
    }

    public IConnectionProfile getProfileByName(String profileName, File storageFile) throws OdaException {
        IConnectionProfile[] profilesInFile = this.loadProfiles(storageFile);
        int i = 0;
        while (i < profilesInFile.length) {
            if (this.matchesProfileName(profilesInFile[i].getName(), profileName)) {
                return this.createOdaWrapper(profilesInFile[i]);
            }
            ++i;
        }
        return null;
    }

    private boolean matchesProfileName(String profileName, String nameToMatch) {
        return profileName.equals(nameToMatch);
    }

    public IConnectionProfile getProfileByName(Properties dataSourceDesignProps, Object appContext) {
        Object connPropContext = null;
        if (appContext != null && appContext instanceof Map) {
            connPropContext = ((Map)appContext).get("OdaConnPropertyContext");
        }
        ProfilePropertyProviderImpl profileProvider = new ProfilePropertyProviderImpl();
        profileProvider.setRefreshProfileStore(false);
        return this.createOdaWrapper(profileProvider.getConnectionProfile(dataSourceDesignProps, connPropContext));
    }

    private OdaConnectionProfile createOdaWrapper(IConnectionProfile wrappedProfile) {
        if (wrappedProfile == null) {
            return null;
        }
        if (wrappedProfile instanceof OdaConnectionProfile && ((OdaConnectionProfile)wrappedProfile).hasWrappedProfile()) {
            return (OdaConnectionProfile)wrappedProfile;
        }
        return new OdaConnectionProfile(wrappedProfile);
    }
}

