/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lpg.lpgjavaruntime.BacktrackingParser;
import lpg.lpgjavaruntime.BadParseException;
import lpg.lpgjavaruntime.BadParseSymFileException;
import lpg.lpgjavaruntime.DiagnoseParser;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.NotBacktrackParseTableException;
import lpg.lpgjavaruntime.NullExportedSymbolsException;
import lpg.lpgjavaruntime.NullTerminalSymbolsException;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.RuleAction;
import lpg.lpgjavaruntime.Token;
import lpg.lpgjavaruntime.TokenStream;
import lpg.lpgjavaruntime.UndefinedEofSymbolException;
import lpg.lpgjavaruntime.UnimplementedTerminalsException;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.util.SQLLogUtil;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserLogger;
import org.eclipse.datatools.sqltools.parsers.sql.lexer.AbstractSQLLexer;

public abstract class AbstractSQLParser
extends PrsStream
implements RuleAction {
    protected static final int ERROR_DIAGNOSING_NONE = 0;
    protected static final int ERROR_DIAGNOSING_UNLIMITED = Integer.MAX_VALUE;
    protected static final int ERROR_DIAGNOSING_TIME = 1500;
    protected static final int ERROR_DIAGNOSING_MAX_NUMBER = 10;
    protected static final int ERROR_DIAGNOSING_TIME_LIMIT = 3000;
    protected static final int ERROR_DIAGNOSING_MIN_NUMBER = 1;
    ParseTable prs;
    protected BacktrackingParser btParser;
    protected boolean checkStmtOnly;
    protected List astElementList;
    protected Object lastASTElement;
    protected List errorInfoList;
    protected SQLQuerySourceFormat sourceFormat;
    private int errorDiagnosingTimeMax;
    private int errorDiagnosingNumberMax;
    public static final int K_SUFFIX = 1000;
    public static final int M_SUFFIX = 1000000;
    public static final int G_SUFFIX = 1000000000;
    private static final String ERROR_LOCATION_STRING_SEPARATOR = ":";
    private static final String ERROR_TEXT_QUOTE = "\"";
    private static WeakHashMap parserClassToLexerClassToKindMapping = new WeakHashMap();
    private int[] kindMap;
    static /* synthetic */ Class class$0;

    public abstract void ruleAction(int var1);

    public abstract String[] orderedTerminalSymbols();

    protected void addCommentsToAST(List commentTokens) {
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractSQLParser(LexStream lexStream, ParseTable prs, int EOFTsymbol, SQLQuerySourceFormat p_sourceFormat, boolean checkStmtOnly) throws SQLParserInternalException {
        block9: {
            super(lexStream);
            this.checkStmtOnly = false;
            this.lastASTElement = null;
            this.errorInfoList = null;
            this.errorDiagnosingTimeMax = 1500;
            this.errorDiagnosingNumberMax = 10;
            this.kindMap = null;
            this.prs = prs;
            this.sourceFormat = p_sourceFormat;
            this.astElementList = new ArrayList<E>();
            this.checkStmtOnly = checkStmtOnly;
            try {
                this.btParser = new BacktrackingParser((TokenStream)this, prs, (RuleAction)this);
            }
            catch (NotBacktrackParseTableException e) {
                errorMsg = "****Error: Regenerate SQLQueryParserprs.java with -BACKTRACK option";
                SQLParserLogger.getLogger().writeInfo(errorMsg);
                throw new SQLParserInternalException(e, errorMsg);
            }
            catch (BadParseSymFileException e) {
                errorMsg = "****Error: Bad Parser Symbol File -- SQLQueryParsersym.java";
                SQLParserLogger.getLogger().writeInfo(errorMsg);
                throw new SQLParserInternalException(e, errorMsg);
            }
            try {
                this.remapTerminalSymbols(this.orderedTerminalSymbols(), EOFTsymbol);
            }
            catch (NullExportedSymbolsException v0) {
            }
            catch (NullTerminalSymbolsException v1) {
            }
            catch (UnimplementedTerminalsException e) {
                unimplemented_symbols = e.getSymbols();
                SQLParserLogger.getLogger().writeInfo("The Lexer will not scan the following token(s):");
                i = 0;
                ** while (i < unimplemented_symbols.size())
            }
lbl-1000:
            // 1 sources

            {
                id = (Integer)unimplemented_symbols.get(i);
                SQLParserLogger.getLogger().writeInfo("    " + this.orderedTerminalSymbols()[id]);
                ++i;
                continue;
            }
lbl39:
            // 1 sources

            SQLParserLogger.getLogger().writeInfo("\n");
            break block9;
            catch (UndefinedEofSymbolException v2) {
                SQLParserLogger.getLogger().writeInfo("The Lexer does not implement the Eof symbol " + this.orderedTerminalSymbols()[EOFTsymbol]);
                System.exit(12);
            }
        }
    }

    AbstractSQLParser(LexStream lexStream, ParseTable prs, int EOFTsymbol, boolean checkStmtOnly) throws SQLParserInternalException {
        this(lexStream, prs, EOFTsymbol, SQLQuerySourceFormat.copyDefaultFormat(), checkStmtOnly);
    }

    AbstractSQLParser(LexStream lexStream, ParseTable prs, int EOFTsymbol, SQLQuerySourceFormat sourceFormat) throws SQLParserInternalException {
        this(lexStream, prs, EOFTsymbol, sourceFormat, false);
    }

    protected Object getSym(int p_sym) {
        return this.btParser.getSym(p_sym);
    }

    protected List getList(int p_sym) {
        Object sym = null;
        sym = this.btParser.getSym(p_sym);
        if (sym instanceof List) {
            return (List)sym;
        }
        if (sym == null) {
            return null;
        }
        SQLLogUtil sQLLogUtil = SQLParserLogger.getLogger();
        StringBuffer stringBuffer = new StringBuffer("Error in getList.  Expected ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sQLLogUtil.writeInfo(stringBuffer.append(clazz).append(" but got ").append(sym.getClass()).append(" on token ").append(p_sym).toString());
        return null;
    }

    protected String getString(int p_sym) {
        Object sym = this.btParser.getSym(p_sym);
        if (sym != null) {
            return sym.toString();
        }
        return null;
    }

    protected int getInt(int p_sym) {
        Object sym = this.btParser.getSym(p_sym);
        if (sym instanceof Integer) {
            return (Integer)sym;
        }
        if (sym instanceof String) {
            try {
                return Integer.parseInt((String)sym);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    protected boolean getBoolean(int p_sym) {
        Object sym = this.btParser.getSym(p_sym);
        if (sym != null && sym instanceof Boolean) {
            return (Boolean)sym;
        }
        SQLParserLogger.getLogger().writeLog("Error in SQLQueryParser#getBoolean(int). Couldn't retrieve boolean value, returned false.");
        return false;
    }

    protected void setSpan(SQLQueryObject p_stmt) {
        p_stmt.getSourceInfo().setSourceSnippet(this.getSpan());
        p_stmt.getSourceInfo().setSpanStartOffset(this.getSpanStartOffset());
        p_stmt.getSourceInfo().setSpanEndOffset(this.getSpanEndOffset());
        int i = this.btParser.getFirstToken();
        p_stmt.getSourceInfo().setColumnNumberStart(this.getColumn(i));
        p_stmt.getSourceInfo().setLineNumberStart(this.getLine(i));
        i = this.btParser.getLastToken();
        p_stmt.getSourceInfo().setColumnNumberEnd(this.getEndColumn(i));
        p_stmt.getSourceInfo().setLineNumberEnd(this.getEndLine(i));
    }

    protected String getSpan() {
        int beg = this.getSpanStartOffset();
        int end = this.getSpanEndOffset();
        return this.getSpan(beg, end);
    }

    protected String getSpan(int beg, int end) {
        return String.valueOf(this.getInputChars(), beg, end - beg + 1);
    }

    protected int getSpanStartOffset() {
        return this.getStartOffset(this.btParser.getFirstToken());
    }

    protected int getSpanEndOffset() {
        return this.getEndOffset(this.btParser.getLastToken());
    }

    protected IToken getFollowingToken() {
        return this.getTokenAt(this.getNext(this.btParser.getLastToken()));
    }

    protected int getSpanStartOffset(int token) {
        return this.getStartOffset(this.btParser.getToken(token));
    }

    protected int getSpanEndOffset(int token) {
        return this.getEndOffset(this.btParser.getToken(token));
    }

    protected void setSym1(Object p_obj) {
        this.btParser.setSym1(p_obj);
        if (p_obj != null && this.lastASTElement != p_obj && p_obj instanceof SQLObject) {
            this.astElementList.add(p_obj);
            this.lastASTElement = p_obj;
        }
    }

    protected void setInt1(int p_int) {
        this.btParser.setSym1((Object)new Integer(p_int));
    }

    protected void setBoolean1(boolean p_boolean) {
        this.btParser.setSym1((Object)new Boolean(p_boolean));
    }

    protected List getASTElementList() {
        return this.astElementList;
    }

    public int getToken(int p_tok) {
        return this.btParser.getToken(p_tok);
    }

    protected char[] data() {
        return this.getInputChars();
    }

    protected Token getTokenObject(int p_tok) {
        return (Token)this.getTokens().get(this.getToken(p_tok));
    }

    protected String getTokenName(int p_tok) {
        Token token = this.getTokenObject(p_tok);
        return String.valueOf(this.data(), token.getStartOffset(), token.getEndOffset() - token.getStartOffset() + 1);
    }

    protected List parser() throws SQLParserException, SQLParserInternalException {
        try {
            List commentTokens;
            List stmtList = (List)this.btParser.parse();
            if (this.hasComments() && (commentTokens = ((AbstractSQLLexer)this.getLexStream()).getCommentTokens()) != null && !this.checkStmtOnly && (this.sourceFormat == null || this.sourceFormat.isPreserveComments())) {
                this.addCommentsToAST(commentTokens);
            }
            return stmtList;
        }
        catch (BadParseException e) {
            this.reset(e.error_token);
            if (this.errorDiagnosingNumberMax > 0 && this.errorDiagnosingTimeMax > 0) {
                this.diagnose(e);
            }
            throw new SQLParserException(e, this, this.prs);
        }
        catch (NumberFormatException e) {
            throw new SQLParserException(e.getMessage(), e);
        }
    }

    public void diagnose(BadParseException bpe) {
        DiagnoseParser diagnoseParser = null;
        diagnoseParser = this.errorDiagnosingNumberMax == Integer.MAX_VALUE || this.errorDiagnosingTimeMax == Integer.MAX_VALUE ? new DiagnoseParser((TokenStream)this, this.prs) : new DiagnoseParser((TokenStream)this, this.prs, this.errorDiagnosingNumberMax, (long)this.errorDiagnosingTimeMax);
        diagnoseParser.diagnose(bpe.error_token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diagnoseParseErrors(BadParseException e) {
        AbstractSQLParser abstractSQLParser = this;
        synchronized (abstractSQLParser) {
            DiagnoseParsingThread diagnoseParseError = new DiagnoseParsingThread(e, this);
            diagnoseParseError.start();
            try {
                long currentTime = System.currentTimeMillis();
                long endTime = currentTime + (long)this.errorDiagnosingTimeMax;
                long exceededEndTime = currentTime + 3000L;
                while (diagnoseParseError.isAlive() && endTime > currentTime) {
                    if (this.errorInfoList != null && this.errorInfoList.size() >= this.errorDiagnosingNumberMax) break;
                    ((Object)((Object)this)).wait(50L);
                    currentTime = System.currentTimeMillis();
                    if (currentTime <= endTime || currentTime >= exceededEndTime || this.errorInfoList != null && this.errorInfoList.size() >= 1) continue;
                    endTime += 100L;
                }
                if (diagnoseParseError.isAlive()) {
                    diagnoseParseError.stop();
                }
            }
            catch (InterruptedException e1) {
                System.err.println("\n\nDiagnoseParsingThread " + diagnoseParseError + " interupted!\n\n");
                e1.printStackTrace();
            }
        }
    }

    protected boolean hasComments() {
        List commentTokens;
        return !this.checkStmtOnly && this.getLexStream() instanceof AbstractSQLLexer && (commentTokens = ((AbstractSQLLexer)this.getLexStream()).getCommentTokens()) != null && commentTokens.size() > 0;
    }

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        if (errorCode == 6 || errorCode == 8) {
            tokenText = "";
        }
        if (this.errorInfoList == null) {
            this.errorInfoList = new ArrayList();
        }
        if (tokenText.startsWith(ERROR_TEXT_QUOTE) && tokenText.endsWith(ERROR_TEXT_QUOTE)) {
            tokenText = tokenText.substring(1, tokenText.length() - 1);
        }
        String[] errorPosition = locationInfo.split(ERROR_LOCATION_STRING_SEPARATOR);
        int errorLineBegin = 0;
        int errorColBegin = 0;
        int errorLineEnd = 0;
        int errorColEnd = 0;
        if (errorPosition != null && errorPosition.length > 4) {
            errorLineBegin = Integer.parseInt(errorPosition[1].trim());
            errorColBegin = Integer.parseInt(errorPosition[2].trim());
            errorLineEnd = Integer.parseInt(errorPosition[3].trim());
            errorColEnd = Integer.parseInt(errorPosition[4].trim());
        }
        String input = this.getTokenText(leftToken);
        String expectedInput = tokenText;
        this.errorInfoList.add(new SQLParseErrorInfo(errorLineBegin, errorColBegin, errorLineEnd, errorColEnd, input, expectedInput, errorMsgText[errorCode], "LPG-ERROR-CODE:" + errorCode));
    }

    protected static final int[] getSpecificKindMap(Class parserClass, Class lexerClass) {
        Map lexerTerminalSymbolRemapping = (Map)parserClassToLexerClassToKindMapping.get(parserClass);
        if (lexerTerminalSymbolRemapping != null) {
            return (int[])lexerTerminalSymbolRemapping.get(lexerClass);
        }
        return null;
    }

    protected static final void setSpecificKindMap(Class parserClass, Class lexerClass, int[] kindRemapping) {
        WeakHashMap<Class, int[]> lexerTerminalSymbolRemapping = (WeakHashMap<Class, int[]>)parserClassToLexerClassToKindMapping.get(parserClass);
        if (lexerTerminalSymbolRemapping == null) {
            lexerTerminalSymbolRemapping = new WeakHashMap<Class, int[]>();
            parserClassToLexerClassToKindMapping.put(parserClass, lexerTerminalSymbolRemapping);
        }
        lexerTerminalSymbolRemapping.put(lexerClass, kindRemapping);
    }

    public void remapTerminalSymbols(String[] ordered_parser_symbols, int eof_symbol) throws UndefinedEofSymbolException, NullExportedSymbolsException, NullTerminalSymbolsException, UnimplementedTerminalsException {
        this.kindMap = AbstractSQLParser.getSpecificKindMap(((Object)((Object)this)).getClass(), this.getLexStream().getClass());
        if (this.kindMap == null) {
            String[] ordered_lexer_symbols = this.getLexStream().orderedExportedSymbols();
            if (ordered_lexer_symbols == null) {
                throw new NullExportedSymbolsException();
            }
            if (ordered_parser_symbols == null) {
                throw new NullTerminalSymbolsException();
            }
            ArrayList<Integer> unimplemented_symbols = new ArrayList<Integer>();
            if (ordered_lexer_symbols != ordered_parser_symbols) {
                this.kindMap = new int[ordered_lexer_symbols.length];
                HashMap<String, Integer> terminal_map = new HashMap<String, Integer>();
                int i = 0;
                while (i < ordered_lexer_symbols.length) {
                    terminal_map.put(ordered_lexer_symbols[i], new Integer(i));
                    ++i;
                }
                i = 0;
                while (i < ordered_parser_symbols.length) {
                    Integer k = (Integer)terminal_map.get(ordered_parser_symbols[i]);
                    if (k != null) {
                        this.kindMap[k.intValue()] = i;
                    } else {
                        if (i == eof_symbol) {
                            throw new UndefinedEofSymbolException();
                        }
                        unimplemented_symbols.add(new Integer(i));
                    }
                    ++i;
                }
            }
            if (unimplemented_symbols.size() > 0) {
                throw new UnimplementedTerminalsException(unimplemented_symbols);
            }
            AbstractSQLParser.setSpecificKindMap(((Object)((Object)this)).getClass(), this.getLexStream().getClass(), this.kindMap);
        }
    }

    public void makeToken(int startLoc, int endLoc, int kind) {
        Token t = new Token((PrsStream)this, startLoc, endLoc, this.kindMap == null ? kind : this.kindMap[kind]);
        this.getTokens().add(t);
    }

    public int getErrorDiagnosingNumberMax() {
        return this.errorDiagnosingNumberMax;
    }

    public void setErrorDiagnosingNumberMax(int errorDiagnosingNumberMax) {
        this.errorDiagnosingNumberMax = errorDiagnosingNumberMax;
    }

    public int getErrorDiagnosingTimeMax() {
        return this.errorDiagnosingTimeMax;
    }

    public void setErrorDiagnosingTimeMax(int errorDiagnosingTimeMax) {
        this.errorDiagnosingTimeMax = errorDiagnosingTimeMax;
    }

    public void resetParser(LexStream lexStream) {
        this.resetTokenStream();
        this.astElementList = new ArrayList();
        this.lastASTElement = null;
        this.errorInfoList = new ArrayList();
        this.resetLexStream(lexStream);
    }

    public boolean isCheckStmtOnly() {
        return this.checkStmtOnly;
    }

    public void setCheckStmtOnly(boolean checkStmtOnly) {
        this.checkStmtOnly = checkStmtOnly;
    }

    private class DiagnoseParsingThread
    extends Thread {
        private BadParseException badParseException = null;
        private AbstractSQLParser sqlParser = null;

        protected DiagnoseParsingThread(BadParseException e, AbstractSQLParser parser) {
            this.badParseException = e;
            this.sqlParser = parser;
        }

        public void run() {
            this.sqlParser.diagnose(this.badParseException);
        }
    }
}

