/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.services.IColumnHelperService;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class ColumnHelper
implements IColumnHelperService {
    private DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    private static final String BLANK = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private ReferenceConstraint[] getConstraints(Column column, Class type) {
        Table parentTable = column.getTable();
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        if (parentTable instanceof BaseTable) {
            EList constraints = ((BaseTable)parentTable).getConstraints();
            Iterator i = constraints.iterator();
            while (i.hasNext()) {
                Constraint constraint = (Constraint)i.next();
                if (!type.isAssignableFrom(constraint.getClass())) continue;
                list.add(constraint);
            }
        }
        return list.toArray(new ReferenceConstraint[list.size()]);
    }

    private ReferenceConstraint getConstraint(Column column, Class type) {
        ReferenceConstraint[] constraints = this.getConstraints(column, type);
        int i = 0;
        int n = constraints.length;
        while (i < n) {
            Iterator iterator = constraints[i].getMembers().iterator();
            while (iterator.hasNext()) {
                if (!column.equals(iterator.next())) continue;
                return constraints[i];
            }
            ++i;
        }
        return null;
    }

    public Table getParentTableOfForeignKey(Column column) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.constraints.ForeignKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ForeignKey constraint = (ForeignKey)this.getConstraint(column, clazz);
        return constraint.getUniqueConstraint().getBaseTable();
    }

    public boolean isPrimaryKey(Column column) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getConstraint(column, clazz) != null;
    }

    public boolean isForeignKey(Column column) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.constraints.ForeignKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getConstraint(column, clazz) != null;
    }

    private void removeConstraint(Column column, ReferenceConstraint constraint) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            ((BaseTable)table).getConstraints().remove((Object)constraint);
        }
    }

    public String getDataType(Column column) {
        Database database;
        Catalog catalog;
        Schema schema;
        DataType datatype = column.getDataType();
        Table table = column.getTable();
        if (table != null && (schema = table.getSchema()) != null && ((catalog = schema.getCatalog()) != null && (database = catalog.getDatabase()) != null || (database = schema.getDatabase()) != null)) {
            DatabaseDefinition definition = this.dbRegistry.getDefinition(database);
            if (datatype != null) {
                if (datatype instanceof PredefinedDataType) {
                    return definition.getPredefinedDataTypeFormattedName((PredefinedDataType)datatype);
                }
                return datatype.getName();
            }
        }
        return BLANK;
    }

    public void updateConstraintsOnColumnDeleted(Column column) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ReferenceConstraint[] constraints = this.getConstraints(column, clazz);
        int i = 0;
        int n = constraints.length;
        while (i < n) {
            ReferenceConstraint constraint = constraints[i];
            EList members = constraint.getMembers();
            int j = 0;
            while (j < members.size()) {
                Column currentColumn = (Column)members.get(j);
                if (currentColumn.equals(column)) {
                    members.remove((Object)currentColumn);
                    break;
                }
                ++j;
            }
            if (members.size() == 0) {
                this.removeConstraint(column, constraint);
            }
            ++i;
        }
    }
}

