/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util;

import java.net.URI;
import java.util.HashMap;

public class ResourceIdentifiers {
    public static final String ODA_APP_CONTEXT_KEY_CONSUMER_RESOURCE_IDS = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds";
    private static final String APPL_RESOURCE_BASE_URI = "ApplResourceBaseURI";
    private static final String DESIGN_RESOURCE_BASE_URI = "DesignResourceBaseURI";
    private HashMap m_uriLocators = new HashMap(2);

    public URI getApplResourceBaseURI() {
        return this.getCustomResourceBaseURI(APPL_RESOURCE_BASE_URI);
    }

    public void setApplResourceBaseURI(URI baseURI) {
        this.setCustomResourceBaseURI(APPL_RESOURCE_BASE_URI, baseURI);
    }

    public URILocator getApplResourceURILocator() {
        return this.getCustomResourceURILocator(APPL_RESOURCE_BASE_URI);
    }

    public void registerApplResourceURILocator(URILocator uriLocator) {
        this.registerCustomResourceURILocator(APPL_RESOURCE_BASE_URI, uriLocator);
    }

    public URI getDesignResourceBaseURI() {
        return this.getCustomResourceBaseURI(DESIGN_RESOURCE_BASE_URI);
    }

    public void setDesignResourceBaseURI(URI baseURI) {
        this.setCustomResourceBaseURI(DESIGN_RESOURCE_BASE_URI, baseURI);
    }

    public URILocator getDesignResourceURILocator() {
        return this.getCustomResourceURILocator(DESIGN_RESOURCE_BASE_URI);
    }

    public void registerDesignResourceURILocator(URILocator uriLocator) {
        this.registerCustomResourceURILocator(DESIGN_RESOURCE_BASE_URI, uriLocator);
    }

    private URI getCustomResourceBaseURI(String customResourceType) {
        URILocator locator = this.getCustomResourceURILocator(customResourceType);
        return locator != null ? locator.getBaseURI() : null;
    }

    private void setCustomResourceBaseURI(String customResourceType, URI baseURI) {
        URILocator locator = this.createURILocator(baseURI);
        this.registerCustomResourceURILocator(customResourceType, locator);
    }

    private URILocator getCustomResourceURILocator(String customResourceType) {
        return (URILocator)this.m_uriLocators.get(customResourceType);
    }

    private void registerCustomResourceURILocator(String customResourceType, URILocator uriLocator) {
        this.m_uriLocators.put(customResourceType, uriLocator);
    }

    protected URILocator createURILocator(URI baseURI) {
        return new URILocator(baseURI);
    }

    public class URILocator {
        private URI m_baseURI;

        public URILocator(URI baseURI) {
            this.m_baseURI = baseURI;
        }

        public URI getBaseURI() {
            return this.m_baseURI;
        }

        public URI resolve(URI uri) {
            return this.resolveImpl(uri);
        }

        protected URI resolveImpl(URI uri) {
            if (this.m_baseURI == null) {
                return uri;
            }
            return this.m_baseURI.resolve(uri);
        }
    }
}

