/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeData;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeDataUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

final class TreePopulationUtil {
    static final String ATTRIBUTE_MARK = "@";
    static final String ROOT = "ROOT";
    static final String EMPTY_STRING = "";
    static final String PATH_SEPERATOR = "/";

    TreePopulationUtil() {
    }

    static void populateTreeItems(Object tree, Object[] node, String xPathExpression, boolean includeAttr) throws OdaException {
        int i = 0;
        while (i < node.length) {
            if (includeAttr || ((ATreeNode)node[i]).getType() != 2) {
                TreeItem treeItem = tree instanceof TreeItem ? new TreeItem((TreeItem)tree, 0) : new TreeItem((Tree)tree, 0);
                ATreeNode aTreeNode = (ATreeNode)node[i];
                TreeNodeData treeNode = new TreeNodeData(aTreeNode);
                if (aTreeNode.getType() == 1) {
                    if (aTreeNode.getParent() != null && ROOT.equals(aTreeNode.getParent().getValue())) {
                        treeItem.setImage(TreeNodeDataUtil.getSourceFileImage());
                    } else if (aTreeNode.getChildren() == null || aTreeNode.getChildren().length == 0) {
                        treeItem.setImage(TreeNodeDataUtil.getColumnImage());
                    } else {
                        treeItem.setImage(TreeNodeDataUtil.getXmlElementImage());
                    }
                }
                treeItem.setData((Object)treeNode);
                int type = treeNode.getTreeNode().getType();
                if (type == 2) {
                    treeItem.setText(ATTRIBUTE_MARK + treeNode.getTreeNode().getValue().toString());
                } else {
                    treeItem.setText(treeNode.getTreeNode().getValue().toString());
                    String populateString = XPathPopulationUtil.populateColumnPath((String)TreePopulationUtil.getRootPathWithOutFilter(xPathExpression), (String)TreePopulationUtil.generateXpathFromATreeNode(aTreeNode));
                    if (EMPTY_STRING.equals(populateString)) {
                        FontData fontData = new FontData(EMPTY_STRING, 8, 1);
                        treeItem.setFont(new Font(null, fontData));
                    }
                }
                if (treeNode.getTreeNode().getChildren().length > 0) {
                    new TreeItem(treeItem, 0);
                }
            }
            ++i;
        }
    }

    static String getRootPathWithOutFilter(String xPathExpression) {
        return xPathExpression.replaceAll("\\Q[\\E.*\\Q]\\E", EMPTY_STRING);
    }

    static String generateXpathFromATreeNode(ATreeNode aTreeNode) {
        String columnPath = (String)aTreeNode.getValue();
        if (aTreeNode.getType() == 2) {
            columnPath = ATTRIBUTE_MARK + columnPath;
        }
        ATreeNode parent = aTreeNode.getParent();
        while (parent != null) {
            if (parent.getType() == 1 && columnPath != null && columnPath.trim().length() > 0) {
                columnPath = parent.getValue() + PATH_SEPERATOR + columnPath;
            } else if (parent.getType() == 2) {
                columnPath = String.valueOf(columnPath) + PATH_SEPERATOR + ATTRIBUTE_MARK + parent.getValue();
            }
            parent = parent.getParent();
        }
        if (!columnPath.startsWith(PATH_SEPERATOR)) {
            columnPath = PATH_SEPERATOR + columnPath;
        }
        return columnPath;
    }
}

