/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.deltaddl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlBuilder;
import org.eclipse.datatools.enablement.ase.deltaddl.SybaseASEProcedureDeltaDdlProvider;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASETrigger;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASETriggerDeltaDdlProvider
extends AbstractDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseASEDdlConstants {
    private static final String DECLARE = "declare @name varchar(767)\r\ndeclare @newname varchar(767)\r\nselect @name = <<@name>>\r\nselect @newname = <<@newname>>\r\n";
    private static final String BACKUP = "declare @name varchar(767)\r\ndeclare @newname varchar(767)\r\nselect @name = <<@name>>\r\nselect @newname = <<@newname>>\r\ndeclare @backupstatus int\r\nexec @backupstatus = sp_rename @name, @newname\r\n";
    private static final String DROP = "if not exists(select 1 from sysobjects where uid = user_id(<<@owner>>) and name=<<@name>>)\r\nbegin\r\n    declare @oldname varchar(767)\r\n    declare @newname varchar(767)\r\n    select @oldname = <<@oldname>>\r\n    select @newname = <<@newname>>\r\n    exec sp_rename @newname, @oldname --restore\r\nend \r\nelse if exists(select 1 from sysobjects where uid = user_id(<<@owner>>) and name=<<@newname>>)\r\nbegin\r\n    exec ('drop trigger '+<<@newname>>)\r\nend \r\n";

    public void analyze(SQLObject element, Map changeMap, Map changedRecords) {
    }

    public void processAlterStatement(SQLObject element, Map modifyRecordMap, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor monitor) {
        if (!(element instanceof SybaseASETrigger)) {
            return;
        }
        SybaseASETrigger trigger = (SybaseASETrigger)element;
        String owner = SQLUtil.quote((String)trigger.getSchema().getName(), (String)"'");
        List records = (List)modifyRecordMap.get(element);
        if (records != null) {
            String name;
            SybaseDdlBuilder builder = SybaseASEDdlBuilder.getInstance();
            String[] trigBody = builder.createTrigger((Trigger)trigger, quoteIdentifiers, qualifyNames, fullSyntax);
            String source = trigBody[trigBody.length / 2];
            String oldname = name = SQLUtil.quote((String)trigger.getName(), (String)"'");
            boolean enableChanged = false;
            boolean nameChanged = false;
            Iterator iter = records.iterator();
            while (iter.hasNext()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord r = (SybaseDeltaDdlGeneration.FeatureChangeRecord)iter.next();
                if (r.feature.getFeatureID() == 1 && r.changed == trigger) {
                    oldname = SQLUtil.quote((String)((String)r.oldValue), (String)"'");
                    nameChanged = true;
                }
                if (r.feature.getFeatureID() != 22 || r.changed != trigger) continue;
                enableChanged = true;
            }
            if (!enableChanged || records.size() != 1) {
                String tempname = SQLUtil.quote((String)SybaseASEProcedureDeltaDdlProvider.makeNewName(oldname), (String)"'");
                String alter = BACKUP.replaceAll("<<@name>>", oldname).replaceAll("<<@newname>>", tempname);
                script.addCreateTriggerStatement(alter);
                script.addCreateTriggerStatement(source);
                String drop = DROP.replaceAll("<<@owner>>", owner).replaceAll("<<@name>>", name).replaceAll("<<@newname>>", tempname).replaceAll("<<@oldname>>", oldname);
                script.addCreateTriggerStatement(drop);
            }
            if (enableChanged || nameChanged) {
                StringBuffer sb = new StringBuffer(128);
                sb.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getTableName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames));
                if (trigger.isEnabled()) {
                    sb.append(" ").append("ENABLE").append(" ");
                } else {
                    sb.append(" ").append("DISABLE").append(" ");
                }
                sb.append("TRIGGER").append(" ").append(builder.getName((ENamedElement)trigger, quoteIdentifiers, qualifyNames));
                script.addAlterOtherStatements(sb.toString());
            }
        }
    }

    public String getTableName(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = table.getName();
        String schemaName = table.getSchema().getName();
        String databaseName = table.getSchema().getCatalog().getName();
        if (quoteIdentifiers) {
            name = SQLDevToolsUtil.quoteWhenNecessary((String)name, (DatabaseIdentifier)SQLDevToolsUtil.getDatabaseIdentifier((SQLObject)table));
        }
        if (qualifyNames) {
            name = String.valueOf(databaseName) + "." + schemaName + "." + name;
        }
        return name;
    }

    public void processCreateStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void processDropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, DDLGenerator generator, IProgressMonitor monitor) {
    }

    protected void addCreateStatement(SybaseDdlScript script, String statement) {
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
    }

    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
    }
}

