/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCreateChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.swt.widgets.Shell;

public class ConnectionProfileDeleteChange
extends Change {
    private IConnectionProfile mProfileToDelete;

    public ConnectionProfileDeleteChange(IConnectionProfile profile, DeleteArguments args) {
        this.mProfileToDelete = profile;
    }

    public String getName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPDeleteChange.name"), this.mProfileToDelete.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.mProfileToDelete == null) {
            result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPDeleteChange.error.ProfileDoesNotExist"));
        } else {
            String path = ProfileManager.getInstance().getProfilePath(this.mProfileToDelete);
            if (ProfileManager.getInstance().getProfileByFullPath(path) == null) {
                result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPDeleteChange.error.ProfileDoesNotExist"));
            }
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        CompositeChange undo = new CompositeChange(this.getName());
        undo.markAsSynthetic();
        undo.add(this.deleteProfile(pm));
        return undo;
    }

    public Object getModifiedElement() {
        return this.mProfileToDelete;
    }

    private Change deleteProfile(IProgressMonitor pm) {
        Shell shell = new Shell();
        try {
            ProfileManager.getInstance().deleteProfile(this.mProfileToDelete);
        }
        catch (ConnectionProfileException e) {
            ExceptionHandler.showException(shell, ConnectivityUIPlugin.getDefault().getResourceString("CPDeleteChange.delete.failure"), e.getLocalizedMessage(), e);
            return new NullChange();
        }
        return new ConnectionProfileCreateChange(this.mProfileToDelete, shell);
    }
}

